/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.plots.jfreechart;

import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.title.LegendTitle;

public class StyleGuide {
    private final String fontName = "Arial";
    private final Font titleFont;
    private final Font axisLabelFont;
    private final Font annotationFont;
    private final Font tickLabelFont;
    private final Color chartBackgroundPaint;
    private final Color plotBackgroundPaint;

    public StyleGuide(double scale) {
        this.titleFont = new Font("SansSerif", 0, (int)Math.round(10.0 * scale));
        this.axisLabelFont = new Font("SansSerif", 0, (int)Math.round(10.0 * scale));
        this.annotationFont = new Font("SansSerif", 0, (int)Math.round(8.0 * scale));
        this.tickLabelFont = new Font("SansSerif", 0, (int)Math.round(9.0 * scale));
        this.chartBackgroundPaint = new Color(250, 250, 250);
        this.plotBackgroundPaint = new Color(255, 255, 255);
    }

    public static void applyStyleToChart(JFreeChart chart) {
        new StyleGuide(1.0).applyStyleToChart2(chart);
    }

    public static void applyStyleToXYPlot(XYPlot xyPlot) {
        new StyleGuide(1.0).applyStyleToXYPlot2(xyPlot);
    }

    public void applyStyleToChart2(JFreeChart chart) {
        XYPlot xyPlot;
        LegendTitle legend;
        chart.setBackgroundPaint((Paint)this.chartBackgroundPaint);
        if (chart.getTitle() != null) {
            chart.getTitle().setFont(this.titleFont);
        }
        if ((legend = chart.getLegend()) != null) {
            legend.setBackgroundPaint((Paint)this.chartBackgroundPaint);
        }
        if ((xyPlot = chart.getXYPlot()) != null) {
            this.applyStyleToXYPlot2(xyPlot);
        }
    }

    public void applyStyleToXYPlot2(XYPlot xyPlot) {
        ValueAxis axis;
        int i;
        for (i = 0; i < xyPlot.getDomainAxisCount(); ++i) {
            axis = xyPlot.getDomainAxis(i);
            if (axis == null) continue;
            axis.setTickLabelFont(this.tickLabelFont);
            axis.setLabelFont(this.axisLabelFont);
        }
        xyPlot.setDomainAxisLocation(AxisLocation.BOTTOM_OR_LEFT);
        for (i = 0; i < xyPlot.getRangeAxisCount(); ++i) {
            axis = xyPlot.getRangeAxis(i);
            if (axis == null) continue;
            axis.setTickLabelFont(this.tickLabelFont);
            axis.setLabelFont(this.axisLabelFont);
        }
        xyPlot.setRangeAxisLocation(AxisLocation.BOTTOM_OR_LEFT);
        xyPlot.setBackgroundPaint((Paint)this.plotBackgroundPaint);
    }

    public Font getAxisLabelFont() {
        return this.axisLabelFont;
    }

    public Font getTickLabelFont() {
        return this.tickLabelFont;
    }

    public Font getTitleFont() {
        return this.titleFont;
    }
}

