/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.plots.util;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.transcoder.SVGAbstractTranscoder;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.fop.svg.PDFTranscoder;
import org.jfree.chart.JFreeChart;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public class JFreeChartToFile {
    public static void saveToSVG(JFreeChart chart, File svgFile, int width, int height) throws IOException {
        DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
        Document document = domImpl.createDocument(null, "svg", null);
        SVGGraphics2D svgGenerator = new SVGGraphics2D(document);
        chart.draw((Graphics2D)svgGenerator, (Rectangle2D)new Rectangle(width, height));
        FileOutputStream outputStream = new FileOutputStream(svgFile);
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)outputStream, "UTF-8");
        svgGenerator.stream((Writer)out, true);
        outputStream.flush();
        ((OutputStream)outputStream).close();
    }

    public static void saveToPDF(JFreeChart chart, File pdfFile, int width, int height) throws IOException {
        DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
        Document document = domImpl.createDocument(null, "svg", null);
        SVGGraphics2D svgGenerator = new SVGGraphics2D(document);
        chart.draw((Graphics2D)svgGenerator, (Rectangle2D)new Rectangle(width, height));
        StringWriter stringWriter = new StringWriter();
        svgGenerator.stream((Writer)stringWriter, true);
        TranscoderInput input = new TranscoderInput((Reader)new StringReader(stringWriter.toString()));
        PDFTranscoder transcoder = new PDFTranscoder();
        transcoder.addTranscodingHint(SVGAbstractTranscoder.KEY_WIDTH, (Object)Float.valueOf(width));
        transcoder.addTranscodingHint(SVGAbstractTranscoder.KEY_HEIGHT, (Object)Float.valueOf(height));
        FileOutputStream outputStream = new FileOutputStream(pdfFile);
        BufferedOutputStream bos = new BufferedOutputStream(outputStream);
        TranscoderOutput transOutput = new TranscoderOutput((OutputStream)bos);
        try {
            transcoder.transcode(input, transOutput);
        }
        catch (TranscoderException e) {
            throw new RuntimeException(e);
        }
    }
}

