/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.climate.models.dice;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.logging.Logger;
import net.finmath.climate.models.AbatementModel;
import net.finmath.climate.models.CarbonConcentration;
import net.finmath.climate.models.ClimateModel;
import net.finmath.climate.models.SavingsRateModel;
import net.finmath.climate.models.Temperature;
import net.finmath.climate.models.dice.submodels.AbatementCostFunction;
import net.finmath.climate.models.dice.submodels.CarbonConcentration3DScalar;
import net.finmath.climate.models.dice.submodels.DamageFromTemperature;
import net.finmath.climate.models.dice.submodels.EmissionExternalFunction;
import net.finmath.climate.models.dice.submodels.EvolutionOfCapital;
import net.finmath.climate.models.dice.submodels.EvolutionOfCarbonConcentration;
import net.finmath.climate.models.dice.submodels.EvolutionOfEmissionIndustrialIntensity;
import net.finmath.climate.models.dice.submodels.EvolutionOfPopulation;
import net.finmath.climate.models.dice.submodels.EvolutionOfProductivity;
import net.finmath.climate.models.dice.submodels.EvolutionOfTemperature;
import net.finmath.climate.models.dice.submodels.ForcingExternalFunction;
import net.finmath.climate.models.dice.submodels.ForcingFunction;
import net.finmath.climate.models.dice.submodels.Temperature2DScalar;
import net.finmath.stochastic.RandomVariable;
import net.finmath.stochastic.Scalar;
import net.finmath.time.TimeDiscretization;

public class DICEModel
implements ClimateModel {
    private static Logger logger = Logger.getLogger("net.finmath.climate");
    private final TimeDiscretization timeDiscretization;
    private final UnaryOperator<Double> abatementFunction;
    private final UnaryOperator<Double> savingsRateFunction;
    private final double discountRate;
    private Temperature2DScalar[] temperature;
    private CarbonConcentration3DScalar[] carbonConcentration;
    private double[] gdp;
    private double[] emission;
    private double[] abatement;
    private double[] abatementCosts;
    private double[] damage;
    private double[] damageCosts;
    private double[] capital;
    private double[] population;
    private double[] productivity;
    private double[] consumptions;
    private double[] welfare;
    private double[] value;

    public DICEModel(TimeDiscretization timeDiscretization, UnaryOperator<Double> abatementFunction, UnaryOperator<Double> savingsRateFunction, double discountRate, Map<String, Object> modelProperties) {
        this.timeDiscretization = timeDiscretization;
        this.abatementFunction = abatementFunction;
        this.savingsRateFunction = savingsRateFunction;
        this.discountRate = discountRate;
        int numberOfTimes = this.timeDiscretization.getNumberOfTimes();
        this.temperature = new Temperature2DScalar[numberOfTimes];
        this.carbonConcentration = new CarbonConcentration3DScalar[numberOfTimes];
        this.gdp = new double[numberOfTimes];
        this.emission = new double[numberOfTimes];
        this.abatement = new double[numberOfTimes];
        this.abatementCosts = new double[numberOfTimes];
        this.damage = new double[numberOfTimes];
        this.damageCosts = new double[numberOfTimes];
        this.capital = new double[numberOfTimes];
        this.population = new double[numberOfTimes];
        this.productivity = new double[numberOfTimes];
        this.consumptions = new double[numberOfTimes];
        this.welfare = new double[numberOfTimes];
        this.value = new double[numberOfTimes];
        this.init(modelProperties);
    }

    public DICEModel(TimeDiscretization timeDiscretization, UnaryOperator<Double> abatementFunction, UnaryOperator<Double> savingsRateFunction, double discountRate) {
        this(timeDiscretization, abatementFunction, savingsRateFunction, discountRate, Map.of());
    }

    public DICEModel(TimeDiscretization timeDiscretization, UnaryOperator<Double> abatementFunction) {
        this(timeDiscretization, abatementFunction, t -> 0.259029014481802, 0.03);
    }

    private void init(Map<String, Object> modelProperties) {
        Predicate<Integer> isTimeIndexToShift = modelProperties.getOrDefault("isTimeIndexToShift", i -> true);
        double initialEmissionShift = (Double)modelProperties.getOrDefault("initialEmissionShift", 0.0);
        double initialConsumptionShift = (Double)modelProperties.getOrDefault("initialConsumptionShift", 0.0);
        double timeStep = this.timeDiscretization.getTimeStep(0);
        Temperature2DScalar temperatureInitial = new Temperature2DScalar(0.85, 0.0068);
        CarbonConcentration3DScalar carbonConcentrationInitial = new CarbonConcentration3DScalar(851.0, 460.0, 1740.0);
        DamageFromTemperature damageFunction = new DamageFromTemperature();
        EvolutionOfEmissionIndustrialIntensity emissionIndustrialIntensityFunction = new EvolutionOfEmissionIndustrialIntensity(this.timeDiscretization);
        EmissionExternalFunction emissionExternalFunction = new EmissionExternalFunction();
        EvolutionOfCarbonConcentration evolutionOfCarbonConcentration = new EvolutionOfCarbonConcentration(this.timeDiscretization);
        ForcingFunction forcingFunction = new ForcingFunction();
        ForcingExternalFunction forcingExternalFunction = new ForcingExternalFunction();
        EvolutionOfTemperature evolutionOfTemperature = new EvolutionOfTemperature(this.timeDiscretization);
        AbatementCostFunction abatementCostFunction = new AbatementCostFunction();
        double K0 = 223.0;
        double L0 = 7403.0;
        double A0 = 5.115;
        double gamma = 0.3;
        double gdpInitial = 5.115 * Math.pow(223.0, 0.3) * Math.pow(7.403, 0.7);
        EvolutionOfCapital evolutionOfCapital = new EvolutionOfCapital(this.timeDiscretization);
        EvolutionOfPopulation evolutionOfPopulation = new EvolutionOfPopulation(this.timeDiscretization);
        EvolutionOfProductivity evolutionOfProductivity = new EvolutionOfProductivity(this.timeDiscretization);
        this.temperature[0] = temperatureInitial;
        this.carbonConcentration[0] = carbonConcentrationInitial;
        this.gdp[0] = gdpInitial;
        this.capital[0] = 223.0;
        this.population[0] = 7403.0;
        this.productivity[0] = 5.115;
        double utilityDiscountedSum = 0.0;
        double emissionIntensity = 0.33981042654028437;
        for (int timeIndex = 0; timeIndex < this.timeDiscretization.getNumberOfTimeSteps(); ++timeIndex) {
            double abatementCostAbsolute;
            double damageCostAbsolute;
            double time = this.timeDiscretization.getTime(timeIndex);
            this.abatement[timeIndex] = (Double)this.abatementFunction.apply(this.timeDiscretization.getTime(timeIndex));
            double emissionIndustrial = emissionIntensity / (1.0 - this.abatement[0]) * this.gdp[timeIndex];
            double emissionExternal = (Double)emissionExternalFunction.apply(time);
            this.emission[timeIndex] = (1.0 - this.abatement[timeIndex]) * emissionIndustrial + emissionExternal;
            int n = timeIndex;
            this.emission[n] = this.emission[n] + (isTimeIndexToShift.test(timeIndex) ? initialEmissionShift : 0.0);
            this.carbonConcentration[timeIndex + 1] = evolutionOfCarbonConcentration.apply(timeIndex, this.carbonConcentration[timeIndex], this.emission[timeIndex]);
            double forcingExternal = forcingExternalFunction.apply(time + timeStep);
            double forcing = forcingFunction.apply(this.carbonConcentration[timeIndex + 1], forcingExternal);
            this.temperature[timeIndex + 1] = evolutionOfTemperature.apply(timeIndex, this.temperature[timeIndex], forcing);
            this.damage[timeIndex] = damageFunction.applyAsDouble(this.temperature[timeIndex].getExpectedTemperatureOfAtmosphere());
            this.damageCosts[timeIndex] = damageCostAbsolute = this.damage[timeIndex] * this.gdp[timeIndex];
            this.abatementCosts[timeIndex] = abatementCostAbsolute = abatementCostFunction.apply(time, this.abatement[timeIndex]) * emissionIndustrial;
            double gdpNet = this.gdp[timeIndex] - damageCostAbsolute - abatementCostAbsolute;
            double abatementCost = abatementCostFunction.apply(time, this.abatement[timeIndex]) * emissionIntensity / (1.0 - this.abatement[0]);
            double gdpNet2 = this.gdp[timeIndex] * (1.0 - this.damage[timeIndex] - abatementCost);
            if (Math.abs(gdpNet2 - gdpNet) / (1.0 + Math.abs(gdpNet)) > 1.0E-10) {
                logger.warning("Calculation of relative and absolute net GDP does not match.");
            }
            emissionIntensity = emissionIndustrialIntensityFunction.apply(timeIndex, emissionIntensity);
            double savingsRate = (Double)this.savingsRateFunction.apply(time);
            double consumption = (1.0 - savingsRate) * gdpNet;
            double investment = savingsRate * gdpNet;
            this.consumptions[timeIndex] = consumption += isTimeIndexToShift.test(timeIndex) ? initialConsumptionShift : 0.0;
            this.capital[timeIndex + 1] = evolutionOfCapital.apply(timeIndex).apply(this.capital[timeIndex], investment);
            this.population[timeIndex + 1] = evolutionOfPopulation.apply(timeIndex).apply(this.population[timeIndex]);
            this.productivity[timeIndex + 1] = evolutionOfProductivity.apply(timeIndex).apply(this.productivity[timeIndex]);
            double L = this.population[timeIndex + 1];
            double A = this.productivity[timeIndex + 1];
            this.gdp[timeIndex + 1] = A * Math.pow(this.capital[timeIndex + 1], 0.3) * Math.pow(L / 1000.0, 0.7);
            double alpha = 1.45;
            double C = consumption;
            double utility = this.population[timeIndex] * ((Math.pow(1000.0 * C / this.population[timeIndex], 1.0 - alpha) - 1.0) / (1.0 - alpha) - 1.0);
            double discountFactor = Math.exp(-this.discountRate * time);
            this.welfare[timeIndex] = utility * discountFactor;
            this.value[timeIndex + 1] = utilityDiscountedSum += utility * discountFactor * timeStep;
        }
    }

    @Override
    public TimeDiscretization getTimeDiscretization() {
        return this.timeDiscretization;
    }

    @Override
    public RandomVariable getTemperature(double time) {
        return Scalar.of(this.temperature[this.timeDiscretization.getTimeIndex(time)].getExpectedTemperatureOfAtmosphere());
    }

    @Override
    public RandomVariable getValue() {
        return Scalar.of(this.value[this.value.length - 1]);
    }

    @Override
    public RandomVariable[] getValues() {
        return (RandomVariable[])Arrays.stream(this.value).mapToObj(Scalar::of).toArray(RandomVariable[]::new);
    }

    @Override
    public RandomVariable[] getAbatement() {
        return (RandomVariable[])Arrays.stream(this.abatement).mapToObj(Scalar::of).toArray(RandomVariable[]::new);
    }

    @Override
    public RandomVariable[] getEmission() {
        return (RandomVariable[])Arrays.stream(this.emission).mapToObj(Scalar::of).toArray(RandomVariable[]::new);
    }

    @Override
    public CarbonConcentration[] getCarbonConcentration() {
        return this.carbonConcentration;
    }

    @Override
    public Temperature[] getTemperature() {
        return this.temperature;
    }

    @Override
    public RandomVariable[] getDamage() {
        return (RandomVariable[])Arrays.stream(this.damage).mapToObj(Scalar::of).toArray(RandomVariable[]::new);
    }

    @Override
    public RandomVariable[] getGDP() {
        return (RandomVariable[])Arrays.stream(this.gdp).mapToObj(Scalar::of).toArray(RandomVariable[]::new);
    }

    @Override
    public RandomVariable[] getConsumptions() {
        return (RandomVariable[])Arrays.stream(this.consumptions).mapToObj(Scalar::of).toArray(RandomVariable[]::new);
    }

    @Override
    public RandomVariable[] getAbatementCosts() {
        return (RandomVariable[])Arrays.stream(this.abatementCosts).mapToObj(Scalar::of).toArray(RandomVariable[]::new);
    }

    @Override
    public RandomVariable getAbatementCost() {
        double abatementCost = 0.0;
        for (int timeIndex = 0; timeIndex < this.timeDiscretization.getNumberOfTimes(); ++timeIndex) {
            abatementCost += this.abatementCosts[timeIndex] * Math.exp(-this.discountRate * this.timeDiscretization.getTime(timeIndex));
        }
        return Scalar.of(abatementCost);
    }

    @Override
    public RandomVariable[] getDamageCosts() {
        return (RandomVariable[])Arrays.stream(this.damageCosts).mapToObj(Scalar::of).toArray(RandomVariable[]::new);
    }

    @Override
    public RandomVariable getDamageCost() {
        double damageCost = 0.0;
        for (int timeIndex = 0; timeIndex < this.timeDiscretization.getNumberOfTimes(); ++timeIndex) {
            damageCost += this.damageCosts[timeIndex] * Math.exp(-this.discountRate * this.timeDiscretization.getTime(timeIndex));
        }
        return Scalar.of(damageCost);
    }

    @Override
    public RandomVariable getNumeraire(double time) {
        return Scalar.of(Math.exp(this.discountRate * time));
    }

    public AbatementModel getAbatementModel() {
        return (AbatementModel)this.abatementFunction.andThen(Scalar::new).andThen(RandomVariable.class::cast);
    }

    public SavingsRateModel getSavingsRateModel() {
        return (SavingsRateModel)this.savingsRateFunction.andThen(Scalar::new).andThen(RandomVariable.class::cast);
    }

    public RandomVariable getDisocuntFactor(double time) {
        return this.getNumeraire(0.0).div(this.getNumeraire(time));
    }
}

