/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.climate.models.dice.submodels;

import java.util.function.BiFunction;

public class AbatementCostFunction
implements BiFunction<Double, Double, Double> {
    private final double backstopPriceInitial;
    private final double backstopRate;
    private final double abatementExponent;

    public AbatementCostFunction(double backstopPriceInitial, double backstopRate, double abatementExponent) {
        this.backstopPriceInitial = backstopPriceInitial;
        this.backstopRate = backstopRate;
        this.abatementExponent = abatementExponent;
    }

    public AbatementCostFunction() {
        this(0.55, -Math.log(0.975) / 5.0, 2.6);
    }

    @Override
    public Double apply(Double time, Double abatement) {
        double backstopPrice = this.backstopPriceInitial * Math.exp(-this.backstopRate * time);
        double abatementCost = backstopPrice * Math.pow(abatement, this.abatementExponent) / this.abatementExponent;
        return abatementCost;
    }
}

