/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.climate.models.dice.submodels;

import net.finmath.climate.models.CarbonConcentration;
import net.finmath.stochastic.RandomVariable;
import net.finmath.stochastic.Scalar;
import org.apache.commons.lang3.Validate;

public class CarbonConcentration3DScalar
implements CarbonConcentration {
    private final double carbonConcentrationInAtmosphere;
    private final double carbonConcentrationInShallowOcean;
    private final double carbonConcentrationInLowerOcean;

    public CarbonConcentration3DScalar(double carbonConcentrationInAtmosphere, double carbonConcentrationInShallowOcean, double carbonConcentrationInLowerOcean) {
        Validate.isTrue((carbonConcentrationInAtmosphere >= 0.0 ? 1 : 0) != 0, (String)"carbonConcentrationInAtmosphere must not be negative.", (double)carbonConcentrationInAtmosphere);
        Validate.isTrue((carbonConcentrationInShallowOcean >= 0.0 ? 1 : 0) != 0, (String)"carbonConcentrationInShallowOcean must not be negative.", (double)carbonConcentrationInShallowOcean);
        Validate.isTrue((carbonConcentrationInLowerOcean >= 0.0 ? 1 : 0) != 0, (String)"carbonConcentrationInLowerOcean must not be negative.", (double)carbonConcentrationInLowerOcean);
        this.carbonConcentrationInAtmosphere = carbonConcentrationInAtmosphere;
        this.carbonConcentrationInShallowOcean = carbonConcentrationInShallowOcean;
        this.carbonConcentrationInLowerOcean = carbonConcentrationInLowerOcean;
    }

    public CarbonConcentration3DScalar(double[] carbonConcentration) {
        this(carbonConcentration[0], carbonConcentration[1], carbonConcentration[2]);
    }

    public CarbonConcentration3DScalar() {
        this(851.0, 460.0, 1740.0);
    }

    @Override
    public Double getExpectedCarbonConcentrationInAtmosphere() {
        return this.carbonConcentrationInAtmosphere;
    }

    @Override
    public RandomVariable getCarbonConcentrationInAtmosphere() {
        return Scalar.of(this.carbonConcentrationInAtmosphere);
    }

    public double getCarbonConcentrationInShallowOcean() {
        return this.carbonConcentrationInShallowOcean;
    }

    public double getCarbonConcentrationInLowerOcean() {
        return this.carbonConcentrationInLowerOcean;
    }

    public double[] getAsDoubleArray() {
        return new double[]{this.carbonConcentrationInAtmosphere, this.carbonConcentrationInShallowOcean, this.carbonConcentrationInLowerOcean};
    }
}

