/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.climate.models.dice.submodels;

import java.util.function.Function;

public class EmissionExternalFunction
implements Function<Double, Double> {
    private final double externalEmissionsInitial;
    private final double externalEmissionsDecay;
    private static double annualizedExternalEmissionsDecay = -Math.log(0.885) / 5.0;

    public EmissionExternalFunction(double externalEmissionsInitial, double externalEmissionsDecay) {
        this.externalEmissionsInitial = externalEmissionsInitial;
        this.externalEmissionsDecay = externalEmissionsDecay;
    }

    public EmissionExternalFunction() {
        this(2.6, annualizedExternalEmissionsDecay);
    }

    @Override
    public Double apply(Double time) {
        double externalEmissions = this.externalEmissionsInitial * Math.exp(-this.externalEmissionsDecay * time);
        return externalEmissions;
    }
}

