/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.climate.models.dice.submodels;

import java.util.function.BiFunction;
import net.finmath.time.TimeDiscretization;

public class EmissionIndustrialIntensityFunction
implements BiFunction<Integer, Double, Double> {
    private static double e0 = 35.85;
    private static double q0 = 105.5;
    private static double sigma0 = e0 / q0;
    private final TimeDiscretization timeDiscretization;
    private final double emissionIntensityInitial;
    private final double emissionIntensityRateInitial;
    private final double emissionIntensityRateDecay;

    public EmissionIndustrialIntensityFunction(TimeDiscretization timeDiscretization, double emissionIntensityInitial, double emissionIntensityRateInitial, double emissionIntensityRateDecay) {
        this.timeDiscretization = timeDiscretization;
        this.emissionIntensityInitial = emissionIntensityInitial;
        this.emissionIntensityRateInitial = emissionIntensityRateInitial;
        this.emissionIntensityRateDecay = emissionIntensityRateDecay;
    }

    public EmissionIndustrialIntensityFunction(TimeDiscretization timeDiscretization) {
        this(timeDiscretization, sigma0, 0.0152, -Math.log(0.999));
    }

    @Override
    public Double apply(Integer timeIndex, Double _emissionIntensity) {
        double time = this.timeDiscretization.getTime(timeIndex);
        double emissionIntensityRate = this.emissionIntensityRateInitial * Math.exp(-this.emissionIntensityRateDecay * time);
        double emissionIntensity = this.emissionIntensityInitial * Math.exp((emissionIntensityRate - this.emissionIntensityRateInitial) / this.emissionIntensityRateDecay);
        return emissionIntensity;
    }

    public TimeDiscretization getTimeDiscretization() {
        return this.timeDiscretization;
    }

    public double getEmissionIntensityInitial() {
        return this.emissionIntensityInitial;
    }

    public double getEmissionIntensityRateInitial() {
        return this.emissionIntensityRateInitial;
    }

    public double getEmissionIntensityRateDecay() {
        return this.emissionIntensityRateDecay;
    }
}

