/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.climate.models.dice.submodels;

import java.util.function.BiFunction;
import java.util.function.Function;
import net.finmath.time.TimeDiscretization;

public class EvolutionOfCapital
implements Function<Integer, BiFunction<Double, Double, Double>> {
    private final TimeDiscretization timeDiscretization;
    private final double capitalDeprecation;

    public EvolutionOfCapital(TimeDiscretization timeDiscretization, double capitalDeprecation) {
        this.timeDiscretization = timeDiscretization;
        this.capitalDeprecation = capitalDeprecation;
    }

    public EvolutionOfCapital(TimeDiscretization timeDiscretization) {
        this(timeDiscretization, -Math.log(0.9));
    }

    @Override
    public BiFunction<Double, Double, Double> apply(Integer timeIndex) {
        double timeStep = this.timeDiscretization.getTimeStep(timeIndex);
        return (capital, investment) -> capital * Math.exp(-this.capitalDeprecation * timeStep) + investment * timeStep;
    }
}

