/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.climate.models.dice.submodels;

import java.util.function.Function;
import net.finmath.climate.models.dice.submodels.CarbonConcentration3DScalar;
import net.finmath.functions.LinearAlgebra;
import net.finmath.time.TimeDiscretization;
import net.finmath.util.Cached;
import net.finmath.util.TriFunction;

public class EvolutionOfCarbonConcentration
implements TriFunction<Integer, CarbonConcentration3DScalar, Double, CarbonConcentration3DScalar> {
    private static double conversionGtCperGtCO2 = 0.27277686852154936;
    private static double[][] transitionMatrix5YDefault;
    private final TimeDiscretization timeDiscretization;
    private final Function<Integer, double[][]> transitionMatrices;

    public EvolutionOfCarbonConcentration(TimeDiscretization timeDiscretization, Function<Integer, double[][]> transitionMatrices) {
        this.timeDiscretization = timeDiscretization;
        this.transitionMatrices = transitionMatrices;
    }

    public EvolutionOfCarbonConcentration(TimeDiscretization timeDiscretization) {
        Function<Integer, Double> timeSteps = timeIndex -> timeDiscretization.getTimeStep((int)timeIndex);
        this.timeDiscretization = timeDiscretization;
        this.transitionMatrices = timeSteps.andThen(Cached.of(timeStep -> timeStep == 5.0 ? transitionMatrix5YDefault : LinearAlgebra.matrixPow(transitionMatrix5YDefault, timeStep / 5.0)));
    }

    @Override
    public CarbonConcentration3DScalar apply(Integer timeIndex, CarbonConcentration3DScalar carbonConcentration, Double emissions) {
        double timeStep = this.timeDiscretization.getTimeStep(timeIndex);
        double[] carbonConcentrationNext = LinearAlgebra.multMatrixVector(this.transitionMatrices.apply(timeIndex), carbonConcentration.getAsDoubleArray());
        carbonConcentrationNext[0] = carbonConcentrationNext[0] + emissions * timeStep * conversionGtCperGtCO2;
        return new CarbonConcentration3DScalar(carbonConcentrationNext);
    }

    public TimeDiscretization getTimeDiscretization() {
        return this.timeDiscretization;
    }

    static {
        double b12 = 0.12;
        double b23 = 0.007;
        double mateq = 588.0;
        double mueq = 360.0;
        double mleq = 1720.0;
        double zeta11 = 0.88;
        double zeta21 = 0.12;
        double zeta12 = 0.19599999999999998;
        double zeta22 = 0.797;
        double zeta32 = 0.007;
        double zeta23 = 0.0014651162790697675;
        double zeta33 = 0.9985348837209302;
        transitionMatrix5YDefault = new double[][]{{0.88, 0.19599999999999998, 0.0}, {0.12, 0.797, 0.0014651162790697675}, {0.0, 0.007, 0.9985348837209302}};
    }
}

