/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.climate.models.dice.submodels;

import java.util.function.BiFunction;
import net.finmath.time.TimeDiscretization;

public class EvolutionOfEmissionIndustrialIntensity
implements BiFunction<Integer, Double, Double> {
    private static double e0 = 35.85;
    private static double q0 = 105.5;
    private static double sigma0 = e0 / q0;
    private final TimeDiscretization timeDiscretization;
    private final double emissionIntensityInitial;
    private final double emissionIntensityRateInitial;
    private final double emissionIntensityRateDecay;

    public EvolutionOfEmissionIndustrialIntensity(TimeDiscretization timeDiscretization, double emissionIntensityInitial, double emissionIntensityRateInitial, double emissionIntensityRateDecay) {
        this.timeDiscretization = timeDiscretization;
        this.emissionIntensityInitial = emissionIntensityInitial;
        this.emissionIntensityRateInitial = emissionIntensityRateInitial;
        this.emissionIntensityRateDecay = emissionIntensityRateDecay;
    }

    public EvolutionOfEmissionIndustrialIntensity(TimeDiscretization timeDiscretization) {
        this(timeDiscretization, sigma0, 0.0152, -Math.log(0.999));
    }

    @Override
    public Double apply(Integer timeIndex, Double emissionIntensity) {
        double time = this.timeDiscretization.getTime(timeIndex);
        double timeStep = this.timeDiscretization.getTimeStep(timeIndex);
        double emissionIntensityRate = this.emissionIntensityRateInitial * Math.exp(-this.emissionIntensityRateDecay * time);
        return emissionIntensity * Math.exp(-emissionIntensityRate * timeStep);
    }

    public TimeDiscretization getTimeDiscretization() {
        return this.timeDiscretization;
    }

    public double getEmissionIntensityInitial() {
        return this.emissionIntensityInitial;
    }

    public double getEmissionIntensityRateInitial() {
        return this.emissionIntensityRateInitial;
    }

    public double getEmissionIntensityRateDecay() {
        return this.emissionIntensityRateDecay;
    }
}

