/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.climate.models.dice.submodels;

import java.util.function.Function;
import net.finmath.time.TimeDiscretization;

public class EvolutionOfPopulation
implements Function<Integer, Function<Double, Double>> {
    private final TimeDiscretization timeDiscretization;
    private final double populationAsymptotic;
    private final double populationGrowth;

    public EvolutionOfPopulation(TimeDiscretization timeDiscretization, double populationAsymptotic, double populationGrowth) {
        this.timeDiscretization = timeDiscretization;
        this.populationAsymptotic = populationAsymptotic;
        this.populationGrowth = populationGrowth;
    }

    public EvolutionOfPopulation(TimeDiscretization timeDiscretization) {
        this(timeDiscretization, 11500.0, 0.0268);
    }

    @Override
    public Function<Double, Double> apply(Integer timeIndex) {
        double timeStep = this.timeDiscretization.getTimeStep(timeIndex);
        return population -> population * Math.pow(this.populationAsymptotic / population, this.populationGrowth * timeStep);
    }
}

