/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.climate.models.dice.submodels;

import java.util.function.Function;
import net.finmath.time.TimeDiscretization;

public class EvolutionOfProductivity
implements Function<Integer, Function<Double, Double>> {
    private final TimeDiscretization timeDiscretization;
    private final double productivityGrowthRateInitial;
    private final double productivityGrowthRateDecayRate;

    public EvolutionOfProductivity(TimeDiscretization timeDiscretization, double productivityGrowthRateInitial, double productivityGrowthRateDecayRate) {
        this.timeDiscretization = timeDiscretization;
        this.productivityGrowthRateInitial = productivityGrowthRateInitial;
        this.productivityGrowthRateDecayRate = productivityGrowthRateDecayRate;
    }

    public EvolutionOfProductivity(TimeDiscretization timeDiscretization) {
        this(timeDiscretization, 0.076, 0.005);
    }

    @Override
    public Function<Double, Double> apply(Integer timeIndex) {
        double time = this.timeDiscretization.getTime(timeIndex);
        double timeStep = this.timeDiscretization.getTimeStep(timeIndex);
        return productivity -> {
            double productivityGrowthRate = this.productivityGrowthRateInitial * Math.exp(-this.productivityGrowthRateDecayRate * time);
            return productivity / Math.exp(Math.log(1.0 - productivityGrowthRate) * timeStep / 5.0);
        };
    }
}

