/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.climate.models.dice.submodels;

import java.util.function.Function;
import net.finmath.climate.models.dice.submodels.Temperature2DScalar;
import net.finmath.functions.LinearAlgebra;
import net.finmath.time.TimeDiscretization;
import net.finmath.util.Cached;
import net.finmath.util.TriFunction;

public class EvolutionOfTemperature
implements TriFunction<Integer, Temperature2DScalar, Double, Temperature2DScalar> {
    private static double forcingToTemp5YDefault = 0.1005;
    private static double[][] transitionMatrix5YDefault;
    private final TimeDiscretization timeDiscretization;
    private final Function<Integer, double[][]> transitionMatrices;
    private final double forcingToTemp;

    public EvolutionOfTemperature(TimeDiscretization timeDiscretization, Function<Integer, double[][]> transitionMatrices, double forcingToTemp) {
        this.timeDiscretization = timeDiscretization;
        this.transitionMatrices = transitionMatrices;
        this.forcingToTemp = forcingToTemp;
    }

    public EvolutionOfTemperature(TimeDiscretization timeDiscretization) {
        Function<Integer, Double> timeSteps = timeIndex -> timeDiscretization.getTimeStep((int)timeIndex);
        this.timeDiscretization = timeDiscretization;
        this.transitionMatrices = timeSteps.andThen(Cached.of(timeStep -> timeStep == 5.0 ? transitionMatrix5YDefault : LinearAlgebra.matrixPow(transitionMatrix5YDefault, timeStep / 5.0)));
        this.forcingToTemp = forcingToTemp5YDefault / 5.0;
    }

    @Override
    public Temperature2DScalar apply(Integer timeIndex, Temperature2DScalar temperature, Double forcing) {
        double timeStep = this.timeDiscretization.getTimeStep(timeIndex);
        double[] temperatureNext = LinearAlgebra.multMatrixVector(this.transitionMatrices.apply(timeIndex), temperature.getAsDoubleArray());
        temperatureNext[0] = temperatureNext[0] + this.forcingToTemp * forcing * timeStep;
        return new Temperature2DScalar(temperatureNext);
    }

    public TimeDiscretization getTimeDiscretization() {
        return this.timeDiscretization;
    }

    static {
        double fco22x = 3.6813;
        double t2xco2 = 3.1;
        double c3 = 0.088;
        double c4 = 0.025;
        double phi11 = 1.0 - forcingToTemp5YDefault * 1.275516129032258;
        double phi12 = forcingToTemp5YDefault * 0.088;
        double phi21 = 0.025;
        double phi22 = 0.975;
        transitionMatrix5YDefault = new double[][]{{phi11, phi12}, {0.025, 0.975}};
    }
}

