/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.climate.models.dice.submodels;

import net.finmath.climate.models.Temperature;
import net.finmath.stochastic.RandomVariable;
import net.finmath.stochastic.Scalar;

public class Temperature2DScalar
implements Temperature {
    private final double temperatureOfAtmosphere;
    private final double temperatureOfLandAndOcean;

    public Temperature2DScalar(double temperatureOfAtmosphere, double temperatureOfLandAndOcean) {
        this.temperatureOfAtmosphere = temperatureOfAtmosphere;
        this.temperatureOfLandAndOcean = temperatureOfLandAndOcean;
    }

    public Temperature2DScalar(double[] temperature) {
        this.temperatureOfAtmosphere = temperature[0];
        this.temperatureOfLandAndOcean = temperature[1];
    }

    public Temperature2DScalar() {
        this(0.85, 0.0068);
    }

    @Override
    public Double getExpectedTemperatureOfAtmosphere() {
        return this.temperatureOfAtmosphere;
    }

    @Override
    public RandomVariable getTemperatureOfAtmosphere() {
        return Scalar.of(this.temperatureOfAtmosphere);
    }

    public double getTemperatureOfLandAndOcean() {
        return this.temperatureOfLandAndOcean;
    }

    double[] getAsDoubleArray() {
        return new double[]{this.temperatureOfAtmosphere, this.temperatureOfLandAndOcean};
    }
}

