/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.equities.marketdata;

import java.time.LocalDate;
import net.finmath.equities.marketdata.YieldCurve;
import net.finmath.time.daycount.DayCountConvention;

public class FlatYieldCurve
extends YieldCurve {
    private static final int longTime = 100;

    public FlatYieldCurve(LocalDate curveDate, double rate, DayCountConvention dayCounter) {
        super("NONE", curveDate, dayCounter, new LocalDate[]{curveDate.plusYears(100L)}, new double[]{Math.exp(-rate * dayCounter.getDaycountFraction(curveDate, curveDate.plusYears(100L)))});
    }

    @Override
    public FlatYieldCurve rollToDate(LocalDate date) {
        assert (date.isAfter(this.baseCurve.getReferenceDate())) : "can only roll to future dates";
        return new FlatYieldCurve(date, this.getRate(this.baseCurve.getReferenceDate().plusYears(100L)), this.dayCounter);
    }
}

