/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.equities.marketdata;

import java.time.LocalDate;
import java.util.Arrays;
import net.finmath.marketdata.model.curves.CurveInterpolation;
import net.finmath.marketdata.model.curves.DiscountCurveInterpolation;
import net.finmath.time.daycount.DayCountConvention;

public class YieldCurve {
    protected final LocalDate referenceDate;
    protected final LocalDate[] discountDates;
    protected final DayCountConvention dayCounter;
    protected final DiscountCurveInterpolation baseCurve;

    public YieldCurve(String name, LocalDate referenceDate, DayCountConvention dayCounter, LocalDate[] discountDates, double[] discountFactors) {
        this.dayCounter = dayCounter;
        this.discountDates = discountDates;
        double[] times = new double[discountDates.length];
        boolean[] isParameter = new boolean[discountDates.length];
        for (int i = 0; i < times.length; ++i) {
            times[i] = dayCounter.getDaycountFraction(referenceDate, discountDates[i]);
        }
        this.baseCurve = DiscountCurveInterpolation.createDiscountCurveFromDiscountFactors(name, referenceDate, times, discountFactors, isParameter, CurveInterpolation.InterpolationMethod.LINEAR, CurveInterpolation.ExtrapolationMethod.CONSTANT, CurveInterpolation.InterpolationEntity.LOG_OF_VALUE_PER_TIME);
        this.referenceDate = referenceDate;
    }

    public YieldCurve rollToDate(LocalDate date) {
        assert (date.isAfter(this.referenceDate)) : "can only roll to future dates";
        LocalDate[] rolledDiscountDates = (LocalDate[])Arrays.stream(this.discountDates).filter(p -> p.isAfter(date)).toArray(LocalDate[]::new);
        double[] rolledDiscountFactors = new double[rolledDiscountDates.length];
        for (int i = 0; i < rolledDiscountDates.length; ++i) {
            rolledDiscountFactors[i] = this.getForwardDiscountFactor(date, rolledDiscountDates[i]);
        }
        return new YieldCurve(this.baseCurve.getName(), date, this.dayCounter, rolledDiscountDates, rolledDiscountFactors);
    }

    public double getRate(double maturity) {
        assert (maturity >= 0.0) : "maturity must be positive";
        return this.baseCurve.getZeroRate(maturity);
    }

    public double getRate(LocalDate date) {
        return this.baseCurve.getZeroRate(this.dayCounter.getDaycountFraction(this.referenceDate, date));
    }

    public double getDiscountFactor(double maturity) {
        assert (maturity >= 0.0) : "maturity must be positive";
        return this.baseCurve.getDiscountFactor(maturity);
    }

    public double getForwardDiscountFactor(double start, double expiry) {
        assert (start >= 0.0) : "start must be positive";
        assert (expiry >= start) : "start must be before expiry";
        return this.getDiscountFactor(expiry) / this.getDiscountFactor(start);
    }

    public double getDiscountFactor(LocalDate date) {
        return this.baseCurve.getDiscountFactor(this.dayCounter.getDaycountFraction(this.referenceDate, date));
    }

    public double getForwardDiscountFactor(LocalDate startDate, LocalDate endDate) {
        assert (!startDate.isBefore(this.referenceDate)) : "start date must be after curve date";
        assert (!endDate.isBefore(startDate)) : "end date must be after start date";
        return this.getDiscountFactor(endDate) / this.getDiscountFactor(startDate);
    }
}

