/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.equities.models;

import java.time.LocalDate;
import java.util.HashMap;
import net.finmath.equities.marketdata.AffineDividendStream;
import net.finmath.equities.marketdata.YieldCurve;
import net.finmath.equities.models.EquityForwardStructure;
import net.finmath.time.daycount.DayCountConvention;

public class BuehlerDividendForwardStructure
implements EquityForwardStructure {
    private final LocalDate valuationDate;
    private final double spot;
    private final YieldCurve repoCurve;
    private final AffineDividendStream dividendStream;
    private final DayCountConvention dayCounter;
    private final HashMap<LocalDate, Double> dividendTimes;

    public BuehlerDividendForwardStructure(LocalDate valuationDate, double spot, YieldCurve repoCurve, AffineDividendStream dividendStream, DayCountConvention dayCounter) {
        this.valuationDate = valuationDate;
        this.spot = spot;
        this.repoCurve = repoCurve;
        this.dividendStream = dividendStream;
        this.dayCounter = dayCounter;
        this.dividendTimes = new HashMap();
        for (LocalDate date : dividendStream.getDividendDates()) {
            this.dividendTimes.put(date, dayCounter.getDaycountFraction(valuationDate, date));
        }
        this.validate();
    }

    public void validate() {
        assert (this.getFutureDividendFactor(this.valuationDate) <= this.spot) : "PV of future dividends is larger than spot.";
    }

    @Override
    public BuehlerDividendForwardStructure cloneWithNewSpot(double newSpot) {
        return new BuehlerDividendForwardStructure(this.valuationDate, newSpot, this.repoCurve, this.dividendStream, this.dayCounter);
    }

    @Override
    public BuehlerDividendForwardStructure cloneWithNewDate(LocalDate newDate) {
        return new BuehlerDividendForwardStructure(newDate, this.spot, this.repoCurve.rollToDate(newDate), this.dividendStream, this.dayCounter);
    }

    @Override
    public EquityForwardStructure.DividendModelType getDividendModel() {
        return EquityForwardStructure.DividendModelType.Buehler;
    }

    @Override
    public LocalDate getValuationDate() {
        return this.valuationDate;
    }

    @Override
    public double getSpot() {
        return this.spot;
    }

    @Override
    public YieldCurve getRepoCurve() {
        return this.repoCurve;
    }

    @Override
    public AffineDividendStream getDividendStream() {
        return this.dividendStream;
    }

    @Override
    public double getGrowthDiscountFactor(double startTime, double endTime) {
        double df = 1.0;
        for (LocalDate date : this.dividendStream.getDividendDates()) {
            Double dividendTime = this.dividendTimes.get(date);
            if (!(dividendTime > startTime) || !(dividendTime <= endTime)) continue;
            df *= 1.0 - this.dividendStream.getProportionalDividendFactor(date);
        }
        return df / this.repoCurve.getForwardDiscountFactor(startTime, endTime);
    }

    @Override
    public double getGrowthDiscountFactor(LocalDate startDate, LocalDate endDate) {
        double startTime = this.dayCounter.getDaycountFraction(this.valuationDate, startDate);
        double endTime = this.dayCounter.getDaycountFraction(this.valuationDate, endDate);
        return this.getGrowthDiscountFactor(startTime, endTime);
    }

    @Override
    public double getFutureDividendFactor(double valTime) {
        double df = 0.0;
        for (LocalDate date : this.dividendStream.getDividendDates()) {
            Double dividendTime = this.dividendTimes.get(date);
            if (!(dividendTime > valTime)) continue;
            df += this.dividendStream.getCashDividend(date) / this.getGrowthDiscountFactor(valTime, dividendTime);
        }
        return df;
    }

    @Override
    public double getFutureDividendFactor(LocalDate valDate) {
        double valTime = this.dayCounter.getDaycountFraction(this.valuationDate, valDate);
        return this.getFutureDividendFactor(valTime);
    }

    @Override
    public double getForward(double expiryTime) {
        double forward = this.spot * this.getGrowthDiscountFactor(0.0, expiryTime);
        for (LocalDate date : this.dividendStream.getDividendDates()) {
            Double dividendTime = this.dividendTimes.get(date);
            if (!(dividendTime <= expiryTime)) continue;
            forward -= this.dividendStream.getCashDividend(date) * this.getGrowthDiscountFactor(dividendTime, expiryTime);
        }
        return forward;
    }

    @Override
    public double getForward(LocalDate expiryDate) {
        double expiryTime = this.dayCounter.getDaycountFraction(this.valuationDate, expiryDate);
        return this.getForward(expiryTime);
    }

    @Override
    public double getDividendAdjustedStrike(double strike, double expiryTime) {
        return strike - this.getFutureDividendFactor(expiryTime);
    }

    @Override
    public double getDividendAdjustedStrike(double strike, LocalDate expiryDate) {
        return strike - this.getFutureDividendFactor(expiryDate);
    }

    @Override
    public double getLogMoneyness(double strike, double expiryTime) {
        return Math.log(this.getDividendAdjustedStrike(strike, expiryTime) / this.getDividendAdjustedStrike(this.getForward(expiryTime), expiryTime));
    }

    @Override
    public double getLogMoneyness(double strike, LocalDate expiryDate) {
        return Math.log(this.getDividendAdjustedStrike(strike, expiryDate) / this.getDividendAdjustedStrike(this.getForward(expiryDate), expiryDate));
    }
}

