/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.equities.models;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.stream.Collectors;

public class SviVolatilitySmile {
    private final double a;
    private final double b;
    private final double rho;
    private final double m;
    private final double sigma;
    private final LocalDate smileDate;

    public SviVolatilitySmile(LocalDate date, double a, double b, double rho, double m, double sigma) {
        this.a = a;
        this.b = b;
        this.rho = rho;
        this.m = m;
        this.sigma = sigma;
        this.smileDate = date;
        this.validate();
    }

    public static double sviTotalVariance(double logStrike, double a, double b, double rho, double m, double sigma) {
        double kShifted = logStrike - m;
        return a + b * (rho * kShifted + Math.sqrt(kShifted * kShifted + sigma * sigma));
    }

    public static double sviVolatility(double logStrike, double a, double b, double rho, double m, double sigma, double ttm) {
        return Math.sqrt(SviVolatilitySmile.sviTotalVariance(logStrike, a, b, rho, m, sigma) / ttm);
    }

    public static double[] sviInitialGuess(ArrayList<Double> logStrikes, ArrayList<Double> totalVariances) {
        double dwdk;
        double w;
        int nPoints = logStrikes.size();
        assert (nPoints >= 5) : "An initial guess for SVI is not sensible with less than 5 points.";
        int minIndex = totalVariances.indexOf(Collections.min(totalVariances));
        Double k0 = logStrikes.get(minIndex);
        if (k0 == 0.0) {
            int atmIndex = logStrikes.indexOf(0.0);
            Double w2 = totalVariances.get(atmIndex);
            double d2wdk2 = 2.0 * (totalVariances.get(atmIndex + 1) * totalVariances.get(atmIndex - 1) - 2.0 * w2) / (Math.pow(logStrikes.get(atmIndex + 1), 2.0) + Math.pow(logStrikes.get(atmIndex - 1), 2.0));
            double c = (totalVariances.get(nPoints - 1) - totalVariances.get(nPoints - 2)) / (logStrikes.get(nPoints - 1) - logStrikes.get(nPoints - 2));
            double p = (totalVariances.get(0) - totalVariances.get(1)) / (logStrikes.get(1) - logStrikes.get(0));
            double b = 0.5 * (c + p);
            double rho = 1.0 - 2.0 * p / (c + p);
            double m = b * (1.0 - rho * rho) * Math.abs(rho) / d2wdk2;
            double sigma = m * Math.sqrt(1.0 - rho * rho) / rho;
            double a = w2 - b * sigma * Math.sqrt(1.0 - rho * rho);
            return new double[]{a, b, rho, m, sigma};
        }
        Double wMin = totalVariances.get(minIndex);
        if (logStrikes.contains(0.0)) {
            int atmIndex = logStrikes.indexOf(0.0);
            w = totalVariances.get(atmIndex);
            dwdk = 0.5 * ((totalVariances.get(atmIndex + 1) - w) / logStrikes.get(atmIndex + 1) + (totalVariances.get(atmIndex - 1) - w) / logStrikes.get(atmIndex - 1));
        } else {
            int maxNegIndex = logStrikes.indexOf(Collections.max(logStrikes.stream().filter(s -> s < 0.0).collect(Collectors.toList())));
            dwdk = (totalVariances.get(maxNegIndex + 1) - totalVariances.get(maxNegIndex)) / (logStrikes.get(maxNegIndex + 1) - logStrikes.get(maxNegIndex));
            w = totalVariances.get(maxNegIndex) - dwdk * logStrikes.get(maxNegIndex);
        }
        double c = (totalVariances.get(nPoints - 1) - totalVariances.get(nPoints - 2)) / (logStrikes.get(nPoints - 1) - logStrikes.get(nPoints - 2));
        double p = (totalVariances.get(0) - totalVariances.get(1)) / (logStrikes.get(1) - logStrikes.get(0));
        double b = 0.5 * (c + p);
        double rho = 1.0 - 2.0 * p / (c + p);
        double beta = rho - dwdk / b;
        double alpha = Math.signum(beta) * Math.sqrt(1.0 / beta / beta - 1.0);
        double m = (w - wMin) / b / (Math.signum(alpha) * Math.sqrt(1.0 + alpha * alpha) - alpha * Math.sqrt(1.0 - rho * rho) - rho);
        double sigma = alpha * m;
        double a = wMin - b * sigma * Math.sqrt(1.0 - rho * rho);
        return new double[]{a, b, rho, m, sigma};
    }

    public void validate() {
        assert (this.getB() >= 0.0);
        assert (Math.abs(this.getRho()) < 1.0);
        assert (this.getSigma() > 0.0);
        assert (this.getA() + this.getB() * this.getSigma() * Math.sqrt(1.0 - this.getRho() * this.getRho()) >= 0.0);
    }

    public double getTotalVariance(double logStrike) {
        return SviVolatilitySmile.sviTotalVariance(logStrike, this.getA(), this.getB(), this.getRho(), this.getM(), this.getSigma());
    }

    public double getTotalVariance(double strike, double forward) {
        return SviVolatilitySmile.sviTotalVariance(Math.log(strike / forward), this.getA(), this.getB(), this.getRho(), this.getM(), this.getSigma());
    }

    public double getVolatility(double strike, double forward, double timeToExpiry) {
        return SviVolatilitySmile.sviVolatility(Math.log(strike / forward), this.getA(), this.getB(), this.getRho(), this.getM(), this.getSigma(), timeToExpiry);
    }

    public LocalDate getSmileDate() {
        return this.smileDate;
    }

    public double getSigma() {
        return this.sigma;
    }

    public double getM() {
        return this.m;
    }

    public double getRho() {
        return this.rho;
    }

    public double getB() {
        return this.b;
    }

    public double getA() {
        return this.a;
    }
}

