/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.equities.pricer;

import java.time.LocalDate;
import java.util.HashMap;
import net.finmath.equities.marketdata.YieldCurve;
import net.finmath.equities.models.Black76Model;
import net.finmath.equities.models.EquityForwardStructure;
import net.finmath.equities.models.VolatilitySurface;
import net.finmath.equities.pricer.EquityValuationRequest;
import net.finmath.equities.pricer.EquityValuationResult;
import net.finmath.equities.pricer.OptionValuation;
import net.finmath.equities.products.Option;
import net.finmath.time.daycount.DayCountConvention;
import org.apache.commons.lang3.NotImplementedException;

public class AnalyticOptionValuation
implements OptionValuation {
    private final DayCountConvention dcc;

    public AnalyticOptionValuation(DayCountConvention dcc) {
        this.dcc = dcc;
    }

    @Override
    public EquityValuationResult calculate(EquityValuationRequest request, EquityForwardStructure forwardStructure, YieldCurve discountCurve, VolatilitySurface volaSurface) {
        HashMap<EquityValuationRequest.CalculationRequestType, Double> results = new HashMap<EquityValuationRequest.CalculationRequestType, Double>();
        for (EquityValuationRequest.CalculationRequestType calcType : request.getCalcsRequested()) {
            results.put(calcType, this.calculate(request.getOption(), forwardStructure, discountCurve, volaSurface, calcType));
        }
        return new EquityValuationResult(request, results);
    }

    public double calculate(Option option, EquityForwardStructure forwardStructure, YieldCurve discountCurve, VolatilitySurface volaSurface, EquityValuationRequest.CalculationRequestType calcType) {
        assert (!option.isAmericanOption()) : "Analytic pricer cannot handle American options.";
        LocalDate valDate = forwardStructure.getValuationDate();
        LocalDate expiryDate = option.getExpiryDate();
        double ttm = this.dcc.getDaycountFraction(forwardStructure.getValuationDate(), expiryDate);
        double forward = forwardStructure.getForward(expiryDate);
        double discountFactor = discountCurve.getDiscountFactor(expiryDate);
        double discountRate = discountCurve.getRate(expiryDate);
        double adjustedForward = forwardStructure.getDividendAdjustedStrike(forward, expiryDate);
        double adjustedStrike = forwardStructure.getDividendAdjustedStrike(option.getStrike(), expiryDate);
        double volatility = volaSurface.getVolatility(option.getStrike(), option.getExpiryDate(), forwardStructure);
        switch (calcType) {
            case Price: {
                return Black76Model.optionPrice(1.0, adjustedStrike / adjustedForward, ttm, volatility, option.isCallOption(), discountFactor * adjustedForward);
            }
            case EqDelta: {
                double dFdS = forwardStructure.getGrowthDiscountFactor(valDate, expiryDate);
                return dFdS * Black76Model.optionDelta(1.0, adjustedStrike / adjustedForward, ttm, volatility, option.isCallOption(), discountFactor);
            }
            case EqGamma: {
                double dFdS2 = Math.pow(forwardStructure.getGrowthDiscountFactor(valDate, expiryDate), 2.0);
                return dFdS2 * Black76Model.optionGamma(1.0, adjustedStrike / adjustedForward, ttm, volatility, option.isCallOption(), discountFactor / adjustedForward);
            }
            case EqVega: {
                return Black76Model.optionVega(1.0, adjustedStrike / adjustedForward, ttm, volatility, option.isCallOption(), discountFactor * adjustedForward);
            }
            case Theta: {
                return Black76Model.optionTheta(1.0, adjustedStrike / adjustedForward, ttm, volatility, option.isCallOption(), discountFactor * adjustedForward, discountRate);
            }
        }
        throw new NotImplementedException("Calculation for " + calcType + " not implemented yet.");
    }

    public double getPrice(Option option, EquityForwardStructure forwardStructure, YieldCurve discountCurve, VolatilitySurface volaSurface) {
        return this.calculate(option, forwardStructure, discountCurve, volaSurface, EquityValuationRequest.CalculationRequestType.Price);
    }

    public double getDelta(Option option, EquityForwardStructure forwardStructure, YieldCurve discountCurve, VolatilitySurface volaSurface) {
        return this.calculate(option, forwardStructure, discountCurve, volaSurface, EquityValuationRequest.CalculationRequestType.EqDelta);
    }

    public double getGamma(Option option, EquityForwardStructure forwardStructure, YieldCurve discountCurve, VolatilitySurface volaSurface) {
        return this.calculate(option, forwardStructure, discountCurve, volaSurface, EquityValuationRequest.CalculationRequestType.EqGamma);
    }

    public double getVega(Option option, EquityForwardStructure forwardStructure, YieldCurve discountCurve, VolatilitySurface volaSurface) {
        return this.calculate(option, forwardStructure, discountCurve, volaSurface, EquityValuationRequest.CalculationRequestType.EqVega);
    }

    public double getTheta(Option option, EquityForwardStructure forwardStructure, YieldCurve discountCurve, VolatilitySurface volaSurface) {
        return this.calculate(option, forwardStructure, discountCurve, volaSurface, EquityValuationRequest.CalculationRequestType.Theta);
    }

    public double getImpliedVolatility(Option option, EquityForwardStructure forwardStructure, YieldCurve discountCurve, double price) {
        assert (!option.isAmericanOption()) : "Analytic pricer cannot handle American options.";
        LocalDate expiryDate = option.getExpiryDate();
        double ttm = this.dcc.getDaycountFraction(forwardStructure.getValuationDate(), expiryDate);
        double forward = forwardStructure.getForward(expiryDate);
        double discount = discountCurve.getDiscountFactor(expiryDate);
        double adjustedForward = forwardStructure.getDividendAdjustedStrike(forward, expiryDate);
        double adjustedStrike = forwardStructure.getDividendAdjustedStrike(option.getStrike(), expiryDate);
        double undiscountedPrice = price / discount / adjustedForward;
        return Black76Model.optionImpliedVolatility(1.0, adjustedStrike / adjustedForward, ttm, undiscountedPrice, option.isCallOption());
    }
}

