/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.equities.products;

import java.time.LocalDate;
import net.finmath.equities.products.Option;

public abstract class AbstractOption
implements Option {
    private final LocalDate expiryDate;
    private final double strike;
    private final boolean isCallOption;

    public AbstractOption(LocalDate expiryDate, double strike, boolean isCallOption) {
        this.expiryDate = expiryDate;
        this.strike = strike;
        this.isCallOption = isCallOption;
    }

    @Override
    public final LocalDate getExpiryDate() {
        return this.expiryDate;
    }

    @Override
    public final double getStrike() {
        return this.strike;
    }

    @Override
    public final boolean isCallOption() {
        return this.isCallOption;
    }

    @Override
    public final double callPutFactor() {
        if (this.isCallOption) {
            return 1.0;
        }
        return -1.0;
    }

    @Override
    public final double getPayoff(double spot) {
        return Math.max(this.callPutFactor() * (spot - this.strike), 0.0);
    }
}

