/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.finitedifference.solvers;

import java.util.function.DoubleUnaryOperator;
import net.finmath.finitedifference.models.FiniteDifference1DBoundary;
import net.finmath.finitedifference.models.FiniteDifference1DModel;
import org.apache.commons.math3.linear.DecompositionSolver;
import org.apache.commons.math3.linear.LUDecomposition;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;

public class FDMThetaMethod {
    private final FiniteDifference1DModel model;
    private final FiniteDifference1DBoundary boundaryCondition;
    private final double theta;
    private final double center;
    private final double timeHorizon;

    public FDMThetaMethod(FiniteDifference1DModel model, FiniteDifference1DBoundary boundaryCondition, double timeHorizon, double center, double theta) {
        this.model = model;
        this.boundaryCondition = boundaryCondition;
        this.timeHorizon = timeHorizon;
        this.center = center;
        this.theta = theta;
    }

    public double[][] getValue(double evaluationTime, double time, DoubleUnaryOperator valueAtMaturity) {
        if (evaluationTime != 0.0) {
            throw new IllegalArgumentException("Evaluation time != 0 not supported.");
        }
        if (time != this.timeHorizon) {
            throw new IllegalArgumentException("Given time != timeHorizon not supported.");
        }
        double maximumStockPriceOnGrid = this.model.getForwardValue(this.timeHorizon) + this.model.getNumStandardDeviations() * Math.sqrt(this.model.varianceOfStockPrice(this.timeHorizon));
        double minimumStockPriceOnGrid = Math.max(this.model.getForwardValue(this.timeHorizon) - this.model.getNumStandardDeviations() * Math.sqrt(this.model.varianceOfStockPrice(this.timeHorizon)), 0.0);
        double deltaStock = (maximumStockPriceOnGrid - minimumStockPriceOnGrid) / (double)this.model.getNumSpacesteps();
        double deltaTau = this.timeHorizon / (double)this.model.getNumTimesteps();
        int spaceLength = this.model.getNumSpacesteps() - 1;
        double[] stock = new double[spaceLength];
        for (int i = 0; i < spaceLength; ++i) {
            stock[i] = minimumStockPriceOnGrid + (double)(i + 1) * deltaStock;
        }
        int timeLength = this.model.getNumTimesteps() + 1;
        double[] tau = new double[timeLength];
        for (int i = 0; i < timeLength; ++i) {
            tau[i] = (double)i * deltaTau;
        }
        RealMatrix eye = MatrixUtils.createRealIdentityMatrix((int)spaceLength);
        RealMatrix D1 = MatrixUtils.createRealMatrix((int)spaceLength, (int)spaceLength);
        RealMatrix D2 = MatrixUtils.createRealMatrix((int)spaceLength, (int)spaceLength);
        RealMatrix T1 = MatrixUtils.createRealMatrix((int)spaceLength, (int)spaceLength);
        RealMatrix T2 = MatrixUtils.createRealMatrix((int)spaceLength, (int)spaceLength);
        for (int i = 0; i < spaceLength; ++i) {
            for (int j = 0; j < spaceLength; ++j) {
                if (i == j) {
                    D1.setEntry(i, j, minimumStockPriceOnGrid / deltaStock + (double)(i + 1));
                    D2.setEntry(i, j, Math.pow(minimumStockPriceOnGrid / deltaStock + (double)(i + 1), 2.0));
                    T2.setEntry(i, j, -2.0);
                    continue;
                }
                if (i == j - 1) {
                    T1.setEntry(i, j, 1.0);
                    T2.setEntry(i, j, 1.0);
                    continue;
                }
                if (i == j + 1) {
                    T1.setEntry(i, j, -1.0);
                    T2.setEntry(i, j, 1.0);
                    continue;
                }
                D1.setEntry(i, j, 0.0);
                D2.setEntry(i, j, 0.0);
                T1.setEntry(i, j, 0.0);
                T2.setEntry(i, j, 0.0);
            }
        }
        RealMatrix F1 = eye.scalarMultiply(1.0 - this.model.getRiskFreeRate() * deltaTau);
        RealMatrix F2 = D1.scalarMultiply(0.5 * this.model.getRiskFreeRate() * deltaTau).multiply(T1);
        RealMatrix F3 = D2.scalarMultiply(0.5 * deltaTau).multiply(T2);
        RealMatrix G1 = eye.scalarMultiply(1.0 + this.model.getRiskFreeRate() * deltaTau);
        RealMatrix G2 = F2.scalarMultiply(-1.0);
        RealMatrix G3 = F3.scalarMultiply(-1.0);
        RealMatrix b = MatrixUtils.createRealMatrix((int)spaceLength, (int)1);
        RealMatrix b2 = MatrixUtils.createRealMatrix((int)spaceLength, (int)1);
        RealMatrix U = MatrixUtils.createRealMatrix((int)spaceLength, (int)1);
        for (int i = 0; i < spaceLength; ++i) {
            b.setEntry(i, 0, 0.0);
            b2.setEntry(i, 0, 0.0);
            U.setEntry(i, 0, valueAtMaturity.applyAsDouble(stock[i]));
        }
        for (int m = 0; m < this.model.getNumTimesteps(); ++m) {
            double[] sigma = new double[spaceLength];
            double[] sigma2 = new double[spaceLength];
            for (int i = 0; i < spaceLength; ++i) {
                sigma[i] = Math.pow(this.model.getLocalVolatility(minimumStockPriceOnGrid + (double)(i + 1) * deltaStock, this.timeHorizon - (double)m * deltaTau), 2.0);
                sigma2[i] = Math.pow(this.model.getLocalVolatility(minimumStockPriceOnGrid + (double)(i + 1) * deltaStock, this.timeHorizon - (double)(m + 1) * deltaTau), 2.0);
            }
            RealMatrix Sigma2 = MatrixUtils.createRealDiagonalMatrix((double[])sigma);
            RealMatrix Sigma22 = MatrixUtils.createRealDiagonalMatrix((double[])sigma2);
            RealMatrix F = F1.add(F2).add(Sigma2.multiply(F3));
            RealMatrix G = G1.add(G2).add(Sigma22.multiply(G3));
            RealMatrix H = G.scalarMultiply(this.theta).add(eye.scalarMultiply(1.0 - this.theta));
            DecompositionSolver solver = new LUDecomposition(H).getSolver();
            double Sl = minimumStockPriceOnGrid / deltaStock + 1.0;
            double Su = maximumStockPriceOnGrid / deltaStock - 1.0;
            double vl = Math.pow(this.model.getLocalVolatility(minimumStockPriceOnGrid + deltaStock, this.timeHorizon - (double)m * deltaTau), 2.0);
            double vu = Math.pow(this.model.getLocalVolatility(maximumStockPriceOnGrid - deltaStock, this.timeHorizon - (double)m * deltaTau), 2.0);
            double vl2 = Math.pow(this.model.getLocalVolatility(minimumStockPriceOnGrid + deltaStock, this.timeHorizon - (double)(m + 1) * deltaTau), 2.0);
            double vu2 = Math.pow(this.model.getLocalVolatility(maximumStockPriceOnGrid - deltaStock, this.timeHorizon - (double)(m + 1) * deltaTau), 2.0);
            double test = this.timeReversedUpperBoundary(maximumStockPriceOnGrid, tau[m]);
            b.setEntry(0, 0, 0.5 * deltaTau * Sl * (vl * Sl - this.model.getRiskFreeRate()) * this.timeReversedLowerBoundary(minimumStockPriceOnGrid, tau[m]));
            b.setEntry(spaceLength - 1, 0, 0.5 * deltaTau * Su * (vu * Su + this.model.getRiskFreeRate()) * this.timeReversedUpperBoundary(maximumStockPriceOnGrid, tau[m]));
            b2.setEntry(0, 0, 0.5 * deltaTau * Sl * (vl2 * Sl - this.model.getRiskFreeRate()) * this.timeReversedLowerBoundary(minimumStockPriceOnGrid, tau[m + 1]));
            b2.setEntry(spaceLength - 1, 0, 0.5 * deltaTau * Su * (vu2 * Su + this.model.getRiskFreeRate()) * this.timeReversedUpperBoundary(maximumStockPriceOnGrid, tau[m + 1]));
            RealMatrix U1 = F.scalarMultiply(1.0 - this.theta).add(eye.scalarMultiply(this.theta)).multiply(U);
            RealMatrix U2 = b.scalarMultiply(1.0 - this.theta).add(b2.scalarMultiply(this.theta));
            U = solver.solve(U1.add(U2));
        }
        double[] optionPrice = U.getColumn(0);
        double[][] stockAndOptionPrice = new double[2][spaceLength];
        stockAndOptionPrice[0] = stock;
        stockAndOptionPrice[1] = optionPrice;
        return stockAndOptionPrice;
    }

    private double timeReversedLowerBoundary(double stockPrice, double tau) {
        return this.boundaryCondition.getValueAtLowerBoundary(this.model, this.timeHorizon - tau, stockPrice);
    }

    private double timeReversedUpperBoundary(double stockPrice, double tau) {
        return this.boundaryCondition.getValueAtUpperBoundary(this.model, this.timeHorizon - tau, stockPrice);
    }
}

