/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.fouriermethod.calibration;

import net.finmath.fouriermethod.calibration.ScalarConstraint;

public class BoundConstraint
implements ScalarConstraint {
    private final double lowerBound;
    private final double upperBound;

    public BoundConstraint(double lowerBound, double upperBound) {
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    @Override
    public double getLowerBound() {
        return this.lowerBound;
    }

    @Override
    public double getUpperBound() {
        return this.upperBound;
    }

    @Override
    public double apply(double parameterToTest) {
        if (parameterToTest > this.upperBound || parameterToTest < this.lowerBound) {
            double u = 1.0 / (Math.exp(parameterToTest) + 1.0);
            return this.lowerBound + u * (this.upperBound - this.lowerBound);
        }
        return parameterToTest;
    }
}

