/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.fouriermethod.calibration.models;

import java.util.Arrays;
import net.finmath.fouriermethod.calibration.ScalarParameterInformation;
import net.finmath.fouriermethod.calibration.ScalarParameterInformationImplementation;
import net.finmath.fouriermethod.calibration.Unconstrained;
import net.finmath.fouriermethod.calibration.models.CalibratableProcess;
import net.finmath.fouriermethod.models.MertonModel;
import net.finmath.modelling.ModelDescriptor;
import net.finmath.modelling.descriptor.MertonModelDescriptor;

public class CalibratableMertonModel
implements CalibratableProcess {
    private final MertonModelDescriptor descriptor;
    private final ScalarParameterInformation volatilityInfo;
    private final ScalarParameterInformation jumpIntensityInfo;
    private final ScalarParameterInformation jumpSizeMeanInfo;
    private final ScalarParameterInformation jumpSizeStdDevInfo;
    private final double[] parameterUpperBounds;
    private final double[] parameterLowerBounds;

    public CalibratableMertonModel(MertonModelDescriptor descriptor) {
        this.descriptor = descriptor;
        this.volatilityInfo = new ScalarParameterInformationImplementation(true, new Unconstrained());
        this.jumpIntensityInfo = new ScalarParameterInformationImplementation(true, new Unconstrained());
        this.jumpSizeMeanInfo = new ScalarParameterInformationImplementation(true, new Unconstrained());
        this.jumpSizeStdDevInfo = new ScalarParameterInformationImplementation(true, new Unconstrained());
        this.parameterUpperBounds = this.extractUpperBounds();
        this.parameterLowerBounds = this.extractLowerBounds();
    }

    public CalibratableMertonModel(MertonModelDescriptor descriptor, ScalarParameterInformation volatilityInfo, ScalarParameterInformation jumpIntensityInfo, ScalarParameterInformation jumpSizeMeanInfo, ScalarParameterInformation jumpSizeStdDevInfo) {
        this.descriptor = descriptor;
        this.volatilityInfo = volatilityInfo;
        this.jumpIntensityInfo = jumpIntensityInfo;
        this.jumpSizeMeanInfo = jumpSizeMeanInfo;
        this.jumpSizeStdDevInfo = jumpSizeStdDevInfo;
        this.parameterUpperBounds = this.extractUpperBounds();
        this.parameterLowerBounds = this.extractLowerBounds();
    }

    @Override
    public CalibratableProcess getCloneForModifiedParameters(double[] parameters) {
        double volatility = this.volatilityInfo.getIsParameterToCalibrate() ? this.volatilityInfo.getConstraint().apply(parameters[0]) : this.descriptor.getVolatility().doubleValue();
        double jumpIntensity = this.jumpIntensityInfo.getIsParameterToCalibrate() ? this.jumpIntensityInfo.getConstraint().apply(parameters[1]) : this.descriptor.getJumpIntensity().doubleValue();
        double jumpSizeMean = this.jumpSizeMeanInfo.getIsParameterToCalibrate() ? this.jumpSizeMeanInfo.getConstraint().apply(parameters[2]) : this.descriptor.getJumpSizeMean().doubleValue();
        double jumpSizeStdDev = this.jumpSizeStdDevInfo.getIsParameterToCalibrate() ? this.jumpSizeStdDevInfo.getConstraint().apply(parameters[3]) : this.descriptor.getJumpSizeStdDev().doubleValue();
        MertonModelDescriptor newDescriptor = new MertonModelDescriptor(this.descriptor.getReferenceDate(), this.descriptor.getInitialValue(), this.descriptor.getDiscountCurveForForwardRate(), this.descriptor.getDiscountCurveForDiscountRate(), volatility, jumpIntensity, jumpSizeMean, jumpSizeStdDev);
        return new CalibratableMertonModel(newDescriptor, this.volatilityInfo, this.jumpIntensityInfo, this.jumpSizeMeanInfo, this.jumpSizeStdDevInfo);
    }

    @Override
    public ModelDescriptor getModelDescriptor() {
        return this.descriptor;
    }

    @Override
    public MertonModel getCharacteristicFunctionModel() {
        return new MertonModel(this.descriptor.getReferenceDate(), this.descriptor.getInitialValue(), this.descriptor.getDiscountCurveForForwardRate(), this.descriptor.getDiscountCurveForDiscountRate(), this.descriptor.getVolatility(), this.descriptor.getJumpIntensity(), this.descriptor.getJumpSizeMean(), this.descriptor.getJumpSizeStdDev());
    }

    @Override
    public double[] getParameterLowerBounds() {
        return this.parameterLowerBounds;
    }

    @Override
    public double[] getParameterUpperBounds() {
        return this.parameterUpperBounds;
    }

    private double[] extractUpperBounds() {
        double[] upperBounds = new double[4];
        double threshold = 1000000.0;
        upperBounds[0] = this.volatilityInfo.getConstraint().getUpperBound() > 1000000.0 ? 1000000.0 : this.volatilityInfo.getConstraint().getUpperBound();
        upperBounds[1] = this.jumpIntensityInfo.getConstraint().getUpperBound() > 1000000.0 ? 1000000.0 : this.jumpIntensityInfo.getConstraint().getUpperBound();
        upperBounds[2] = this.jumpSizeMeanInfo.getConstraint().getUpperBound() > 1000000.0 ? 1000000.0 : this.jumpSizeMeanInfo.getConstraint().getUpperBound();
        upperBounds[3] = this.jumpSizeStdDevInfo.getConstraint().getUpperBound() > 1000000.0 ? 1000000.0 : this.jumpSizeStdDevInfo.getConstraint().getUpperBound();
        return upperBounds;
    }

    private double[] extractLowerBounds() {
        double[] upperBounds = new double[4];
        double threshold = -1000000.0;
        upperBounds[0] = this.volatilityInfo.getConstraint().getLowerBound() < -1000000.0 ? -1000000.0 : this.volatilityInfo.getConstraint().getLowerBound();
        upperBounds[1] = this.jumpIntensityInfo.getConstraint().getLowerBound() < -1000000.0 ? -1000000.0 : this.jumpIntensityInfo.getConstraint().getLowerBound();
        upperBounds[2] = this.jumpSizeMeanInfo.getConstraint().getLowerBound() < -1000000.0 ? -1000000.0 : this.jumpSizeMeanInfo.getConstraint().getLowerBound();
        upperBounds[3] = this.jumpSizeStdDevInfo.getConstraint().getLowerBound() < -1000000.0 ? -1000000.0 : this.jumpSizeStdDevInfo.getConstraint().getLowerBound();
        return upperBounds;
    }

    public String toString() {
        return "CalibratableMertonModel [descriptor=" + this.descriptor + ", volatilityInfo=" + this.volatilityInfo + ", jumpIntensityInfo=" + this.jumpIntensityInfo + ", jumpSizeMeanInfo=" + this.jumpSizeMeanInfo + ", jumpSizeStdDevInfo=" + this.jumpSizeStdDevInfo + ", parameterUpperBounds=" + Arrays.toString(this.parameterUpperBounds) + ", parameterLowerBounds=" + Arrays.toString(this.parameterLowerBounds) + "]";
    }
}

