/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.fouriermethod.models;

import java.time.LocalDate;
import net.finmath.fouriermethod.CharacteristicFunction;
import net.finmath.fouriermethod.models.CharacteristicFunctionModel;
import net.finmath.marketdata.model.curves.DiscountCurve;
import org.apache.commons.math3.complex.Complex;

public class BlackScholesModel
implements CharacteristicFunctionModel {
    private final LocalDate referenceDate;
    private final double initialValue;
    private final DiscountCurve discountCurveForForwardRate;
    private final double riskFreeRate;
    private final DiscountCurve discountCurveForDiscountRate;
    private final double discountRate;
    private final double volatility;

    public BlackScholesModel(LocalDate referenceDate, double initialValue, DiscountCurve discountCurveForForwardRate, DiscountCurve discountCurveForDiscountRate, double volatility) {
        this.referenceDate = referenceDate;
        this.initialValue = initialValue;
        this.discountCurveForForwardRate = discountCurveForForwardRate;
        this.riskFreeRate = Double.NaN;
        this.discountCurveForDiscountRate = discountCurveForDiscountRate;
        this.discountRate = Double.NaN;
        this.volatility = volatility;
    }

    public BlackScholesModel(double initialValue, double riskFreeRate, double discountRate, double volatility) {
        this.referenceDate = null;
        this.initialValue = initialValue;
        this.discountCurveForForwardRate = null;
        this.riskFreeRate = riskFreeRate;
        this.volatility = volatility;
        this.discountCurveForDiscountRate = null;
        this.discountRate = discountRate;
    }

    public BlackScholesModel(double initialValue, double riskFreeRate, double volatility) {
        this(initialValue, riskFreeRate, riskFreeRate, volatility);
    }

    @Override
    public CharacteristicFunction apply(final double time) {
        final double logDiscountFactorForForward = this.getLogDiscountFactorForForward(time);
        final double logDiscountFactorForDiscounting = this.getLogDiscountFactorForDiscounting(time);
        return new CharacteristicFunction(){

            @Override
            public Complex apply(Complex argument) {
                Complex iargument = argument.multiply(Complex.I);
                return iargument.multiply(iargument.multiply(0.5 * BlackScholesModel.this.volatility * BlackScholesModel.this.volatility * time).add(Math.log(BlackScholesModel.this.initialValue) - 0.5 * BlackScholesModel.this.volatility * BlackScholesModel.this.volatility * time - logDiscountFactorForForward)).add(logDiscountFactorForDiscounting).exp();
            }
        };
    }

    private double getLogDiscountFactorForForward(double time) {
        return this.discountCurveForForwardRate == null ? -this.riskFreeRate * time : Math.log(this.discountCurveForForwardRate.getDiscountFactor(null, time));
    }

    private double getLogDiscountFactorForDiscounting(double time) {
        return this.discountCurveForDiscountRate == null ? -this.discountRate * time : Math.log(this.discountCurveForDiscountRate.getDiscountFactor(null, time));
    }

    public LocalDate getReferenceDate() {
        return this.referenceDate;
    }

    public double getInitialValue() {
        return this.initialValue;
    }

    public DiscountCurve getDiscountCurveForForwardRate() {
        return this.discountCurveForForwardRate;
    }

    public double getRiskFreeRate() {
        return this.riskFreeRate;
    }

    public DiscountCurve getDiscountCurveForDiscountRate() {
        return this.discountCurveForDiscountRate;
    }

    public double getDiscountRate() {
        return this.discountRate;
    }

    public double getVolatility() {
        return this.volatility;
    }

    public String toString() {
        return "BlackScholesModel [initialValue=" + this.initialValue + ", discountCurveForForwardRate=" + this.discountCurveForForwardRate + ", riskFreeRate=" + this.riskFreeRate + ", discountCurveForDiscountRate=" + this.discountCurveForDiscountRate + ", discountRate=" + this.discountRate + ", volatility=" + this.volatility + "]";
    }
}

