/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.fouriermethod.products;

import net.finmath.fouriermethod.products.AbstractFourierTransformProduct;
import org.apache.commons.math3.complex.Complex;

public class DigitalOption
extends AbstractFourierTransformProduct {
    private final double maturity;
    private final double strike;
    private final String nameOfUnderlying;

    public DigitalOption(double maturity, double strike) {
        this.maturity = maturity;
        this.strike = strike;
        this.nameOfUnderlying = null;
    }

    @Override
    public Complex apply(Complex argument) {
        Complex iargument = argument.multiply(Complex.I);
        Complex exponent = iargument.add(1.0);
        Complex numerator = new Complex(this.strike).pow(exponent.subtract(1.0)).multiply(exponent);
        Complex denominator = argument.multiply(argument).subtract(iargument);
        return numerator.divide(denominator);
    }

    @Override
    public double getMaturity() {
        return this.maturity;
    }

    @Override
    public double getIntegrationDomainImagLowerBound() {
        return 0.5;
    }

    @Override
    public double getIntegrationDomainImagUpperBound() {
        return 2.5;
    }
}

