/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.fouriermethod.products.smile;

import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.finmath.exception.CalculationException;
import net.finmath.fouriermethod.models.CharacteristicFunctionModel;
import net.finmath.fouriermethod.products.smile.SmileByIntegralTransform;
import net.finmath.modelling.descriptor.SingleAssetEuropeanOptionProductDescriptor;
import net.finmath.time.FloatingpointDate;
import org.apache.commons.math3.complex.Complex;

public abstract class EuropeanOptionSmile
implements SmileByIntegralTransform {
    private final String underlyingName;
    private final double maturity;
    private final double[] strikes;

    public EuropeanOptionSmile(String underlyingName, double maturity, double[] strikes) {
        this.underlyingName = underlyingName;
        this.maturity = maturity;
        this.strikes = strikes;
    }

    public EuropeanOptionSmile(double maturity, double[] strikes) {
        this(null, maturity, strikes);
    }

    @Override
    public double getMaturity() {
        return this.maturity;
    }

    public double[] getStrikes() {
        return this.strikes;
    }

    public String getUnderlyingName() {
        return this.underlyingName;
    }

    @Override
    public double getIntegrationDomainImagLowerBound() {
        return 0.0;
    }

    @Override
    public double getIntegrationDomainImagUpperBound() {
        return -1.0;
    }

    @Override
    public abstract Map<String, Function<Double, Double>> getValue(double var1, CharacteristicFunctionModel var3) throws CalculationException;

    public abstract EuropeanOptionSmile getCloneWithModifiedParameters(double var1, double[] var3);

    @Override
    public Complex apply(Complex z) {
        return z.subtract(Complex.I).multiply(z).negate();
    }

    public Map<Double, SingleAssetEuropeanOptionProductDescriptor> getDescriptors(LocalDate referenceDate) {
        int numberOfStrikes = this.strikes.length;
        HashMap<Double, SingleAssetEuropeanOptionProductDescriptor> descriptors = new HashMap<Double, SingleAssetEuropeanOptionProductDescriptor>();
        LocalDate maturityDate = FloatingpointDate.getDateFromFloatingPointDate(referenceDate, this.maturity);
        for (int i = 0; i < numberOfStrikes; ++i) {
            descriptors.put(this.strikes[i], new SingleAssetEuropeanOptionProductDescriptor(this.underlyingName, maturityDate, this.strikes[i]));
        }
        return descriptors;
    }

    public SingleAssetEuropeanOptionProductDescriptor getDescriptor(LocalDate referenceDate, int index) throws ArrayIndexOutOfBoundsException {
        LocalDate maturityDate = FloatingpointDate.getDateFromFloatingPointDate(referenceDate, this.maturity);
        if (index >= this.strikes.length) {
            throw new ArrayIndexOutOfBoundsException("Strike index out of bounds");
        }
        return new SingleAssetEuropeanOptionProductDescriptor(this.underlyingName, maturityDate, this.strikes[index]);
    }
}

