/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.functions;

import java.util.Calendar;
import java.util.Date;
import net.finmath.functions.BachelierModel;
import net.finmath.functions.NonCentralChiSquaredDistribution;
import net.finmath.functions.NormalDistribution;
import net.finmath.rootfinder.NewtonsMethod;
import net.finmath.stochastic.RandomVariable;
import net.finmath.stochastic.Scalar;
import org.apache.commons.math3.special.Erf;

public class AnalyticFormulas {
    private AnalyticFormulas() {
    }

    public static double blackScholesGeneralizedOptionValue(double forward, double volatility, double optionMaturity, double optionStrike, double payoffUnit) {
        if (optionMaturity < 0.0) {
            return 0.0;
        }
        if (forward < 0.0) {
            return (forward - optionStrike) * payoffUnit + AnalyticFormulas.blackScholesGeneralizedOptionValue(-forward, volatility, optionMaturity, -optionStrike, payoffUnit);
        }
        if (forward == 0.0 || optionStrike <= 0.0 || volatility <= 0.0 || optionMaturity <= 0.0) {
            return Math.max(forward - optionStrike, 0.0) * payoffUnit;
        }
        double dPlus = (Math.log(forward / optionStrike) + 0.5 * volatility * volatility * optionMaturity) / (volatility * Math.sqrt(optionMaturity));
        double dMinus = dPlus - volatility * Math.sqrt(optionMaturity);
        double valueAnalytic = (forward * NormalDistribution.cumulativeDistribution(dPlus) - optionStrike * NormalDistribution.cumulativeDistribution(dMinus)) * payoffUnit;
        return valueAnalytic;
    }

    public static RandomVariable blackScholesGeneralizedOptionValue(RandomVariable forward, RandomVariable volatility, double optionMaturity, double optionStrike, RandomVariable payoffUnit) {
        if (optionMaturity < 0.0) {
            return forward.mult(0.0);
        }
        RandomVariable dPlus = forward.div(optionStrike).log().add(volatility.squared().mult(0.5 * optionMaturity)).div(volatility).div(Math.sqrt(optionMaturity));
        RandomVariable dMinus = dPlus.sub(volatility.mult(Math.sqrt(optionMaturity)));
        RandomVariable valueAnalytic = dPlus.apply(NormalDistribution::cumulativeDistribution).mult(forward).sub(dMinus.apply(NormalDistribution::cumulativeDistribution).mult(optionStrike)).mult(payoffUnit);
        return valueAnalytic;
    }

    public static double blackScholesOptionValue(double initialStockValue, double riskFreeRate, double volatility, double optionMaturity, double optionStrike) {
        return AnalyticFormulas.blackScholesGeneralizedOptionValue(initialStockValue * Math.exp(riskFreeRate * optionMaturity), volatility, optionMaturity, optionStrike, Math.exp(-riskFreeRate * optionMaturity));
    }

    public static RandomVariable blackScholesOptionValue(RandomVariable initialStockValue, RandomVariable riskFreeRate, RandomVariable volatility, double optionMaturity, double optionStrike) {
        return AnalyticFormulas.blackScholesGeneralizedOptionValue(initialStockValue.mult(riskFreeRate.mult(optionMaturity).exp()), volatility, optionMaturity - 0.0, optionStrike, riskFreeRate.mult(-optionMaturity).exp());
    }

    public static RandomVariable blackScholesOptionValue(RandomVariable initialStockValue, double riskFreeRate, double volatility, double optionMaturity, double optionStrike) {
        return AnalyticFormulas.blackScholesGeneralizedOptionValue(initialStockValue.mult(Math.exp(riskFreeRate * optionMaturity)), new Scalar(volatility), optionMaturity - 0.0, optionStrike, new Scalar(Math.exp(-riskFreeRate * optionMaturity)));
    }

    public static double blackScholesOptionValue(double initialStockValue, double riskFreeRate, double volatility, double optionMaturity, double optionStrike, boolean isCall) {
        double callValue = AnalyticFormulas.blackScholesOptionValue(initialStockValue, riskFreeRate, volatility, optionMaturity, optionStrike);
        if (isCall) {
            return callValue;
        }
        double putValue = callValue - (initialStockValue - optionStrike * Math.exp(-riskFreeRate * optionMaturity));
        return putValue;
    }

    public static double blackScholesATMOptionValue(double volatility, double optionMaturity, double forward, double payoffUnit) {
        if (optionMaturity < 0.0) {
            return 0.0;
        }
        double dPlus = 0.5 * volatility * Math.sqrt(optionMaturity);
        double dMinus = -dPlus;
        double valueAnalytic = (NormalDistribution.cumulativeDistribution(dPlus) - NormalDistribution.cumulativeDistribution(dMinus)) * forward * payoffUnit;
        return valueAnalytic;
    }

    public static double blackScholesOptionDelta(double initialStockValue, double riskFreeRate, double volatility, double optionMaturity, double optionStrike) {
        if (optionMaturity < 0.0) {
            return 0.0;
        }
        if (initialStockValue < 0.0) {
            return 1.0 - AnalyticFormulas.blackScholesOptionDelta(-initialStockValue, riskFreeRate, volatility, optionMaturity, -optionStrike);
        }
        if (initialStockValue == 0.0) {
            if (optionStrike < 0.0) {
                return 1.0;
            }
            if (optionStrike > 0.0) {
                return 0.0;
            }
            return 1.0;
        }
        if (optionStrike <= 0.0 || volatility <= 0.0 || optionMaturity <= 0.0) {
            return 1.0;
        }
        double dPlus = (Math.log(initialStockValue / optionStrike) + (riskFreeRate + 0.5 * volatility * volatility) * optionMaturity) / (volatility * Math.sqrt(optionMaturity));
        double delta = NormalDistribution.cumulativeDistribution(dPlus);
        return delta;
    }

    public static RandomVariable blackScholesOptionDelta(RandomVariable initialStockValue, RandomVariable riskFreeRate, RandomVariable volatility, double optionMaturity, double optionStrike) {
        if (optionMaturity < 0.0) {
            return initialStockValue.mult(0.0);
        }
        RandomVariable dPlus = initialStockValue.div(optionStrike).log().add(volatility.squared().mult(0.5).add(riskFreeRate).mult(optionMaturity)).div(volatility).div(Math.sqrt(optionMaturity));
        RandomVariable delta = dPlus.apply(NormalDistribution::cumulativeDistribution);
        return delta;
    }

    public static RandomVariable blackScholesOptionDelta(RandomVariable initialStockValue, double riskFreeRate, double volatility, double optionMaturity, double optionStrike) {
        return AnalyticFormulas.blackScholesOptionDelta(initialStockValue, (RandomVariable)new Scalar(riskFreeRate), (RandomVariable)new Scalar(volatility), optionMaturity, optionStrike);
    }

    public static RandomVariable blackScholesOptionDelta(RandomVariable initialStockValue, RandomVariable riskFreeRate, RandomVariable volatility, double optionMaturity, RandomVariable optionStrike) {
        if (optionMaturity < 0.0) {
            return initialStockValue.mult(0.0);
        }
        RandomVariable dPlus = initialStockValue.div(optionStrike).log().add(volatility.squared().mult(0.5).add(riskFreeRate).mult(optionMaturity)).div(volatility).div(Math.sqrt(optionMaturity));
        RandomVariable delta = dPlus.apply(NormalDistribution::cumulativeDistribution);
        return delta;
    }

    public static double blackScholesOptionGamma(double initialStockValue, double riskFreeRate, double volatility, double optionMaturity, double optionStrike) {
        if (optionStrike <= 0.0 || optionMaturity <= 0.0) {
            return 0.0;
        }
        double dPlus = (Math.log(initialStockValue / optionStrike) + (riskFreeRate + 0.5 * volatility * volatility) * optionMaturity) / (volatility * Math.sqrt(optionMaturity));
        double gamma = Math.exp(-0.5 * dPlus * dPlus) / (Math.sqrt(Math.PI * 2 * optionMaturity) * initialStockValue * volatility);
        return gamma;
    }

    public static RandomVariable blackScholesOptionGamma(RandomVariable initialStockValue, RandomVariable riskFreeRate, RandomVariable volatility, double optionMaturity, double optionStrike) {
        if (optionStrike <= 0.0 || optionMaturity <= 0.0) {
            return initialStockValue.mult(0.0);
        }
        RandomVariable dPlus = initialStockValue.div(optionStrike).log().add(volatility.squared().mult(0.5).add(riskFreeRate).mult(optionMaturity)).div(volatility).div(Math.sqrt(optionMaturity));
        RandomVariable gamma = dPlus.squared().mult(-0.5).exp().div(initialStockValue.mult(volatility).mult(Math.sqrt(Math.PI * 2 * optionMaturity)));
        return gamma;
    }

    public static RandomVariable blackScholesOptionGamma(RandomVariable initialStockValue, double riskFreeRate, double volatility, double optionMaturity, double optionStrike) {
        return AnalyticFormulas.blackScholesOptionGamma(initialStockValue, new Scalar(riskFreeRate), new Scalar(volatility), optionMaturity, optionStrike);
    }

    public static double blackScholesOptionVega(double initialStockValue, double riskFreeRate, double volatility, double optionMaturity, double optionStrike) {
        if (optionStrike <= 0.0 || optionMaturity <= 0.0) {
            return 0.0;
        }
        double dPlus = (Math.log(initialStockValue / optionStrike) + (riskFreeRate + 0.5 * volatility * volatility) * optionMaturity) / (volatility * Math.sqrt(optionMaturity));
        double vega = Math.exp(-0.5 * dPlus * dPlus) / Math.sqrt(Math.PI * 2) * initialStockValue * Math.sqrt(optionMaturity);
        return vega;
    }

    public static RandomVariable blackScholesOptionVega(RandomVariable initialStockValue, RandomVariable riskFreeRate, RandomVariable volatility, double optionMaturity, double optionStrike) {
        if (optionStrike <= 0.0 || optionMaturity <= 0.0) {
            return initialStockValue.mult(0.0);
        }
        RandomVariable dPlus = initialStockValue.div(optionStrike).log().add(volatility.squared().mult(0.5).add(riskFreeRate).mult(optionMaturity)).div(volatility).div(Math.sqrt(optionMaturity));
        RandomVariable vega = dPlus.squared().mult(-0.5).exp().div(Math.sqrt(Math.PI * 2 * optionMaturity)).mult(initialStockValue).mult(volatility);
        return vega;
    }

    public static RandomVariable blackScholesOptionVega(RandomVariable initialStockValue, double riskFreeRate, double volatility, double optionMaturity, double optionStrike) {
        return AnalyticFormulas.blackScholesOptionVega(initialStockValue, new Scalar(riskFreeRate), new Scalar(volatility), optionMaturity, optionStrike);
    }

    public static double blackScholesOptionTheta(double initialStockValue, double riskFreeRate, double volatility, double optionMaturity, double optionStrike) {
        if (optionStrike <= 0.0 || optionMaturity <= 0.0) {
            return 0.0;
        }
        double dPlus = (Math.log(initialStockValue / optionStrike) + (riskFreeRate + 0.5 * volatility * volatility) * optionMaturity) / (volatility * Math.sqrt(optionMaturity));
        double dMinus = dPlus - volatility * Math.sqrt(optionMaturity);
        double theta = -volatility * Math.exp(-0.5 * dPlus * dPlus) / Math.sqrt(Math.PI * 2) / Math.sqrt(optionMaturity) / 2.0 * initialStockValue - riskFreeRate * optionStrike * Math.exp(-riskFreeRate * optionMaturity) * NormalDistribution.cumulativeDistribution(dMinus);
        return theta;
    }

    public static double blackScholesOptionRho(double initialStockValue, double riskFreeRate, double volatility, double optionMaturity, double optionStrike) {
        if (optionStrike <= 0.0 || optionMaturity <= 0.0) {
            return 0.0;
        }
        double dMinus = (Math.log(initialStockValue / optionStrike) + (riskFreeRate - 0.5 * volatility * volatility) * optionMaturity) / (volatility * Math.sqrt(optionMaturity));
        double rho = optionStrike * optionMaturity * Math.exp(-riskFreeRate * optionMaturity) * NormalDistribution.cumulativeDistribution(dMinus);
        return rho;
    }

    public static double blackScholesOptionImpliedVolatility(double forward, double optionMaturity, double optionStrike, double payoffUnit, double optionValue) {
        double volatilityUpperBound;
        double q;
        int maxIterations = 500;
        double maxAccuracy = 1.0E-15;
        if (optionStrike <= 0.0) {
            return 0.0;
        }
        double p = NormalDistribution.inverseCumulativeDistribution((optionValue / payoffUnit + optionStrike) / (forward + optionStrike)) / Math.sqrt(optionMaturity);
        double volatilityLowerBound = p + Math.sqrt(Math.max(p * p - (q = 2.0 * Math.abs(Math.log(forward / optionStrike)) / optionMaturity), 0.0));
        if (Math.abs(volatilityLowerBound - (volatilityUpperBound = p + Math.sqrt(p * p + q))) < 1.0E-15) {
            return (volatilityLowerBound + volatilityUpperBound) / 2.0;
        }
        NewtonsMethod solver = new NewtonsMethod(0.5 * (volatilityLowerBound + volatilityUpperBound));
        while (solver.getAccuracy() > 1.0E-15 && !solver.isDone() && solver.getNumberOfIterations() < 500) {
            double volatility = solver.getNextPoint();
            double dPlus = (Math.log(forward / optionStrike) + 0.5 * volatility * volatility * optionMaturity) / (volatility * Math.sqrt(optionMaturity));
            double dMinus = dPlus - volatility * Math.sqrt(optionMaturity);
            double valueAnalytic = (forward * NormalDistribution.cumulativeDistribution(dPlus) - optionStrike * NormalDistribution.cumulativeDistribution(dMinus)) * payoffUnit;
            double derivativeAnalytic = forward * Math.sqrt(optionMaturity) * Math.exp(-0.5 * dPlus * dPlus) / Math.sqrt(Math.PI * 2) * payoffUnit;
            double error = valueAnalytic - optionValue;
            solver.setValueAndDerivative(error, derivativeAnalytic);
        }
        return solver.getBestPoint();
    }

    public static double blackScholesDigitalOptionValue(double initialStockValue, double riskFreeRate, double volatility, double optionMaturity, double optionStrike) {
        if (optionStrike <= 0.0) {
            return 1.0;
        }
        double dPlus = (Math.log(initialStockValue / optionStrike) + (riskFreeRate + 0.5 * volatility * volatility) * optionMaturity) / (volatility * Math.sqrt(optionMaturity));
        double dMinus = dPlus - volatility * Math.sqrt(optionMaturity);
        double valueAnalytic = Math.exp(-riskFreeRate * optionMaturity) * NormalDistribution.cumulativeDistribution(dMinus);
        return valueAnalytic;
    }

    public static double blackScholesDigitalOptionDelta(double initialStockValue, double riskFreeRate, double volatility, double optionMaturity, double optionStrike) {
        if (optionStrike <= 0.0 || optionMaturity <= 0.0) {
            return 0.0;
        }
        double dPlus = (Math.log(initialStockValue / optionStrike) + (riskFreeRate + 0.5 * volatility * volatility) * optionMaturity) / (volatility * Math.sqrt(optionMaturity));
        double dMinus = dPlus - volatility * Math.sqrt(optionMaturity);
        double delta = Math.exp(-riskFreeRate * optionMaturity) * Math.exp(-0.5 * dMinus * dMinus) / (Math.sqrt(Math.PI * 2 * optionMaturity) * initialStockValue * volatility);
        return delta;
    }

    public static double blackScholesDigitalOptionVega(double initialStockValue, double riskFreeRate, double volatility, double optionMaturity, double optionStrike) {
        if (optionStrike <= 0.0 || optionMaturity <= 0.0) {
            return 0.0;
        }
        double dPlus = (Math.log(initialStockValue / optionStrike) + (riskFreeRate + 0.5 * volatility * volatility) * optionMaturity) / (volatility * Math.sqrt(optionMaturity));
        double dMinus = dPlus - volatility * Math.sqrt(optionMaturity);
        double vega = -Math.exp(-riskFreeRate * optionMaturity) * Math.exp(-0.5 * dMinus * dMinus) / Math.sqrt(Math.PI * 2) * dPlus / volatility;
        return vega;
    }

    public static double blackScholesDigitalOptionRho(double initialStockValue, double riskFreeRate, double volatility, double optionMaturity, double optionStrike) {
        if (optionMaturity <= 0.0) {
            return 0.0;
        }
        if (optionStrike <= 0.0) {
            double rho = -optionMaturity * Math.exp(-riskFreeRate * optionMaturity);
            return rho;
        }
        double dMinus = (Math.log(initialStockValue / optionStrike) + (riskFreeRate - 0.5 * volatility * volatility) * optionMaturity) / (volatility * Math.sqrt(optionMaturity));
        double rho = -optionMaturity * Math.exp(-riskFreeRate * optionMaturity) * NormalDistribution.cumulativeDistribution(dMinus) + Math.sqrt(optionMaturity) / volatility * Math.exp(-riskFreeRate * optionMaturity) * Math.exp(-0.5 * dMinus * dMinus) / Math.sqrt(Math.PI * 2);
        return rho;
    }

    public static double blackModelCapletValue(double forward, double volatility, double optionMaturity, double optionStrike, double periodLength, double discountFactor) {
        return AnalyticFormulas.blackScholesGeneralizedOptionValue(forward, volatility, optionMaturity, optionStrike, periodLength * discountFactor);
    }

    public static double blackModelCapletImpliedVolatility(double forward, double optionMaturity, double optionStrike, double periodLength, double discountFactor, double value) {
        return AnalyticFormulas.blackScholesOptionImpliedVolatility(forward, optionMaturity, optionStrike, periodLength * discountFactor, value);
    }

    public static double blackModelDigitalCapletValue(double forward, double volatility, double periodLength, double discountFactor, double optionMaturity, double optionStrike) {
        return AnalyticFormulas.blackScholesDigitalOptionValue(forward, 0.0, volatility, optionMaturity, optionStrike) * periodLength * discountFactor;
    }

    public static double blackModelDigitalCapletDelta(double forward, double volatility, double periodLength, double discountFactor, double optionMaturity, double optionStrike) {
        return AnalyticFormulas.blackScholesDigitalOptionDelta(forward, 0.0, volatility, optionMaturity, optionStrike) * periodLength * discountFactor;
    }

    public static double blackModelDgitialCapletValue(double forward, double volatility, double periodLength, double discountFactor, double optionMaturity, double optionStrike) {
        return AnalyticFormulas.blackModelDigitalCapletValue(forward, volatility, periodLength, discountFactor, optionMaturity, optionStrike);
    }

    public static double blackModelSwaptionValue(double forwardSwaprate, double volatility, double optionMaturity, double optionStrike, double swapAnnuity) {
        return AnalyticFormulas.blackScholesGeneralizedOptionValue(forwardSwaprate, volatility, optionMaturity, optionStrike, swapAnnuity);
    }

    public static double margrabeExchangeOptionValue(double spot1, double spot2, double volatility1, double volatility2, double correlation, double optionMaturity) {
        double volatility = Math.sqrt(volatility1 * volatility1 + volatility2 * volatility2 - 2.0 * volatility1 * volatility2 * correlation);
        return AnalyticFormulas.blackScholesGeneralizedOptionValue(spot1, volatility, optionMaturity, spot2, 1.0);
    }

    public static double bachelierOptionValue(double forward, double volatility, double optionMaturity, double optionStrike, double payoffUnit) {
        return BachelierModel.bachelierOptionValue(forward, volatility, optionMaturity, optionStrike, payoffUnit);
    }

    public static RandomVariable bachelierOptionValue(RandomVariable forward, RandomVariable volatility, double optionMaturity, double optionStrike, RandomVariable payoffUnit) {
        return BachelierModel.bachelierOptionValue(forward, volatility, optionMaturity, optionStrike, payoffUnit);
    }

    public static double bachelierOptionImpliedVolatility(double forward, double optionMaturity, double optionStrike, double payoffUnit, double optionValue) {
        return BachelierModel.bachelierOptionImpliedVolatility(forward, optionMaturity, optionStrike, payoffUnit, optionValue);
    }

    public static double bachelierOptionDelta(double forward, double volatility, double optionMaturity, double optionStrike, double payoffUnit) {
        return BachelierModel.bachelierOptionDelta(forward, volatility, optionMaturity, optionStrike, payoffUnit);
    }

    public static double huntKennedyCMSOptionValue(double forwardSwaprate, double volatility, double swapAnnuity, double optionMaturity, double swapMaturity, double payoffUnit, double optionStrike) {
        double a = 1.0 / swapMaturity;
        double b = (payoffUnit / swapAnnuity - a) / forwardSwaprate;
        double convexityAdjustment = Math.exp(volatility * volatility * optionMaturity);
        double valueUnadjusted = AnalyticFormulas.blackModelSwaptionValue(forwardSwaprate, volatility, optionMaturity, optionStrike, swapAnnuity);
        double valueAdjusted = AnalyticFormulas.blackModelSwaptionValue(forwardSwaprate * convexityAdjustment, volatility, optionMaturity, optionStrike, swapAnnuity);
        return a * valueUnadjusted + b * forwardSwaprate * valueAdjusted;
    }

    public static double huntKennedyCMSFloorValue(double forwardSwaprate, double volatility, double swapAnnuity, double optionMaturity, double swapMaturity, double payoffUnit, double optionStrike) {
        double huntKennedyCMSOptionValue = AnalyticFormulas.huntKennedyCMSOptionValue(forwardSwaprate, volatility, swapAnnuity, optionMaturity, swapMaturity, payoffUnit, optionStrike);
        return huntKennedyCMSOptionValue + optionStrike * payoffUnit;
    }

    public static double huntKennedyCMSAdjustedRate(double forwardSwaprate, double volatility, double swapAnnuity, double optionMaturity, double swapMaturity, double payoffUnit) {
        double a = 1.0 / swapMaturity;
        double b = (payoffUnit / swapAnnuity - a) / forwardSwaprate;
        double convexityAdjustment = Math.exp(volatility * volatility * optionMaturity);
        double rateUnadjusted = forwardSwaprate;
        double rateAdjusted = forwardSwaprate * convexityAdjustment;
        return (a * rateUnadjusted + b * forwardSwaprate * rateAdjusted) * swapAnnuity / payoffUnit;
    }

    public static double sabrHaganLognormalBlackVolatilityApproximation(double alpha, double beta, double rho, double nu, double underlying, double strike, double maturity) {
        return AnalyticFormulas.sabrHaganLognormalBlackVolatilityApproximation(alpha, beta, rho, nu, 0.0, underlying, strike, maturity);
    }

    public static double sabrHaganLognormalBlackVolatilityApproximation(double alpha, double beta, double rho, double nu, double displacement, double underlying, double strike, double maturity) {
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("&alpha; must be greater than 0.");
        }
        if (rho > 1.0 || rho < -1.0) {
            throw new IllegalArgumentException("&rho; must be between -1 and 1.");
        }
        if (nu <= 0.0) {
            throw new IllegalArgumentException("&nu; must be greater than 0.");
        }
        if (underlying <= 0.0) {
            throw new IllegalArgumentException("Approximation not definied for non-positive underlyings.");
        }
        if (Math.abs((underlying += displacement) - (strike += displacement)) < 1.0E-4 * (1.0 + Math.abs(underlying))) {
            double term1 = alpha / Math.pow(underlying, 1.0 - beta);
            double term2 = Math.pow(1.0 - beta, 2.0) / 24.0 * Math.pow(alpha, 2.0) / Math.pow(underlying, 2.0 * (1.0 - beta)) + rho * beta * alpha * nu / (4.0 * Math.pow(underlying, 1.0 - beta)) + (2.0 - 3.0 * rho * rho) * nu * nu / 24.0;
            return term1 * (1.0 + term2 * maturity);
        }
        double forwardTimesStrike = underlying * strike;
        double z = nu / alpha * Math.pow(forwardTimesStrike, (1.0 - beta) / 2.0) * Math.log(underlying / strike);
        double x = Math.log((Math.sqrt(1.0 - 2.0 * rho * z + z * z) + z - rho) / (1.0 - rho));
        double term1 = alpha / Math.pow(forwardTimesStrike, (1.0 - beta) / 2.0) / (1.0 + Math.pow(1.0 - beta, 2.0) / 24.0 * Math.pow(Math.log(underlying / strike), 2.0) + Math.pow(1.0 - beta, 4.0) / 1920.0 * Math.pow(Math.log(underlying / strike), 4.0));
        double term2 = Math.abs(x - z) < 1.0E-10 ? 1.0 : z / x;
        double term3 = 1.0 + (Math.pow(1.0 - beta, 2.0) / 24.0 * Math.pow(alpha, 2.0) / Math.pow(forwardTimesStrike, 1.0 - beta) + rho * beta * nu * alpha / 4.0 / Math.pow(forwardTimesStrike, (1.0 - beta) / 2.0) + (2.0 - 3.0 * rho * rho) / 24.0 * nu * nu) * maturity;
        return term1 * term2 * term3;
    }

    public static double sabrBerestyckiNormalVolatilityApproximation(double alpha, double beta, double rho, double nu, double displacement, double underlying, double strike, double maturity) {
        double forwardStrikeAverage = ((underlying += displacement) + (strike += displacement)) / 2.0;
        double z = beta < 1.0 ? nu / alpha * (Math.pow(underlying, 1.0 - beta) - Math.pow(strike, 1.0 - beta)) / (1.0 - beta) : nu / alpha * Math.log(underlying / strike);
        double x = Math.log((Math.sqrt(1.0 - 2.0 * rho * z + z * z) + z - rho) / (1.0 - rho));
        double term1 = Math.abs(underlying - strike) < 1.0E-10 * (1.0 + Math.abs(underlying)) ? alpha * Math.pow(underlying, beta) : (x == 0.0 ? (beta < 1.0 ? (underlying - strike) * alpha / (Math.pow(underlying, 1.0 - beta) - Math.pow(strike, 1.0 - beta)) / (1.0 - beta) : (underlying - strike) * alpha / Math.log(underlying / strike)) : nu * (underlying - strike) / x);
        double sigma = term1 * (1.0 + maturity * (-beta * (2.0 - beta) * alpha * alpha / (24.0 * Math.pow(forwardStrikeAverage, 2.0 * (1.0 - beta))) + beta * alpha * rho * nu / (4.0 * Math.pow(forwardStrikeAverage, 1.0 - beta)) + (2.0 - 3.0 * rho * rho) * nu * nu / 24.0));
        return Math.max(sigma, 0.0);
    }

    public static double sabrNormalVolatilityApproximation(double alpha, double beta, double rho, double nu, double displacement, double underlying, double strike, double maturity) {
        double term1;
        double forwardStrikeAverage = ((underlying += displacement) + (strike += displacement)) / 2.0;
        double z = nu / alpha * (underlying - strike) / Math.pow(forwardStrikeAverage, beta);
        double x = Math.log((Math.sqrt(1.0 - 2.0 * rho * z + z * z) + z - rho) / (1.0 - rho));
        if (Math.abs(underlying - strike) < 1.0E-8 * (1.0 + Math.abs(underlying))) {
            term1 = alpha * Math.pow(underlying, beta);
        } else {
            double z2 = (1.0 - beta) / (Math.pow(underlying, 1.0 - beta) - Math.pow(strike, 1.0 - beta));
            term1 = alpha * z2 * z * (underlying - strike) / x;
        }
        double sigma = term1 * (1.0 + maturity * (-beta * (2.0 - beta) * alpha * alpha / (24.0 * Math.pow(forwardStrikeAverage, 2.0 * (1.0 - beta))) + beta * alpha * rho * nu / (4.0 * Math.pow(forwardStrikeAverage, 1.0 - beta)) + (2.0 - 3.0 * rho * rho) * nu * nu / 24.0));
        return Math.max(sigma, 0.0);
    }

    public static double sabrAlphaApproximation(double normalVolatility, double beta, double rho, double nu, double displacement, double underlying, double maturity) {
        double forwardStrikeAverage = underlying += displacement;
        double guess = normalVolatility / Math.pow(underlying, beta);
        NewtonsMethod search = new NewtonsMethod(guess);
        while (!search.isDone() && search.getAccuracy() > 1.0E-16 && search.getNumberOfIterations() < 100) {
            double alpha = search.getNextPoint();
            double term1 = alpha * Math.pow(underlying, beta);
            double term2 = 1.0 + maturity * (-beta * (2.0 - beta) * alpha * alpha / (24.0 * Math.pow(forwardStrikeAverage, 2.0 * (1.0 - beta))) + beta * alpha * rho * nu / (4.0 * Math.pow(forwardStrikeAverage, 1.0 - beta)) + (2.0 - 3.0 * rho * rho) * nu * nu / 24.0);
            double derivativeTerm1 = Math.pow(underlying, beta);
            double derivativeTerm2 = maturity * (2.0 * (-beta * (2.0 - beta) * alpha) / (24.0 * Math.pow(forwardStrikeAverage, 2.0 * (1.0 - beta))) + beta * rho * nu / (4.0 * Math.pow(forwardStrikeAverage, 1.0 - beta)));
            double sigma = term1 * term2;
            double derivative = derivativeTerm1 * term2 + term1 * derivativeTerm2;
            search.setValueAndDerivative(sigma - normalVolatility, derivative);
        }
        return search.getBestPoint();
    }

    public static double sabrNormalVolatilitySkewApproximation(double alpha, double beta, double rho, double nu, double displacement, double underlying, double maturity) {
        double sigma = AnalyticFormulas.sabrBerestyckiNormalVolatilityApproximation(alpha, beta, rho, nu, displacement, underlying, underlying, maturity);
        double a = alpha / Math.pow(underlying += displacement, 1.0 - beta);
        double c = 0.041666666666666664 * Math.pow(a, 3.0) * beta * (1.0 - beta);
        double skew = (rho * nu / a + beta) * (0.5 * sigma / underlying) - maturity * c * (3.0 * rho * nu / a + beta - 2.0);
        return skew;
    }

    public static double sabrNormalVolatilityCurvatureApproximation(double alpha, double beta, double rho, double nu, double displacement, double underlying, double maturity) {
        double sigma = AnalyticFormulas.sabrBerestyckiNormalVolatilityApproximation(alpha, beta, rho, nu, displacement, underlying, underlying, maturity);
        double d2Part1dK2 = nu * ((0.3333333333333333 - 0.5 * rho * rho) * nu / alpha * Math.pow(underlying += displacement, -beta) + (0.16666666666666666 * beta * beta - 0.3333333333333333 * beta) * alpha / nu * Math.pow(underlying, beta - 2.0));
        double d0BdK0 = -0.041666666666666664 * beta * (2.0 - beta) * alpha * alpha * Math.pow(underlying, 2.0 * beta - 2.0) + 0.25 * beta * alpha * rho * nu * Math.pow(underlying, beta - 1.0) + (2.0 - 3.0 * rho * rho) * nu * nu / 24.0;
        double d1BdK1 = -0.020833333333333332 * beta * (2.0 - beta) * (2.0 * beta - 2.0) * alpha * alpha * Math.pow(underlying, 2.0 * beta - 3.0) + 0.125 * beta * (beta - 1.0) * alpha * rho * nu * Math.pow(underlying, beta - 2.0);
        double d2BdK2 = -0.010416666666666666 * beta * (2.0 - beta) * (2.0 * beta - 2.0) * (2.0 * beta - 3.0) * alpha * alpha * Math.pow(underlying, 2.0 * beta - 4.0) + 0.0625 * beta * (beta - 1.0) * (beta - 2.0) * alpha * rho * nu * Math.pow(underlying, beta - 3.0);
        double curvatureApproximation = nu / alpha * ((0.3333333333333333 - 0.5 * rho * rho) * sigma * nu / alpha * Math.pow(underlying, -2.0 * beta));
        double curvaturePart1 = nu / alpha * ((0.3333333333333333 - 0.5 * rho * rho) * sigma * nu / alpha * Math.pow(underlying, -2.0 * beta) + (0.16666666666666666 * beta * beta - 0.3333333333333333 * beta) * sigma * alpha / nu * Math.pow(underlying, -2.0));
        double curvatureMaturityPart = (rho * nu + alpha * beta * Math.pow(underlying, beta - 1.0)) * d1BdK1 + alpha * Math.pow(underlying, beta) * d2BdK2;
        return curvaturePart1 + maturity * curvatureMaturityPart;
    }

    public static double volatilityConversionLognormalATMtoNormalATM(double forward, double displacement, double optionMaturity, double lognormalVolatility) {
        double x = lognormalVolatility * Math.sqrt(optionMaturity / 8.0);
        double y = Erf.erf((double)x);
        double normalVol = Math.sqrt(Math.PI * 2 / optionMaturity) * (forward + displacement) * y;
        return normalVol;
    }

    public static double volatilityConversionLognormalToNormal(double forward, double displacement, double optionMaturity, double optionStrike, double lognormalVolatility) {
        double payoffUnit = 1.0;
        double optionValue = AnalyticFormulas.blackScholesGeneralizedOptionValue(forward + displacement, lognormalVolatility, optionMaturity, optionStrike + displacement, 1.0);
        double impliedNormalVolatility = AnalyticFormulas.bachelierOptionImpliedVolatility(forward, optionMaturity, optionStrike, 1.0, optionValue);
        return impliedNormalVolatility;
    }

    public static double price(Date settlementDate, Date maturityDate, double coupon, double yield, double redemption, int frequency) {
        double price = 0.0;
        if (maturityDate.after(settlementDate)) {
            price += redemption;
        }
        Calendar paymentDate = Calendar.getInstance();
        paymentDate.setTime(maturityDate);
        while (paymentDate.after(settlementDate)) {
            price += coupon;
            price /= 1.0 + yield / (double)frequency;
            paymentDate.add(2, -12 / frequency);
        }
        Calendar periodEndDate = (Calendar)paymentDate.clone();
        periodEndDate.add(2, 12 / frequency);
        double accrualPeriod = (paymentDate.getTimeInMillis() - settlementDate.getTime()) / (periodEndDate.getTimeInMillis() - paymentDate.getTimeInMillis());
        price *= Math.pow(1.0 + yield / (double)frequency, accrualPeriod);
        return price -= coupon * accrualPeriod;
    }

    public static double price(double timeToMaturity, double coupon, double yield, double redemption, int frequency) {
        double paymentTime;
        double price = 0.0;
        if (timeToMaturity > 0.0) {
            price += redemption;
        }
        for (paymentTime = timeToMaturity; paymentTime > 0.0; paymentTime -= 1.0 / (double)frequency) {
            price += coupon;
            price /= 1.0 + yield / (double)frequency;
        }
        double accrualPeriod = 0.0 - paymentTime;
        price *= Math.pow(1.0 + yield / (double)frequency, accrualPeriod);
        return price -= coupon * accrualPeriod;
    }

    public static double bachelierGeneralizedOptionVega(double forward, double volatility, double optionMaturity, double optionStrike, double payoffUnit) {
        if (optionMaturity < 0.0) {
            return 0.0;
        }
        if (forward == optionStrike) {
            return Math.sqrt(optionMaturity / (Math.PI * 2)) * payoffUnit;
        }
        double dPlus = (forward - optionStrike) / (volatility * Math.sqrt(optionMaturity));
        double vegaAnalytic = Math.sqrt(optionMaturity) * NormalDistribution.density(dPlus) * payoffUnit;
        return vegaAnalytic;
    }

    public static double blackScholesGeneralizedOptionVega(double forward, double volatility, double optionMaturity, double optionStrike, double payoffUnit) {
        if (optionStrike <= 0.0 || optionMaturity <= 0.0) {
            return 0.0;
        }
        double dPlus = (Math.log(forward / optionStrike) + 0.5 * volatility * volatility * optionMaturity) / (volatility * Math.sqrt(optionMaturity));
        double vega = payoffUnit * NormalDistribution.density(dPlus) * forward * Math.sqrt(optionMaturity);
        return vega;
    }

    public static double constantElasticityOfVarianceOptionValue(double initialStockValue, double riskFreeRate, double volatility, double exponent, double optionMaturity, double optionStrike, boolean isCall) {
        double kappa = 2.0 * riskFreeRate / (Math.pow(volatility, 2.0) * (1.0 - exponent) * (Math.exp(2.0 * riskFreeRate * (1.0 - exponent) * optionMaturity) - 1.0));
        double z = 2.0 + 1.0 / (1.0 - exponent);
        double y = kappa * Math.pow(optionStrike, 2.0 * (1.0 - exponent));
        double x = kappa * Math.pow(initialStockValue, 2.0 * (1.0 - exponent)) * Math.exp(2.0 * riskFreeRate * (1.0 - exponent) * optionMaturity);
        NonCentralChiSquaredDistribution P1 = new NonCentralChiSquaredDistribution(z, x);
        NonCentralChiSquaredDistribution P2 = new NonCentralChiSquaredDistribution(z - 2.0, y);
        if (isCall) {
            return initialStockValue * (1.0 - P1.cumulativeDistribution(y)) - optionStrike * Math.exp(-riskFreeRate * optionMaturity) * P2.cumulativeDistribution(x);
        }
        return -initialStockValue * P1.cumulativeDistribution(y) + optionStrike * Math.exp(-riskFreeRate * optionMaturity) * (1.0 - P2.cumulativeDistribution(x));
    }
}

