/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.functions;

import net.finmath.functions.NormalDistribution;

public class BarrierOptions {
    private BarrierOptions() {
    }

    public static double blackScholesBarrierOptionValue(double initialStockValue, double riskFreeRate, double dividendYield, double volatility, double optionMaturity, double optionStrike, boolean isCall, double rebate, double barrierValue, BarrierType barrierType) {
        int phi = isCall ? 1 : -1;
        int eta = 0;
        switch (barrierType) {
            case UP_IN: {
                eta = -1;
                break;
            }
            case DOWN_IN: {
                eta = 1;
                break;
            }
            case UP_OUT: {
                eta = -1;
                break;
            }
            case DOWN_OUT: {
                eta = 1;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid barrier type.");
            }
        }
        double volSq = volatility * volatility;
        double volTime = volatility * Math.sqrt(optionMaturity);
        double mu = (dividendYield - 0.5 * volSq) / volSq;
        double lambda = Math.sqrt(mu * mu + 2.0 * riskFreeRate / volSq);
        double z = Math.log(barrierValue / initialStockValue) / volTime + lambda * volTime;
        double muVolTime = (1.0 + mu) * volTime;
        double x1 = Math.log(initialStockValue / optionStrike) / volTime + muVolTime;
        double x2 = Math.log(initialStockValue / barrierValue) / volTime + muVolTime;
        double y1 = Math.log(barrierValue * barrierValue / (initialStockValue * optionStrike)) / volTime + muVolTime;
        double y2 = Math.log(barrierValue / initialStockValue) / volTime + muVolTime;
        double A = (double)phi * initialStockValue * Math.exp((dividendYield - riskFreeRate) * optionMaturity) * NormalDistribution.cumulativeDistribution((double)phi * x1) - (double)phi * optionStrike * Math.exp(-riskFreeRate * optionMaturity) * NormalDistribution.cumulativeDistribution((double)phi * (x1 - volTime));
        double B = (double)phi * initialStockValue * Math.exp((dividendYield - riskFreeRate) * optionMaturity) * NormalDistribution.cumulativeDistribution((double)phi * x2) - (double)phi * optionStrike * Math.exp(-riskFreeRate * optionMaturity) * NormalDistribution.cumulativeDistribution((double)phi * (x2 - volTime));
        double C = (double)phi * initialStockValue * Math.exp((dividendYield - riskFreeRate) * optionMaturity) * Math.pow(barrierValue / initialStockValue, 2.0 * (mu + 1.0)) * NormalDistribution.cumulativeDistribution((double)eta * y1) - (double)phi * optionStrike * Math.exp(-riskFreeRate * optionMaturity) * Math.pow(barrierValue / initialStockValue, 2.0 * mu) * NormalDistribution.cumulativeDistribution((double)eta * (y1 - volTime));
        double D = (double)phi * initialStockValue * Math.exp((dividendYield - riskFreeRate) * optionMaturity) * Math.pow(barrierValue / initialStockValue, 2.0 * (mu + 1.0)) * NormalDistribution.cumulativeDistribution((double)eta * y2) - (double)phi * optionStrike * Math.exp(-riskFreeRate * optionMaturity) * Math.pow(barrierValue / initialStockValue, 2.0 * mu) * NormalDistribution.cumulativeDistribution((double)eta * (y2 - volTime));
        double E = rebate * Math.exp(-riskFreeRate * optionMaturity) * (NormalDistribution.cumulativeDistribution((double)eta * (x2 - volTime)) - Math.pow(barrierValue / initialStockValue, 2.0 * mu) * NormalDistribution.cumulativeDistribution((double)eta * (y2 - volTime)));
        double F = rebate * (Math.pow(barrierValue / initialStockValue, mu + lambda) * NormalDistribution.cumulativeDistribution((double)eta * z) + Math.pow(barrierValue / initialStockValue, mu - lambda) * NormalDistribution.cumulativeDistribution((double)eta * (z - 2.0 * lambda * volTime)));
        double optionValue = 0.0;
        switch (barrierType) {
            case DOWN_IN: {
                if (isCall) {
                    if (optionStrike >= barrierValue) {
                        optionValue = C + E;
                        break;
                    }
                    optionValue = A - B + D + E;
                    break;
                }
                if (optionStrike >= barrierValue) {
                    optionValue = B - C + D + E;
                    break;
                }
                optionValue = A + E;
                break;
            }
            case UP_IN: {
                if (isCall) {
                    if (optionStrike >= barrierValue) {
                        optionValue = A + E;
                        break;
                    }
                    optionValue = B - C + D + E;
                    break;
                }
                if (optionStrike >= barrierValue) {
                    optionValue = A - B + D + E;
                    break;
                }
                optionValue = C + E;
                break;
            }
            case DOWN_OUT: {
                if (isCall) {
                    if (optionStrike >= barrierValue) {
                        optionValue = A - C + F;
                        break;
                    }
                    optionValue = B - D + F;
                    break;
                }
                if (optionStrike >= barrierValue) {
                    optionValue = A - B + C - D + F;
                    break;
                }
                optionValue = F;
                break;
            }
            case UP_OUT: {
                if (isCall) {
                    if (optionStrike >= barrierValue) {
                        optionValue = F;
                        break;
                    }
                    optionValue = A - B + C - D + F;
                    break;
                }
                if (optionStrike >= barrierValue) {
                    optionValue = B - D + F;
                    break;
                }
                optionValue = A - C + F;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid barrier type.");
            }
        }
        return optionValue;
    }

    public static enum BarrierType {
        DOWN_IN,
        UP_IN,
        DOWN_OUT,
        UP_OUT;

    }
}

