/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.functions;

import java.util.function.Function;
import net.finmath.interpolation.RationalFunctionInterpolation;
import org.apache.commons.math3.complex.Complex;
import org.apache.commons.math3.transform.DftNormalization;
import org.apache.commons.math3.transform.FastFourierTransformer;
import org.apache.commons.math3.transform.TransformType;

public class HestonModel {
    static final RationalFunctionInterpolation.InterpolationMethod intMethod = RationalFunctionInterpolation.InterpolationMethod.LINEAR;
    static final RationalFunctionInterpolation.ExtrapolationMethod extMethod = RationalFunctionInterpolation.ExtrapolationMethod.CONSTANT;
    static final int numberOfPoints = 8192;
    static final double gridSpacing = 0.4;

    public static double hestonOptionDelta(double initialStockValue, double riskFreeRate, double discountRate, double sigma, double theta, double kappa, double xi, double rho, double optionMaturity, double optionStrike) {
        HestonGreek whatToCompute = HestonGreek.DELTA;
        return HestonModel.hestonGreekCalculator(initialStockValue, riskFreeRate, discountRate, sigma, theta, kappa, xi, rho, optionMaturity, optionStrike, whatToCompute, 8192, 0.4);
    }

    public static double hestonOptionGamma(double initialStockValue, double riskFreeRate, double discountRate, double sigma, double theta, double kappa, double xi, double rho, double optionMaturity, double optionStrike) {
        HestonGreek whatToCompute = HestonGreek.GAMMA;
        return HestonModel.hestonGreekCalculator(initialStockValue, riskFreeRate, discountRate, sigma, theta, kappa, xi, rho, optionMaturity, optionStrike, whatToCompute, 8192, 0.4);
    }

    public static double hestonOptionTheta(double initialStockValue, double riskFreeRate, double discountRate, double sigma, double theta, double kappa, double xi, double rho, double optionMaturity, double optionStrike) {
        HestonGreek whatToCompute = HestonGreek.THETA;
        return HestonModel.hestonGreekCalculator(initialStockValue, riskFreeRate, discountRate, sigma, theta, kappa, xi, rho, optionMaturity, optionStrike, whatToCompute, 8192, 0.4);
    }

    public static double hestonOptionRho(double initialStockValue, double riskFreeRate, double discountRate, double sigma, double theta, double kappa, double xi, double rho, double optionMaturity, double optionStrike) {
        HestonGreek whatToCompute = HestonGreek.RHO;
        return HestonModel.hestonGreekCalculator(initialStockValue, riskFreeRate, discountRate, sigma, theta, kappa, xi, rho, optionMaturity, optionStrike, whatToCompute, 8192, 0.4);
    }

    public static double hestonOptionVega(double initialStockValue, double riskFreeRate, double discountRate, double sigma, double theta, double kappa, double xi, double rho, double optionMaturity, double optionStrike) {
        return HestonModel.hestonOptionVega1(initialStockValue, riskFreeRate, discountRate, sigma, theta, kappa, xi, rho, optionMaturity, optionStrike) * 2.0 * sigma;
    }

    public static double hestonOptionVega1(double initialStockValue, double riskFreeRate, double discountRate, double sigma, double theta, double kappa, double xi, double rho, double optionMaturity, double optionStrike) {
        HestonGreek whatToCompute = HestonGreek.VEGA1;
        return HestonModel.hestonGreekCalculator(initialStockValue, riskFreeRate, discountRate, sigma, theta, kappa, xi, rho, optionMaturity, optionStrike, whatToCompute, 8192, 0.4);
    }

    public static double hestonOptionVanna(double initialStockValue, double riskFreeRate, double discountRate, double sigma, double theta, double kappa, double xi, double rho, double optionMaturity, double optionStrike) {
        HestonGreek whatToCompute = HestonGreek.VANNA;
        return HestonModel.hestonGreekCalculator(initialStockValue, riskFreeRate, discountRate, sigma, theta, kappa, xi, rho, optionMaturity, optionStrike, whatToCompute, 8192, 0.4);
    }

    public static double hestonOptionVolga(double initialStockValue, double riskFreeRate, double discountRate, double sigma, double theta, double kappa, double xi, double rho, double optionMaturity, double optionStrike) {
        HestonGreek whatToCompute = HestonGreek.VOLGA;
        return HestonModel.hestonGreekCalculator(initialStockValue, riskFreeRate, discountRate, sigma, theta, kappa, xi, rho, optionMaturity, optionStrike, whatToCompute, 8192, 0.4);
    }

    private static Complex hestonCharacteristicFunctionGradient(Complex zeta, double initialStockValue, double riskFreeRate, double discountRate, double sigma, double theta, double kappa, double xi, double rho, double optionMaturity, double optionStrike, HestonGreek whichGreek, int numberOfPoints, double gridSpacing) {
        double lambda = Math.PI * 2 / ((double)numberOfPoints * gridSpacing);
        double v0 = sigma * sigma;
        double x = Math.log(initialStockValue);
        double a = kappa * theta;
        Complex u = new Complex(-0.5, 0.0);
        Complex b = new Complex(kappa + lambda, 0.0);
        Complex term1 = Complex.I.multiply(rho * xi).multiply(zeta).subtract(b);
        Complex powPart = term1.pow(2.0);
        Complex term2 = new Complex(xi * xi, 0.0).multiply(u.multiply(2.0).multiply(Complex.I).multiply(zeta).subtract(zeta.multiply(zeta)));
        Complex d = powPart.subtract(term2).sqrt();
        Complex numerator = b.subtract(Complex.I.multiply(rho * xi).multiply(zeta)).add(d);
        Complex denominator = b.subtract(Complex.I.multiply(rho * xi).multiply(zeta)).subtract(d);
        Complex g = numerator.divide(denominator);
        Complex c = Complex.ZERO;
        Complex D = Complex.ZERO;
        Complex G = Complex.ZERO;
        Complex C = Complex.ZERO;
        c = Complex.ONE.divide(g);
        Complex exp_dT = d.multiply(-optionMaturity).exp();
        Complex bMinusRhoSigmaIphiMinusD = b.subtract(Complex.I.multiply(rho * xi).multiply(zeta)).subtract(d);
        D = bMinusRhoSigmaIphiMinusD.divide(xi * xi).multiply(Complex.ONE.subtract(exp_dT).divide(Complex.ONE.subtract(c.multiply(exp_dT))));
        G = Complex.ONE.subtract(c.multiply(exp_dT)).divide(Complex.ONE.subtract(c));
        Complex firstTerm = Complex.I.multiply(zeta).multiply(riskFreeRate * optionMaturity);
        Complex secondTerm = new Complex(a / (xi * xi), 0.0).multiply(bMinusRhoSigmaIphiMinusD.multiply(optionMaturity).subtract(Complex.valueOf((double)2.0).multiply(G.log())));
        C = firstTerm.add(secondTerm);
        Complex f = C.add(D.multiply(v0)).add(Complex.I.multiply(zeta).multiply(x)).add(-discountRate * optionMaturity).exp();
        switch (whichGreek) {
            case DELTA: {
                return f.multiply(Complex.I).multiply(zeta).divide(initialStockValue);
            }
            case GAMMA: {
                return Complex.I.multiply(zeta).multiply(f).multiply(Complex.I.multiply(zeta).subtract(Complex.ONE)).divide(initialStockValue * initialStockValue);
            }
            case THETA: {
                Complex numerator_dDdT = d.multiply(exp_dT).multiply(b.subtract(Complex.I.multiply(rho * xi).multiply(zeta)).add(d)).multiply(g.subtract(Complex.ONE));
                Complex denominator_dDdT = Complex.valueOf((double)(xi * xi)).multiply(Complex.ONE.subtract(g.multiply(exp_dT)).pow(2.0));
                Complex dDdT = numerator_dDdT.divide(denominator_dDdT);
                Complex innerTerm = b.subtract(Complex.I.multiply(rho * xi).multiply(zeta)).add(d).add(Complex.valueOf((double)2.0).multiply(g).multiply(d).multiply(exp_dT).divide(Complex.ONE.subtract(g.multiply(exp_dT))));
                Complex dCdT = Complex.I.multiply(zeta).multiply(riskFreeRate).add(Complex.valueOf((double)(kappa * theta / (xi * xi))).multiply(innerTerm));
                return Complex.valueOf((double)riskFreeRate).multiply(f).subtract(f.multiply(dCdT.add(dDdT.multiply(v0))));
            }
            case RHO: {
                Complex dCdr = Complex.I.multiply(zeta).multiply(optionMaturity);
                return f.multiply(dCdr).subtract(f.multiply(optionMaturity));
            }
            case VEGA1: {
                return f.multiply(D);
            }
            case VANNA: {
                return f.multiply(Complex.I).multiply(zeta).multiply(D).divide(initialStockValue);
            }
            case VOLGA: {
                return Complex.valueOf((double)2.0).multiply(D).multiply(f).multiply(D.multiply(2.0 * v0).add(Complex.ONE));
            }
        }
        throw new IllegalArgumentException("Unknown Greek: " + whichGreek);
    }

    private static double hestonGreekCalculator(double initialStockValue, double riskFreeRate, double discountRate, double sigma, double theta, double kappa, double xi, double rho, double optionMaturity, double optionStrike, HestonGreek whichGreek, int numberOfPoints, double gridSpacing) {
        double lineOfIntegration = 1.2;
        double lambda = Math.PI * 2 / ((double)numberOfPoints * gridSpacing);
        double upperBound = (double)numberOfPoints * lambda / 2.0;
        double v0 = sigma * sigma;
        Complex[] integrandEvaluations = new Complex[numberOfPoints];
        for (int i = 0; i < numberOfPoints; ++i) {
            double u = gridSpacing * (double)i;
            Complex z = new Complex(u, -1.2);
            Complex numerator = HestonModel.hestonCharacteristicFunctionGradient(z.subtract(Complex.I), initialStockValue, riskFreeRate, discountRate, sigma, theta, kappa, xi, rho, optionMaturity, optionStrike, whichGreek, numberOfPoints, gridSpacing);
            Complex denominator = z.subtract(Complex.I).multiply(z).negate();
            Complex ratio = numerator.divide(denominator);
            ratio = ratio.multiply(Complex.I.multiply(upperBound * u).exp()).multiply(gridSpacing);
            double delta = i == 0 ? 1.0 : 0.0;
            double simpsonWeight = (3.0 + Math.pow(-1.0, i + 1) - delta) / 3.0;
            integrandEvaluations[i] = ratio.multiply(simpsonWeight);
        }
        Complex[] transformedVector = new Complex[numberOfPoints];
        FastFourierTransformer fft = new FastFourierTransformer(DftNormalization.STANDARD);
        transformedVector = fft.transform(integrandEvaluations, TransformType.FORWARD);
        double[] logStrikeVector = new double[numberOfPoints];
        double[] strikeVector = new double[numberOfPoints];
        double[] valuesVector = new double[numberOfPoints];
        for (int j = 0; j < numberOfPoints; ++j) {
            logStrikeVector[j] = -upperBound + lambda * (double)j;
            strikeVector[j] = Math.exp(logStrikeVector[j]);
            valuesVector[j] = transformedVector[j].multiply(Math.exp(-1.2 * logStrikeVector[j])).getReal() / Math.PI;
        }
        final RationalFunctionInterpolation interpolation = new RationalFunctionInterpolation(strikeVector, valuesVector, intMethod, extMethod);
        Function<Double, Double> strikeToValue = new Function<Double, Double>(){

            @Override
            public Double apply(Double t) {
                return interpolation.getValue(t);
            }
        };
        return (Double)strikeToValue.apply(optionStrike);
    }

    private static enum HestonGreek {
        DELTA,
        GAMMA,
        THETA,
        RHO,
        VEGA1,
        VANNA,
        VOLGA;

    }
}

