/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.functions;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.CholeskyDecomposition;
import org.apache.commons.math3.linear.DecompositionSolver;
import org.apache.commons.math3.linear.EigenDecomposition;
import org.apache.commons.math3.linear.LUDecomposition;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.QRDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.linear.SingularValueDecomposition;
import org.jblas.DoubleMatrix;
import org.jblas.MatrixFunctions;
import org.jblas.Solve;

public class LinearAlgebra {
    private static boolean isEigenvalueDecompositionViaSVD = Boolean.parseBoolean(System.getProperty("net.finmath.functions.LinearAlgebra.isEigenvalueDecompositionViaSVD", "false"));
    private static boolean isSolverUseApacheCommonsMath;
    private static boolean isJBlasAvailable;

    public static double[][] getCholeskyDecomposition(double[][] symmetricMatrix) {
        CholeskyDecomposition decomposition = new CholeskyDecomposition((RealMatrix)new Array2DRowRealMatrix(symmetricMatrix));
        double[][] choleskyDecomposition = decomposition.getL().getData();
        return choleskyDecomposition;
    }

    public static double[] solveLinearEquationTikonov(double[][] matrixA, double[] b, double lambda) {
        if (lambda == 0.0) {
            return LinearAlgebra.solveLinearEquationLeastSquare(matrixA, b);
        }
        int rows = matrixA.length;
        int cols = matrixA[0].length;
        double[][] matrixRegularized = new double[rows + cols][cols];
        double[] bRegularized = new double[rows + cols];
        for (int i = 0; i < rows; ++i) {
            System.arraycopy(matrixA[i], 0, matrixRegularized[i], 0, cols);
        }
        System.arraycopy(b, 0, bRegularized, 0, rows);
        for (int j = 0; j < cols; ++j) {
            double[] matrixRow = matrixRegularized[rows + j];
            matrixRow[j] = lambda;
        }
        DecompositionSolver solver = new QRDecomposition((RealMatrix)new Array2DRowRealMatrix(matrixRegularized, false)).getSolver();
        return solver.solve((RealVector)new ArrayRealVector(bRegularized, false)).toArray();
    }

    public static double[] solveLinearEquationTikonov(double[][] matrixA, double[] b, double lambda0, double lambda1, double lambda2) {
        double[] matrixRow;
        int j;
        if (lambda0 == 0.0 && lambda1 == 0.0 && lambda2 == 0.0) {
            return LinearAlgebra.solveLinearEquationLeastSquare(matrixA, b);
        }
        int rows = matrixA.length;
        int cols = matrixA[0].length;
        double[][] matrixRegularized = new double[rows + 3 * cols][cols];
        double[] bRegularized = new double[rows + 3 * cols];
        for (int i = 0; i < rows; ++i) {
            System.arraycopy(matrixA[i], 0, matrixRegularized[i], 0, cols);
        }
        System.arraycopy(b, 0, bRegularized, 0, rows);
        for (j = 0; j < cols; ++j) {
            matrixRow = matrixRegularized[rows + 0 * cols + j];
            matrixRow[j] = lambda0;
        }
        for (j = 0; j < cols; ++j) {
            matrixRow = matrixRegularized[rows + 1 * cols + j];
            matrixRow[j] = 0.0;
            if (j > 0) {
                matrixRow[j - 1] = lambda1;
            }
            if (j >= cols - 1) continue;
            matrixRow[j + 1] = -lambda1;
        }
        for (j = 0; j < cols; ++j) {
            matrixRow = matrixRegularized[rows + 2 * cols + j];
            matrixRow[j] = lambda2;
            if (j > 0) {
                matrixRow[j - 1] = -0.5 * lambda2;
            }
            if (j >= cols - 1) continue;
            matrixRow[j + 1] = -0.5 * lambda2;
        }
        DecompositionSolver solver = new QRDecomposition((RealMatrix)new Array2DRowRealMatrix(matrixRegularized, false)).getSolver();
        return solver.solve((RealVector)new ArrayRealVector(bRegularized, false)).toArray();
    }

    public static double[] solveLinearEquation(double[][] matrixA, double[] b) {
        if (isSolverUseApacheCommonsMath) {
            Array2DRowRealMatrix matrix = new Array2DRowRealMatrix(matrixA);
            DecompositionSolver solver = matrix.getColumnDimension() == matrix.getRowDimension() ? new LUDecomposition((RealMatrix)matrix).getSolver() : new QRDecomposition((RealMatrix)new Array2DRowRealMatrix(matrixA)).getSolver();
            return solver.solve((RealMatrix)new Array2DRowRealMatrix(b)).getColumn(0);
        }
        return Solve.solve((DoubleMatrix)new DoubleMatrix((double[][])matrixA), (DoubleMatrix)new DoubleMatrix((double[])b)).data;
    }

    public static double[] solveLinearEquationSVD(double[][] matrixA, double[] b) {
        if (isSolverUseApacheCommonsMath) {
            Array2DRowRealMatrix matrix = new Array2DRowRealMatrix(matrixA);
            DecompositionSolver solver = new SingularValueDecomposition((RealMatrix)matrix).getSolver();
            return solver.solve((RealMatrix)new Array2DRowRealMatrix(b)).getColumn(0);
        }
        return Solve.solve((DoubleMatrix)new DoubleMatrix((double[][])matrixA), (DoubleMatrix)new DoubleMatrix((double[])b)).data;
    }

    public static double[][] invert(double[][] matrix) {
        if (isSolverUseApacheCommonsMath) {
            LUDecomposition lu = new LUDecomposition((RealMatrix)new Array2DRowRealMatrix(matrix));
            double[][] matrixInverse = lu.getSolver().getInverse().getData();
            return matrixInverse;
        }
        return Solve.pinv((DoubleMatrix)new DoubleMatrix(matrix)).toArray2();
    }

    public static double[] solveLinearEquationSymmetric(double[][] matrix, double[] vector) {
        if (isSolverUseApacheCommonsMath) {
            DecompositionSolver solver = new LUDecomposition((RealMatrix)new Array2DRowRealMatrix(matrix)).getSolver();
            return solver.solve((RealMatrix)new Array2DRowRealMatrix(vector)).getColumn(0);
        }
        return Solve.solveSymmetric((DoubleMatrix)new DoubleMatrix((double[][])matrix), (DoubleMatrix)new DoubleMatrix((double[])vector)).data;
    }

    public static double[] solveLinearEquationLeastSquare(double[][] matrix, double[] vector) {
        DecompositionSolver solver = new SingularValueDecomposition((RealMatrix)new Array2DRowRealMatrix(matrix, false)).getSolver();
        return solver.solve((RealVector)new ArrayRealVector(vector)).toArray();
    }

    public static double[][] solveLinearEquationLeastSquare(double[][] matrix, double[][] rhs) {
        DecompositionSolver solver = new SingularValueDecomposition((RealMatrix)new Array2DRowRealMatrix(matrix, false)).getSolver();
        return solver.solve((RealMatrix)new Array2DRowRealMatrix(rhs)).getData();
    }

    public static double[][] getFactorMatrix(double[][] correlationMatrix, int numberOfFactors) {
        return LinearAlgebra.getFactorMatrixUsingCommonsMath(correlationMatrix, numberOfFactors);
    }

    public static double[][] factorReduction(double[][] correlationMatrix, int numberOfFactors) {
        return LinearAlgebra.factorReductionUsingCommonsMath(correlationMatrix, numberOfFactors);
    }

    private static double[][] getFactorMatrixUsingCommonsMath(double[][] correlationMatrix, int numberOfFactors) {
        double[][] eigenVectorMatrix;
        double[] eigenValues;
        if (isEigenvalueDecompositionViaSVD) {
            SingularValueDecomposition svd = new SingularValueDecomposition((RealMatrix)new Array2DRowRealMatrix(correlationMatrix));
            eigenValues = svd.getSingularValues();
            eigenVectorMatrix = svd.getV().getData();
        } else {
            EigenDecomposition eigenDecomp = new EigenDecomposition((RealMatrix)new Array2DRowRealMatrix(correlationMatrix, false));
            eigenValues = eigenDecomp.getRealEigenvalues();
            eigenVectorMatrix = eigenDecomp.getV().getData();
        }
        class EigenValueIndex
        implements Comparable<EigenValueIndex> {
            private final int index;
            private final Double value;

            EigenValueIndex(int index, double value) {
                this.index = index;
                this.value = value;
            }

            @Override
            public int compareTo(EigenValueIndex o) {
                return o.value.compareTo(this.value);
            }
        }
        ArrayList<EigenValueIndex> eigenValueIndices = new ArrayList<EigenValueIndex>();
        for (int i = 0; i < eigenValues.length; ++i) {
            eigenValueIndices.add(i, new EigenValueIndex(i, eigenValues[i]));
        }
        Collections.sort(eigenValueIndices);
        double[][] factorMatrix = new double[eigenValues.length][numberOfFactors];
        for (int factor = 0; factor < numberOfFactors; ++factor) {
            int row;
            int eigenVectorIndex = ((EigenValueIndex)eigenValueIndices.get((int)factor)).index;
            double eigenValue = eigenValues[eigenVectorIndex];
            double signChange = eigenVectorMatrix[0][eigenVectorIndex] > 0.0 ? 1.0 : -1.0;
            double eigenVectorNormSquared = 0.0;
            for (row = 0; row < eigenValues.length; ++row) {
                eigenVectorNormSquared += eigenVectorMatrix[row][eigenVectorIndex] * eigenVectorMatrix[row][eigenVectorIndex];
            }
            eigenValue = Math.max(eigenValue, 0.0);
            for (row = 0; row < eigenValues.length; ++row) {
                factorMatrix[row][factor] = signChange * Math.sqrt(eigenValue / eigenVectorNormSquared) * eigenVectorMatrix[row][eigenVectorIndex];
            }
        }
        return factorMatrix;
    }

    public static double[][] factorReductionUsingCommonsMath(double[][] correlationMatrix, int numberOfFactors) {
        double[][] factorMatrix = LinearAlgebra.getFactorMatrix(correlationMatrix, numberOfFactors);
        for (int row = 0; row < correlationMatrix.length; ++row) {
            int factor;
            double sumSquared = 0.0;
            for (factor = 0; factor < numberOfFactors; ++factor) {
                sumSquared += factorMatrix[row][factor] * factorMatrix[row][factor];
            }
            if (sumSquared != 0.0) {
                for (factor = 0; factor < numberOfFactors; ++factor) {
                    factorMatrix[row][factor] = factorMatrix[row][factor] / Math.sqrt(sumSquared);
                }
                continue;
            }
            for (factor = 0; factor < numberOfFactors; ++factor) {
                factorMatrix[row][factor] = 1.0;
            }
        }
        double[][] reducedCorrelationMatrix = new Array2DRowRealMatrix(factorMatrix).multiply(new Array2DRowRealMatrix(factorMatrix).transpose()).getData();
        return LinearAlgebra.getFactorMatrix(reducedCorrelationMatrix, numberOfFactors);
    }

    public static double[][] exp(double[][] matrix) {
        return MatrixFunctions.expm((DoubleMatrix)new DoubleMatrix(matrix)).toArray2();
    }

    public static double[][] pow(double[][] matrix, double exponent) {
        return MatrixFunctions.expm((DoubleMatrix)MatrixFunctions.log((DoubleMatrix)new DoubleMatrix(matrix).mul(exponent))).toArray2();
    }

    public static RealMatrix exp(RealMatrix matrix) {
        return new Array2DRowRealMatrix(LinearAlgebra.exp(matrix.getData()));
    }

    public static double[][] transpose(double[][] matrix) {
        int numberOfRows = matrix.length;
        int numberOfCols = matrix[0].length;
        double[][] transpose = new double[numberOfCols][numberOfRows];
        for (int rowIndex = 0; rowIndex < numberOfRows; ++rowIndex) {
            for (int colIndex = 0; colIndex < numberOfCols; ++colIndex) {
                transpose[colIndex][rowIndex] = matrix[rowIndex][colIndex];
            }
        }
        return transpose;
    }

    public static double[][] pseudoInverse(double[][] matrix) {
        if (isSolverUseApacheCommonsMath) {
            SingularValueDecomposition svd = new SingularValueDecomposition((RealMatrix)new Array2DRowRealMatrix(matrix));
            double[][] matrixInverse = svd.getSolver().getInverse().getData();
            return matrixInverse;
        }
        return Solve.pinv((DoubleMatrix)new DoubleMatrix(matrix)).toArray2();
    }

    public static double[][] diag(double[] vector) {
        double[][] diagonalMatrix = new double[vector.length][vector.length];
        for (int index = 0; index < vector.length; ++index) {
            diagonalMatrix[index][index] = vector[index];
        }
        return diagonalMatrix;
    }

    public static double[][] multMatrices(double[][] left, double[][] right) {
        return new Array2DRowRealMatrix(left).multiply(new Array2DRowRealMatrix(right)).getData();
    }

    public static double[] multMatrixVector(double[][] matrix, double[] vector) {
        return new Array2DRowRealMatrix(matrix).multiply(new Array2DRowRealMatrix(vector)).getColumn(0);
    }

    public static double[][] matrixPow(double[][] matrix, double exponent) {
        return LinearAlgebra.matrixExp(LinearAlgebra.matrixLog((RealMatrix)new Array2DRowRealMatrix(matrix)).scalarMultiply(exponent)).getData();
    }

    public static double[][] matrixExp(double[][] matrix) {
        return LinearAlgebra.matrixExp((RealMatrix)new Array2DRowRealMatrix(matrix)).getData();
    }

    public static double[][] matrixLog(double[][] matrix) {
        return LinearAlgebra.matrixLog((RealMatrix)new Array2DRowRealMatrix(matrix)).getData();
    }

    private static RealMatrix matrixExp(RealMatrix matrix) {
        if (MatrixUtils.isSymmetric((RealMatrix)matrix, (double)1.0E-10)) {
            EigenDecomposition eigenDecomposition = new EigenDecomposition(matrix);
            RealMatrix diag = eigenDecomposition.getD();
            for (int i = 0; i < diag.getRowDimension(); ++i) {
                diag.setEntry(i, i, Math.exp(diag.getEntry(i, i)));
            }
            return eigenDecomposition.getV().multiply(eigenDecomposition.getD()).multiply(eigenDecomposition.getVT());
        }
        RealMatrix exp = MatrixUtils.createRealIdentityMatrix((int)matrix.getRowDimension());
        double factor = 1.0;
        for (int k = 1; k < 15; ++k) {
            exp = exp.add(matrix.power(k).scalarMultiply(1.0 / (factor *= (double)k)));
        }
        return exp;
    }

    private static RealMatrix matrixLog(RealMatrix matrix) {
        if (MatrixUtils.isSymmetric((RealMatrix)matrix, (double)1.0E-10)) {
            EigenDecomposition eigenDecomposition = new EigenDecomposition(matrix);
            RealMatrix diag = eigenDecomposition.getD();
            for (int i = 0; i < diag.getRowDimension(); ++i) {
                diag.setEntry(i, i, Math.log(diag.getEntry(i, i)));
            }
            return eigenDecomposition.getV().multiply(eigenDecomposition.getD()).multiply(eigenDecomposition.getVT());
        }
        RealMatrix m = matrix.subtract(MatrixUtils.createRealIdentityMatrix((int)matrix.getRowDimension()));
        RealMatrix log = m.copy();
        for (int k = 2; k < 15; ++k) {
            log = log.add(m.power(k).scalarMultiply((k % 2 == 0 ? -1.0 : 1.0) / (double)k));
        }
        return log;
    }

    static {
        boolean isSolverUseApacheCommonsMath = Boolean.parseBoolean(System.getProperty("net.finmath.functions.LinearAlgebra.isUseApacheCommonsMath", "true"));
        if (!isSolverUseApacheCommonsMath) {
            try {
                double[] x = Solve.solve((DoubleMatrix)new DoubleMatrix((int)2, (int)2, (double[])new double[]{1.0, 1.0, 0.0, 1.0}), (DoubleMatrix)new DoubleMatrix((int)2, (int)1, (double[])new double[]{1.0, 1.0})).data;
                isJBlasAvailable = x[0] == 1.0 && x[1] == 0.0;
            }
            catch (UnsatisfiedLinkError e) {
                isJBlasAvailable = false;
            }
        }
        if (!isJBlasAvailable) {
            isSolverUseApacheCommonsMath = true;
        }
        LinearAlgebra.isSolverUseApacheCommonsMath = isSolverUseApacheCommonsMath;
    }
}

