/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.functions;

public class LogNormalDistribution {
    static final org.apache.commons.math3.distribution.LogNormalDistribution logNormalDistribution = new org.apache.commons.math3.distribution.LogNormalDistribution();

    private LogNormalDistribution() {
    }

    public static LogNormalDistributionParameters getParametersFromMuAndSigma(double mu, double sigma) {
        double mean = Math.exp(mu) * Math.exp(sigma * sigma / 2.0);
        double standardDeviation = Math.exp(mu) * Math.sqrt((Math.exp(Math.pow(sigma, 2.0)) - 1.0) * Math.exp(Math.pow(sigma, 2.0)));
        return new LogNormalDistributionParameters(mean, standardDeviation, mu, sigma);
    }

    public static LogNormalDistributionParameters getParametersFromMeanAndStdDev(double mean, double standardDeviation) {
        double mu = Math.log(mean / Math.sqrt(Math.pow(standardDeviation / mean, 2.0) + 1.0));
        double sigma = Math.sqrt(2.0 * (Math.log(mean) - mu));
        return new LogNormalDistributionParameters(mean, standardDeviation, mu, sigma);
    }

    public static double density(double x) {
        return logNormalDistribution.density(x);
    }

    public static double cumulativeDistribution(double x) {
        return logNormalDistribution.cumulativeProbability(x);
    }

    public static double inverseCumulativeDistribution(double p) {
        return logNormalDistribution.inverseCumulativeProbability(p);
    }

    public static class LogNormalDistributionParameters {
        private final double mean;
        private final double standardDeviation;
        private final double mu;
        private final double sigma;

        public LogNormalDistributionParameters(double mean, double standardDeviation, double mu, double sigma) {
            this.mean = mean;
            this.standardDeviation = standardDeviation;
            this.mu = mu;
            this.sigma = sigma;
        }

        public double getMean() {
            return this.mean;
        }

        public double getStandardDeviation() {
            return this.standardDeviation;
        }

        public double getMu() {
            return this.mu;
        }

        public double getSigma() {
            return this.sigma;
        }
    }
}

