/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.functions;

import net.finmath.functions.AnalyticFormulas;
import net.finmath.optimizer.LevenbergMarquardt;
import net.finmath.optimizer.SolverException;

public class SABRModel {
    private SABRModel() {
    }

    public static double[] sabrCalibrateParameterForImpliedNormalVols(double underlying, double maturity, double[] givenStrikes, double[] givenVolatilities) throws SolverException {
        double[] parameterLowerBound = new double[]{0.0, 0.0, 0.0, 0.0, Double.NEGATIVE_INFINITY};
        double[] parameterUpperBound = new double[]{Double.POSITIVE_INFINITY, 1.0, 1.0, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY};
        return SABRModel.sabrCalibrateParameterForImpliedNormalVols(underlying, maturity, givenStrikes, givenVolatilities, parameterLowerBound, parameterUpperBound);
    }

    public static double[] sabrCalibrateParameterForImpliedNormalVols(double underlying, double maturity, double[] givenStrikes, double[] givenVolatilities, double[] parameterLowerBound, double[] parameterUpperBound) throws SolverException {
        double alpha = 0.006;
        double beta = 0.05;
        double rho = 0.0;
        double nu = 0.075;
        double displacement = 0.02;
        double[] parameterInitialValues = new double[]{0.006, 0.05, 0.0, 0.075, 0.02};
        double[] parameterSteps = new double[]{5.0E-5, 0.01, 0.005, 0.005, 0.001};
        return SABRModel.sabrCalibrateParameterForImpliedNormalVols(underlying, maturity, givenStrikes, givenVolatilities, parameterInitialValues, parameterSteps, parameterLowerBound, parameterUpperBound);
    }

    public static double[] sabrCalibrateParameterForImpliedNormalVols(final double underlying, final double maturity, final double[] givenStrikes, double[] givenVolatilities, double[] parameterInitialValues, double[] parameterSteps, final double[] parameterLowerBound, final double[] parameterUpperBound) throws SolverException {
        double[] targetValues = givenVolatilities;
        int maxIteration = 1000;
        int numberOfThreads = 8;
        LevenbergMarquardt lm = new LevenbergMarquardt(parameterInitialValues, targetValues, 1000, 8){
            private static final long serialVersionUID = -4481118838855868864L;

            @Override
            public void setValues(double[] parameters, double[] values) {
                for (int parameterIndex = 0; parameterIndex < parameters.length; ++parameterIndex) {
                    parameters[parameterIndex] = Math.min(Math.max(parameters[parameterIndex], parameterLowerBound[parameterIndex]), parameterUpperBound[parameterIndex]);
                }
                for (int strikeIndex = 0; strikeIndex < givenStrikes.length; ++strikeIndex) {
                    double strike = givenStrikes[strikeIndex];
                    values[strikeIndex] = AnalyticFormulas.sabrBerestyckiNormalVolatilityApproximation(parameters[0], parameters[1], parameters[2], parameters[3], parameters[4], underlying, strike, maturity);
                }
            }
        };
        lm.setErrorTolerance(1.0E-16);
        lm.run();
        double[] bestParameters = lm.getBestFitParameters();
        return bestParameters;
    }
}

