/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.integration;

import java.util.Arrays;
import java.util.List;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;

public class PiecewiseContantDoubleUnaryOperator
implements DoubleUnaryOperator,
Function<Double, Double> {
    private final double[] intervalRightPoints;
    private final double[] values;

    public PiecewiseContantDoubleUnaryOperator(double[] intervalRightPoints, double[] values) {
        Validate.notNull((Object)intervalRightPoints, (String)"Argument intervalRightPoints must not be null.", (Object[])new Object[0]);
        Validate.notNull((Object)values, (String)"Argument values must not be null.", (Object[])new Object[0]);
        Validate.isTrue((values.length == intervalRightPoints.length + 1 ? 1 : 0) != 0, (String)"Length of values must equal length of intervalRightPoints + 1.", (Object[])new Object[0]);
        this.intervalRightPoints = intervalRightPoints;
        this.values = values;
    }

    public PiecewiseContantDoubleUnaryOperator(List<Double> intervalRightPoints, List<Double> values) {
        this(ArrayUtils.toPrimitive((Double[])intervalRightPoints.toArray(new Double[intervalRightPoints.size()])), ArrayUtils.toPrimitive((Double[])values.toArray(new Double[values.size()])));
    }

    public double getIntegral(double lowerBound, double upperBound, DoubleUnaryOperator operator) {
        int indexLowerOfUpperBound;
        if (lowerBound == upperBound) {
            return 0.0;
        }
        if (lowerBound > upperBound) {
            return -this.getIntegral(upperBound, lowerBound);
        }
        int indexUpperOfLowerBound = Arrays.binarySearch(this.intervalRightPoints, lowerBound);
        if (indexUpperOfLowerBound < 0) {
            indexUpperOfLowerBound = -indexUpperOfLowerBound - 1;
        }
        if ((indexLowerOfUpperBound = Arrays.binarySearch(this.intervalRightPoints, upperBound)) < 0) {
            indexLowerOfUpperBound = -indexLowerOfUpperBound - 1;
        }
        if (--indexLowerOfUpperBound < indexUpperOfLowerBound) {
            return operator.applyAsDouble(this.values[indexUpperOfLowerBound]) * (upperBound - lowerBound);
        }
        double error = 0.0;
        double integral = operator.applyAsDouble(this.values[indexUpperOfLowerBound]) * (this.intervalRightPoints[indexUpperOfLowerBound] - lowerBound);
        for (int i = indexUpperOfLowerBound; i < indexLowerOfUpperBound; ++i) {
            double value = operator.applyAsDouble(this.values[i + 1]) * (this.intervalRightPoints[i + 1] - this.intervalRightPoints[i]) - error;
            double newIntegral = integral + value;
            error = newIntegral - integral - value;
            integral = newIntegral;
        }
        return integral += operator.applyAsDouble(this.values[indexLowerOfUpperBound + 1]) * (upperBound - this.intervalRightPoints[indexLowerOfUpperBound]) - error;
    }

    public double getIntegral(double lowerBound, double upperBound, Function<Double, Double> operator) {
        return this.getIntegral(lowerBound, upperBound, this.toPrimitive(operator));
    }

    private DoubleUnaryOperator toPrimitive(Function<Double, Double> operator) {
        DoubleUnaryOperator doubleUnaryOperator = x -> (Double)operator.apply(x);
        return doubleUnaryOperator;
    }

    public double getIntegral(double lowerBound, double upperBound) {
        return this.getIntegral(lowerBound, upperBound, DoubleUnaryOperator.identity());
    }

    @Override
    public double applyAsDouble(double operand) {
        int index = Arrays.binarySearch(this.intervalRightPoints, operand);
        if (index < 0) {
            index = -index - 1;
        }
        return this.values[index];
    }

    @Override
    public Double apply(Double value) {
        return this.applyAsDouble(value);
    }
}

