/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.model.bond;

import java.time.LocalDate;
import net.finmath.marketdata.model.AnalyticModel;
import net.finmath.marketdata.model.curves.Curve;
import net.finmath.marketdata.model.curves.DiscountCurve;
import net.finmath.marketdata.model.curves.DiscountCurveInterpolation;
import net.finmath.marketdata.model.curves.ForwardCurve;
import net.finmath.marketdata.products.AbstractAnalyticProduct;
import net.finmath.marketdata.products.AnalyticProduct;
import net.finmath.optimizer.GoldenSectionSearch;
import net.finmath.time.FloatingpointDate;
import net.finmath.time.Period;
import net.finmath.time.Schedule;
import net.finmath.time.daycount.DayCountConvention;

public class Bond
extends AbstractAnalyticProduct
implements AnalyticProduct {
    private final Schedule schedule;
    private final String discountCurveName;
    private final String forwardCurveName;
    private final String survivalProbabilityCurveName;
    private final String basisFactorCurveName;
    private final double fixedCoupon;
    private final double floatingSpread;
    private final double recoveryRate;

    public Bond(Schedule schedule, String discountCurveName, String forwardCurveName, String survivalProbabilityCurveName, String basisFactorCurveName, double fixedCoupon, double floatingSpread, double recoveryRate) {
        this.schedule = schedule;
        this.discountCurveName = discountCurveName;
        this.forwardCurveName = forwardCurveName;
        this.survivalProbabilityCurveName = survivalProbabilityCurveName;
        this.basisFactorCurveName = basisFactorCurveName;
        this.fixedCoupon = fixedCoupon;
        this.floatingSpread = floatingSpread;
        this.recoveryRate = recoveryRate;
    }

    public Bond(Schedule schedule, String discountCurveName, String survivalProbabilityCurveName, String basisFactorCurveName, double fixedCoupon, double recoveryRate) {
        this(schedule, discountCurveName, null, survivalProbabilityCurveName, basisFactorCurveName, fixedCoupon, 0.0, recoveryRate);
    }

    public Bond(Schedule schedule, String discountCurveName, String forwardCurveName, String survivalProbabilityCurveName, String basisFactorCurveName, double fixedCoupon, double floatingSpread) {
        this(schedule, discountCurveName, forwardCurveName, survivalProbabilityCurveName, basisFactorCurveName, fixedCoupon, floatingSpread, 0.0);
    }

    public Bond(Schedule schedule, String discountCurveName, String survivalProbabilityCurveName, String basisFactorCurveName, double fixedCoupon) {
        this(schedule, discountCurveName, null, survivalProbabilityCurveName, basisFactorCurveName, fixedCoupon, 0.0, 0.0);
    }

    public Bond(Schedule schedule, String discountCurveName, double fixedCoupon) {
        this(schedule, discountCurveName, null, null, null, fixedCoupon, 0.0, 0.0);
    }

    @Override
    public double getValue(double evaluationTime, AnalyticModel model) {
        double survivalProbabilityFactor;
        double discountFactor;
        boolean positiveRecoveryRate;
        boolean bl = positiveRecoveryRate = this.recoveryRate > 0.0;
        if (model == null) {
            throw new IllegalArgumentException("model==null");
        }
        ForwardCurve forwardCurve = model.getForwardCurve(this.forwardCurveName);
        if (forwardCurve == null && this.forwardCurveName != null && this.forwardCurveName.length() > 0) {
            throw new IllegalArgumentException("No forward curve with name '" + this.forwardCurveName + "' was found in the model:\n" + model.toString());
        }
        DiscountCurve discountCurve = model.getDiscountCurve(this.discountCurveName);
        if (discountCurve == null) {
            throw new IllegalArgumentException("No discount curve with name '" + this.discountCurveName + "' was found in the model:\n" + model.toString());
        }
        Curve survivalProbabilityCurve = model.getCurve(this.survivalProbabilityCurveName);
        Curve basisFactorCurve = model.getCurve(this.basisFactorCurveName);
        double value = 0.0;
        for (int periodIndex = 0; periodIndex < this.schedule.getNumberOfPeriods(); ++periodIndex) {
            double survivalProbabilityFactor2;
            double discountFactor2;
            double paymentDate = this.schedule.getPayment(periodIndex);
            double periodLength = this.schedule.getPeriodLength(periodIndex);
            double d = discountFactor2 = paymentDate > evaluationTime ? discountCurve.getDiscountFactor(model, paymentDate) : 0.0;
            double d2 = survivalProbabilityCurve != null ? (paymentDate > evaluationTime ? survivalProbabilityCurve.getValue(model, paymentDate) : 0.0) : (survivalProbabilityFactor2 = 1.0);
            double basisFactorFactor = basisFactorCurve != null ? (paymentDate > evaluationTime ? basisFactorCurve.getValue(model, paymentDate) : 0.0) : 1.0;
            double couponPayment = this.fixedCoupon;
            if (forwardCurve != null) {
                couponPayment = this.floatingSpread + forwardCurve.getForward(model, this.schedule.getFixing(periodIndex));
            }
            value += couponPayment * periodLength * discountFactor2 * survivalProbabilityFactor2 * basisFactorFactor;
            if (!positiveRecoveryRate) continue;
            double previousPaymentDate = 0.0;
            if (periodIndex > 0) {
                previousPaymentDate = this.schedule.getPayment(periodIndex - 1);
            }
            double previousSurvivalProbabilityFactor = previousPaymentDate > evaluationTime ? survivalProbabilityCurve.getValue(model, previousPaymentDate) : 1.0;
            value += this.recoveryRate * discountFactor2 * (previousSurvivalProbabilityFactor - survivalProbabilityFactor2) * basisFactorFactor;
        }
        double paymentDate = this.schedule.getPayment(this.schedule.getNumberOfPeriods() - 1);
        double d = discountFactor = paymentDate > evaluationTime ? discountCurve.getDiscountFactor(model, paymentDate) : 0.0;
        double d3 = survivalProbabilityCurve != null ? (paymentDate > evaluationTime ? survivalProbabilityCurve.getValue(model, paymentDate) : 0.0) : (survivalProbabilityFactor = 1.0);
        double basisFactorFactor = basisFactorCurve != null ? (paymentDate > evaluationTime ? basisFactorCurve.getValue(model, paymentDate) : 0.0) : 1.0;
        return (value += discountFactor * survivalProbabilityFactor * basisFactorFactor) / discountCurve.getDiscountFactor(model, evaluationTime);
    }

    public double getCouponPayment(int periodIndex, AnalyticModel model) {
        ForwardCurve forwardCurve = model.getForwardCurve(this.forwardCurveName);
        if (forwardCurve == null && this.forwardCurveName != null && this.forwardCurveName.length() > 0) {
            throw new IllegalArgumentException("No forward curve with name '" + this.forwardCurveName + "' was found in the model:\n" + model.toString());
        }
        double periodLength = this.schedule.getPeriodLength(periodIndex);
        double couponPayment = this.fixedCoupon;
        if (forwardCurve != null) {
            couponPayment = this.floatingSpread + forwardCurve.getForward(model, this.schedule.getFixing(periodIndex));
        }
        return couponPayment * periodLength;
    }

    public double getValueWithGivenSpreadOverCurve(double evaluationTime, Curve referenceCurve, double spread, AnalyticModel model) {
        double value = 0.0;
        for (int periodIndex = 0; periodIndex < this.schedule.getNumberOfPeriods(); ++periodIndex) {
            double paymentDate = this.schedule.getPayment(periodIndex);
            value += paymentDate > evaluationTime ? this.getCouponPayment(periodIndex, model) * Math.exp(-spread * paymentDate) * referenceCurve.getValue(paymentDate) : 0.0;
        }
        double paymentDate = this.schedule.getPayment(this.schedule.getNumberOfPeriods() - 1);
        return paymentDate > evaluationTime ? value + Math.exp(-spread * paymentDate) * referenceCurve.getValue(paymentDate) : 0.0;
    }

    public double getValueWithGivenYield(double evaluationTime, double rate, AnalyticModel model) {
        DiscountCurveInterpolation referenceCurve = DiscountCurveInterpolation.createDiscountCurveFromDiscountFactors("referenceCurve", new double[]{0.0, 1.0}, new double[]{1.0, 1.0});
        return this.getValueWithGivenSpreadOverCurve(evaluationTime, referenceCurve, rate, model);
    }

    public double getSpread(double bondPrice, Curve referenceCurve, AnalyticModel model) {
        GoldenSectionSearch search = new GoldenSectionSearch(-2.0, 2.0);
        while (search.getAccuracy() > 1.0E-11 && !search.isDone()) {
            double x = search.getNextPoint();
            double fx = this.getValueWithGivenSpreadOverCurve(0.0, referenceCurve, x, model);
            double y = (bondPrice - fx) * (bondPrice - fx);
            search.setValue(y);
        }
        return search.getBestPoint();
    }

    public double getYield(double bondPrice, AnalyticModel model) {
        GoldenSectionSearch search = new GoldenSectionSearch(-2.0, 2.0);
        while (search.getAccuracy() > 1.0E-11 && !search.isDone()) {
            double x = search.getNextPoint();
            double fx = this.getValueWithGivenYield(0.0, x, model);
            double y = (bondPrice - fx) * (bondPrice - fx);
            search.setValue(y);
        }
        return search.getBestPoint();
    }

    public double getAccruedInterest(LocalDate date, AnalyticModel model) {
        int periodIndex = this.schedule.getPeriodIndex(date);
        Period period = this.schedule.getPeriod(periodIndex);
        DayCountConvention dcc = this.schedule.getDaycountconvention();
        double accruedInterest = this.getCouponPayment(periodIndex, model) * dcc.getDaycountFraction(period.getPeriodStart(), date) / this.schedule.getPeriodLength(periodIndex);
        return accruedInterest;
    }

    public double getAccruedInterest(double time, AnalyticModel model) {
        LocalDate date = FloatingpointDate.getDateFromFloatingPointDate(this.schedule.getReferenceDate(), time);
        return this.getAccruedInterest(date, model);
    }

    public Schedule getSchedule() {
        return this.schedule;
    }

    public String getDiscountCurveName() {
        return this.discountCurveName;
    }

    public String getForwardCurveName() {
        return this.forwardCurveName;
    }

    public String getSurvivalProbabilityCurveName() {
        return this.survivalProbabilityCurveName;
    }

    public String getBasisFactorCurveName() {
        return this.basisFactorCurveName;
    }

    public double getFixedCoupon() {
        return this.fixedCoupon;
    }

    public double getFloatingSpread() {
        return this.floatingSpread;
    }

    public double getRecoveryRate() {
        return this.recoveryRate;
    }

    public String toString() {
        return "CouponBond [ScheduleFromPeriods=" + this.schedule + ", discountCurveName=" + this.discountCurveName + ", forwardtCurveName=" + this.forwardCurveName + ", survivalProbabilityCurveName=" + this.survivalProbabilityCurveName + ", basisFactorCurveName=" + this.basisFactorCurveName + ", fixedCoupon=" + this.fixedCoupon + ", floatingSpread=" + this.floatingSpread + ", recoveryRate=" + this.recoveryRate + "]";
    }
}

