/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.model.bond;

import java.time.LocalDate;
import net.finmath.marketdata.model.AnalyticModel;
import net.finmath.marketdata.model.curves.AbstractCurve;
import net.finmath.marketdata.model.curves.Curve;
import net.finmath.marketdata.model.curves.CurveBuilder;

public class BondCurve
extends AbstractCurve {
    private static final long serialVersionUID = -7832169179168188306L;
    private String name;
    private LocalDate referenceDate;
    private final Curve referenceCurve;
    private final Curve spreadCurve;
    private final Type type;

    public BondCurve(String name, LocalDate referenceDate, Curve referenceCurve, Curve spreadCurve, Type type) {
        super(name, referenceDate);
        this.referenceCurve = referenceCurve;
        this.spreadCurve = spreadCurve;
        this.type = type;
    }

    @Override
    public double getValue(double time) {
        return this.getValue(null, time);
    }

    @Override
    public double getValue(AnalyticModel model, double time) {
        switch (this.type) {
            case DISCOUNTFACTOR_DISCOUNTFACTOR: {
                return this.referenceCurve.getValue(model, time) * this.spreadCurve.getValue(model, time);
            }
            case ZERORATE_DISCOUNTFACTOR: {
                return Math.exp(-time * this.referenceCurve.getValue(time)) * this.spreadCurve.getValue(model, time);
            }
            case DISCOUNTFACTOR_ZERORATE: {
                return this.referenceCurve.getValue(model, time) * Math.exp(-time * this.spreadCurve.getValue(time));
            }
        }
        return Math.exp(-time * this.referenceCurve.getValue(time)) * Math.exp(-time * this.spreadCurve.getValue(time));
    }

    public double getDiscountFactor(double time) {
        return this.getValue(time);
    }

    public double getDiscountFactor(AnalyticModel model, double time) {
        return this.getValue(model, time);
    }

    public double getZeroRate(double maturity) {
        if (maturity == 0.0) {
            return this.getZeroRate(1.0E-14);
        }
        return -Math.log(this.getDiscountFactor(null, maturity)) / maturity;
    }

    @Override
    public CurveBuilder getCloneBuilder() throws CloneNotSupportedException {
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public LocalDate getReferenceDate() {
        return this.referenceDate;
    }

    public Curve getReferenceCurve() {
        return this.referenceCurve;
    }

    public Curve getSpreadCurve() {
        return this.spreadCurve;
    }

    public String getType() {
        return this.type.toString();
    }

    @Override
    public double[] getParameter() {
        return null;
    }

    @Override
    public void setParameter(double[] parameter) {
    }

    public static enum Type {
        DISCOUNTFACTOR_DISCOUNTFACTOR,
        ZERORATE_DISCOUNTFACTOR,
        DISCOUNTFACTOR_ZERORATE,
        ZERORATE_ZERORATE;

    }
}

