/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.model.curves;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import net.finmath.marketdata.model.curves.Curve;
import net.finmath.marketdata.model.curves.CurveFromProductOfCurves;
import net.finmath.marketdata.model.curves.CurveInterpolation;
import net.finmath.marketdata.model.curves.DiscountCurveInterpolation;
import net.finmath.marketdata.model.curves.IndexCurveFromDiscountCurve;
import net.finmath.marketdata.model.curves.PiecewiseCurve;
import net.finmath.marketdata.model.curves.SeasonalCurve;
import net.finmath.time.FloatingpointDate;
import net.finmath.time.daycount.DayCountConvention_30E_360;
import net.finmath.time.daycount.DayCountConvention_ACT_365;

public class CurveFactory {
    private static DayCountConvention_ACT_365 modelDcc = new DayCountConvention_ACT_365();

    private CurveFactory() {
    }

    public static Curve createIndexCurveWithSeasonality(String name, LocalDate referenceDate, Map<LocalDate, Double> indexFixings, Map<String, Double> seasonalityAdjustments, Integer seasonalAveragingNumberOfYears, Map<LocalDate, Double> annualizedZeroRates, String forwardsFixingLag, String forwardsFixingType) {
        Double baseValue;
        double[] fixingTimes = new double[indexFixings.size()];
        double[] fixingValue = new double[indexFixings.size()];
        int i = 0;
        ArrayList<LocalDate> fixingDates = new ArrayList<LocalDate>(indexFixings.keySet());
        Collections.sort(fixingDates);
        for (LocalDate fixingDate : fixingDates) {
            fixingTimes[i] = modelDcc.getDaycountFraction(referenceDate, fixingDate);
            fixingValue[i] = indexFixings.get(fixingDate);
            ++i;
        }
        CurveInterpolation curveOfFixings = new CurveInterpolation(name, referenceDate, CurveInterpolation.InterpolationMethod.PIECEWISE_CONSTANT_RIGHTPOINT, CurveInterpolation.ExtrapolationMethod.CONSTANT, CurveInterpolation.InterpolationEntity.VALUE, fixingTimes, fixingValue);
        SeasonalCurve seasonCurve = null;
        if (seasonalityAdjustments != null && seasonalityAdjustments.size() > 0 && seasonalAveragingNumberOfYears == null) {
            String[] monthList = new String[]{"january", "february", "march", "april", "may", "june", "july", "august", "september", "october", "november", "december"};
            double[] seasonTimes = new double[12];
            double[] seasonValue = new double[12];
            double seasonValueCummulated = 1.0;
            for (int j = 0; j < 12; ++j) {
                seasonTimes[j] = (double)j / 12.0;
                seasonValue[j] = seasonValueCummulated *= Math.exp(seasonalityAdjustments.get(monthList[j]));
            }
            seasonCurve = new SeasonalCurve(name + "-seasonal", referenceDate, new CurveInterpolation(name + "-seasonal-base", referenceDate, CurveInterpolation.InterpolationMethod.PIECEWISE_CONSTANT_LEFTPOINT, CurveInterpolation.ExtrapolationMethod.CONSTANT, CurveInterpolation.InterpolationEntity.VALUE, seasonTimes, seasonValue));
        } else if (seasonalAveragingNumberOfYears != null && seasonalityAdjustments == null) {
            seasonCurve = new SeasonalCurve(name + "-seasonal", referenceDate, indexFixings, seasonalAveragingNumberOfYears);
        } else if (seasonalAveragingNumberOfYears != null && seasonalityAdjustments != null) {
            throw new IllegalArgumentException("Specified seasonal factors and seasonal averaging at the same time.");
        }
        double[] times = new double[annualizedZeroRates.size()];
        double[] givenDiscountFactors = new double[annualizedZeroRates.size()];
        int index = 0;
        ArrayList<LocalDate> dates = new ArrayList<LocalDate>(annualizedZeroRates.keySet());
        Collections.sort(dates);
        Iterator iterator = dates.iterator();
        while (iterator.hasNext()) {
            LocalDate forwardDate;
            LocalDate cpiDate = forwardDate = (LocalDate)iterator.next();
            if (forwardsFixingType != null && forwardsFixingLag != null) {
                if (forwardsFixingType.equals("endOfMonth")) {
                    cpiDate = cpiDate.withDayOfMonth(1);
                    if (forwardsFixingLag.equals("-2M")) {
                        cpiDate = cpiDate.minusMonths(2L);
                    } else if (forwardsFixingLag.equals("-3M")) {
                        cpiDate = cpiDate.minusMonths(3L);
                    } else if (forwardsFixingLag.equals("-4M")) {
                        cpiDate = cpiDate.minusMonths(4L);
                    } else {
                        throw new IllegalArgumentException("Unsupported fixing type for forward in curve " + name);
                    }
                    cpiDate = cpiDate.withDayOfMonth(cpiDate.lengthOfMonth());
                } else {
                    throw new IllegalArgumentException("Unsupported fixing type for forward in curve " + name);
                }
            }
            times[index] = modelDcc.getDaycountFraction(referenceDate, cpiDate);
            double rate = annualizedZeroRates.get(forwardDate);
            givenDiscountFactors[index] = 1.0 / Math.pow(1.0 + rate, new DayCountConvention_30E_360().getDaycountFraction(referenceDate, forwardDate));
            ++index;
        }
        DiscountCurveInterpolation discountCurve = DiscountCurveInterpolation.createDiscountCurveFromDiscountFactors(name, referenceDate, times, givenDiscountFactors, null, CurveInterpolation.InterpolationMethod.LINEAR, CurveInterpolation.ExtrapolationMethod.CONSTANT, CurveInterpolation.InterpolationEntity.LOG_OF_VALUE);
        LocalDate baseDate = referenceDate;
        if (forwardsFixingType != null && forwardsFixingType.equals("endOfMonth") && forwardsFixingLag != null) {
            baseDate = baseDate.withDayOfMonth(1);
            if (forwardsFixingLag.equals("-2M")) {
                baseDate = baseDate.minusMonths(2L);
            } else if (forwardsFixingLag.equals("-3M")) {
                baseDate = baseDate.minusMonths(3L);
            } else if (forwardsFixingLag.equals("-4M")) {
                baseDate = baseDate.minusMonths(4L);
            } else {
                throw new IllegalArgumentException("Unsupported fixing type for forward in curve " + name);
            }
            baseDate = baseDate.withDayOfMonth(baseDate.lengthOfMonth());
        }
        if ((baseValue = indexFixings.get(baseDate)) == null) {
            throw new IllegalArgumentException("CurveFromInterpolationPoints " + name + " has missing index value for base date " + baseDate);
        }
        double baseTime = FloatingpointDate.getFloatingPointDateFromDate(referenceDate, baseDate);
        double currentProjectedIndexValue = baseValue;
        if (seasonCurve != null) {
            IndexCurveFromDiscountCurve indexCurve = new IndexCurveFromDiscountCurve(name, currentProjectedIndexValue /= seasonCurve.getValue(baseTime), discountCurve);
            CurveFromProductOfCurves indexCurveWithSeason = new CurveFromProductOfCurves(name, referenceDate, indexCurve, seasonCurve);
            PiecewiseCurve indexCurveWithFixing = new PiecewiseCurve(indexCurveWithSeason, curveOfFixings, -1.7976931348623157E308, fixingTimes[fixingTimes.length - 1] + 0.0027397260273972603);
            return indexCurveWithFixing;
        }
        IndexCurveFromDiscountCurve indexCurve = new IndexCurveFromDiscountCurve(name, currentProjectedIndexValue, discountCurve);
        PiecewiseCurve indexCurveWithFixing = new PiecewiseCurve(indexCurve, curveOfFixings, -1.7976931348623157E308, fixingTimes[fixingTimes.length - 1]);
        return indexCurveWithFixing;
    }
}

