/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.model.curves;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import net.finmath.marketdata.model.AnalyticModel;
import net.finmath.marketdata.model.curves.CurveInterpolation;
import net.finmath.marketdata.model.curves.DiscountCurve;
import net.finmath.time.TimeDiscretization;

public class DiscountCurveInterpolation
extends CurveInterpolation
implements Serializable,
DiscountCurve {
    private static final long serialVersionUID = -4126228588123963885L;

    private DiscountCurveInterpolation(String name) {
        super(name, null, CurveInterpolation.InterpolationMethod.LINEAR, CurveInterpolation.ExtrapolationMethod.CONSTANT, CurveInterpolation.InterpolationEntity.LOG_OF_VALUE_PER_TIME);
    }

    private DiscountCurveInterpolation(String name, CurveInterpolation.InterpolationMethod interpolationMethod, CurveInterpolation.ExtrapolationMethod extrapolationMethod, CurveInterpolation.InterpolationEntity interpolationEntity) {
        super(name, null, interpolationMethod, extrapolationMethod, interpolationEntity);
    }

    private DiscountCurveInterpolation(String name, LocalDate referenceDate, CurveInterpolation.InterpolationMethod interpolationMethod, CurveInterpolation.ExtrapolationMethod extrapolationMethod, CurveInterpolation.InterpolationEntity interpolationEntity) {
        super(name, referenceDate, interpolationMethod, extrapolationMethod, interpolationEntity);
    }

    public static DiscountCurveInterpolation createDiscountCurveFromDiscountFactors(String name, LocalDate referenceDate, double[] times, double[] givenDiscountFactors, boolean[] isParameter, CurveInterpolation.InterpolationMethod interpolationMethod, CurveInterpolation.ExtrapolationMethod extrapolationMethod, CurveInterpolation.InterpolationEntity interpolationEntity) {
        if (times.length == 0) {
            throw new IllegalArgumentException("Discount curve interpolation with no points.");
        }
        if (times.length != givenDiscountFactors.length) {
            throw new IllegalArgumentException("Length of times not equal to length of givenDiscountFactors.");
        }
        DiscountCurveInterpolation discountFactors = new DiscountCurveInterpolation(name, referenceDate, interpolationMethod, extrapolationMethod, interpolationEntity);
        for (int timeIndex = 0; timeIndex < times.length; ++timeIndex) {
            discountFactors.addDiscountFactor(times[timeIndex], givenDiscountFactors[timeIndex], isParameter != null && isParameter[timeIndex]);
        }
        return discountFactors;
    }

    public static DiscountCurveInterpolation createDiscountCurveFromDiscountFactors(String name, double[] times, double[] givenDiscountFactors, boolean[] isParameter, CurveInterpolation.InterpolationMethod interpolationMethod, CurveInterpolation.ExtrapolationMethod extrapolationMethod, CurveInterpolation.InterpolationEntity interpolationEntity) {
        return DiscountCurveInterpolation.createDiscountCurveFromDiscountFactors(name, null, times, givenDiscountFactors, isParameter, interpolationMethod, extrapolationMethod, interpolationEntity);
    }

    public static DiscountCurveInterpolation createDiscountCurveFromDiscountFactors(String name, double[] times, double[] givenDiscountFactors, CurveInterpolation.InterpolationMethod interpolationMethod, CurveInterpolation.ExtrapolationMethod extrapolationMethod, CurveInterpolation.InterpolationEntity interpolationEntity) {
        boolean[] isParameter = new boolean[times.length];
        for (int timeIndex = 0; timeIndex < times.length; ++timeIndex) {
            isParameter[timeIndex] = times[timeIndex] > 0.0;
        }
        return DiscountCurveInterpolation.createDiscountCurveFromDiscountFactors(name, times, givenDiscountFactors, isParameter, interpolationMethod, extrapolationMethod, interpolationEntity);
    }

    public static DiscountCurveInterpolation createDiscountCurveFromDiscountFactors(String name, double[] times, double[] givenDiscountFactors) {
        DiscountCurveInterpolation discountFactors = new DiscountCurveInterpolation(name);
        for (int timeIndex = 0; timeIndex < times.length; ++timeIndex) {
            discountFactors.addDiscountFactor(times[timeIndex], givenDiscountFactors[timeIndex], times[timeIndex] > 0.0);
        }
        return discountFactors;
    }

    public static DiscountCurveInterpolation createDiscountCurveFromZeroRates(String name, LocalDate referenceDate, double[] times, double[] givenZeroRates, boolean[] isParameter, CurveInterpolation.InterpolationMethod interpolationMethod, CurveInterpolation.ExtrapolationMethod extrapolationMethod, CurveInterpolation.InterpolationEntity interpolationEntity) {
        double[] givenDiscountFactors = new double[givenZeroRates.length];
        for (int timeIndex = 0; timeIndex < times.length; ++timeIndex) {
            givenDiscountFactors[timeIndex] = Math.exp(-givenZeroRates[timeIndex] * times[timeIndex]);
        }
        return DiscountCurveInterpolation.createDiscountCurveFromDiscountFactors(name, referenceDate, times, givenDiscountFactors, isParameter, interpolationMethod, extrapolationMethod, interpolationEntity);
    }

    public static DiscountCurveInterpolation createDiscountCurveFromZeroRates(String name, Date referenceDate, double[] times, double[] givenZeroRates, boolean[] isParameter, CurveInterpolation.InterpolationMethod interpolationMethod, CurveInterpolation.ExtrapolationMethod extrapolationMethod, CurveInterpolation.InterpolationEntity interpolationEntity) {
        return DiscountCurveInterpolation.createDiscountCurveFromZeroRates(name, referenceDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate(), times, givenZeroRates, isParameter, interpolationMethod, extrapolationMethod, interpolationEntity);
    }

    @Deprecated
    public static DiscountCurveInterpolation createDiscountCurveFromZeroRates(String name, double[] times, double[] givenZeroRates, boolean[] isParameter, CurveInterpolation.InterpolationMethod interpolationMethod, CurveInterpolation.ExtrapolationMethod extrapolationMethod, CurveInterpolation.InterpolationEntity interpolationEntity) {
        return DiscountCurveInterpolation.createDiscountCurveFromZeroRates(name, (LocalDate)null, times, givenZeroRates, isParameter, interpolationMethod, extrapolationMethod, interpolationEntity);
    }

    public static DiscountCurveInterpolation createDiscountCurveFromZeroRates(String name, LocalDate referenceDate, double[] times, double[] givenZeroRates, CurveInterpolation.InterpolationMethod interpolationMethod, CurveInterpolation.ExtrapolationMethod extrapolationMethod, CurveInterpolation.InterpolationEntity interpolationEntity) {
        double[] givenDiscountFactors = new double[givenZeroRates.length];
        boolean[] isParameter = new boolean[givenZeroRates.length];
        for (int timeIndex = 0; timeIndex < times.length; ++timeIndex) {
            givenDiscountFactors[timeIndex] = Math.exp(-givenZeroRates[timeIndex] * times[timeIndex]);
            isParameter[timeIndex] = false;
        }
        return DiscountCurveInterpolation.createDiscountCurveFromDiscountFactors(name, referenceDate, times, givenDiscountFactors, isParameter, interpolationMethod, extrapolationMethod, interpolationEntity);
    }

    public static DiscountCurveInterpolation createDiscountCurveFromZeroRates(String name, double[] times, double[] givenZeroRates) {
        double[] givenDiscountFactors = new double[givenZeroRates.length];
        for (int timeIndex = 0; timeIndex < times.length; ++timeIndex) {
            givenDiscountFactors[timeIndex] = Math.exp(-givenZeroRates[timeIndex] * times[timeIndex]);
        }
        return DiscountCurveInterpolation.createDiscountCurveFromDiscountFactors(name, times, givenDiscountFactors);
    }

    public static DiscountCurveInterpolation createDiscountCurveFromAnnualizedZeroRates(String name, LocalDate referenceDate, double[] times, double[] givenAnnualizedZeroRates, boolean[] isParameter, CurveInterpolation.InterpolationMethod interpolationMethod, CurveInterpolation.ExtrapolationMethod extrapolationMethod, CurveInterpolation.InterpolationEntity interpolationEntity) {
        double[] givenDiscountFactors = new double[givenAnnualizedZeroRates.length];
        for (int timeIndex = 0; timeIndex < times.length; ++timeIndex) {
            givenDiscountFactors[timeIndex] = Math.pow(1.0 + givenAnnualizedZeroRates[timeIndex], -times[timeIndex]);
        }
        return DiscountCurveInterpolation.createDiscountCurveFromDiscountFactors(name, referenceDate, times, givenDiscountFactors, isParameter, interpolationMethod, extrapolationMethod, interpolationEntity);
    }

    public static DiscountCurveInterpolation createDiscountCurveFromAnnualizedZeroRates(String name, LocalDate referenceDate, double[] times, double[] givenAnnualizedZeroRates, CurveInterpolation.InterpolationMethod interpolationMethod, CurveInterpolation.ExtrapolationMethod extrapolationMethod, CurveInterpolation.InterpolationEntity interpolationEntity) {
        double[] givenDiscountFactors = new double[givenAnnualizedZeroRates.length];
        boolean[] isParameter = new boolean[givenAnnualizedZeroRates.length];
        for (int timeIndex = 0; timeIndex < times.length; ++timeIndex) {
            givenDiscountFactors[timeIndex] = Math.pow(1.0 + givenAnnualizedZeroRates[timeIndex], -times[timeIndex]);
            isParameter[timeIndex] = false;
        }
        return DiscountCurveInterpolation.createDiscountCurveFromDiscountFactors(name, referenceDate, times, givenDiscountFactors, isParameter, interpolationMethod, extrapolationMethod, interpolationEntity);
    }

    public static DiscountCurve createDiscountFactorsFromForwardRates(String name, TimeDiscretization tenor, double[] forwardRates) {
        DiscountCurveInterpolation discountFactors = new DiscountCurveInterpolation(name);
        double df = 1.0;
        for (int timeIndex = 0; timeIndex < tenor.getNumberOfTimeSteps(); ++timeIndex) {
            discountFactors.addDiscountFactor(tenor.getTime(timeIndex + 1), df /= 1.0 + forwardRates[timeIndex] * tenor.getTimeStep(timeIndex), tenor.getTime(timeIndex + 1) > 0.0);
        }
        return discountFactors;
    }

    @Override
    public double getDiscountFactor(double maturity) {
        return this.getDiscountFactor(null, maturity);
    }

    @Override
    public double getDiscountFactor(AnalyticModel model, double maturity) {
        return this.getValue(model, maturity);
    }

    public double getZeroRate(double maturity) {
        if (maturity == 0.0) {
            return this.getZeroRate(1.0E-14);
        }
        return -Math.log(this.getDiscountFactor(null, maturity)) / maturity;
    }

    public double[] getZeroRates(double[] maturities) {
        double[] values = new double[maturities.length];
        for (int i = 0; i < maturities.length; ++i) {
            values[i] = this.getZeroRate(maturities[i]);
        }
        return values;
    }

    protected void addDiscountFactor(double maturity, double discountFactor, boolean isParameter) {
        this.addPoint(maturity, discountFactor, isParameter);
    }

    @Override
    public String toString() {
        return "DiscountCurveInterpolation [" + super.toString() + "]";
    }
}

