/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.model.curves;

import net.finmath.marketdata.model.AnalyticModel;
import net.finmath.marketdata.model.curves.Curve;
import net.finmath.marketdata.model.curves.ForwardCurve;
import net.finmath.marketdata.model.curves.PiecewiseCurve;

public class ForwardCurveWithFixings
extends PiecewiseCurve
implements ForwardCurve {
    private static final long serialVersionUID = -6192098475095644443L;

    public ForwardCurveWithFixings(ForwardCurve curveInterface, ForwardCurve fixedPartCurve, double fixedPartStartTime, double fixedPartEndTime) {
        super(curveInterface, fixedPartCurve, fixedPartStartTime, fixedPartEndTime);
    }

    @Override
    public double getForward(AnalyticModel model, double fixingTime) {
        if (fixingTime > this.getFixedPartStartTime() && fixingTime < this.getFixedPartEndTime()) {
            return ((ForwardCurve)this.getFixedPartCurve()).getForward(model, fixingTime);
        }
        return ((ForwardCurve)this.getBaseCurve()).getForward(model, fixingTime);
    }

    @Override
    public double getForward(AnalyticModel model, double fixingTime, double paymentOffset) {
        if (fixingTime > this.getFixedPartStartTime() && fixingTime < this.getFixedPartEndTime()) {
            return ((ForwardCurve)this.getFixedPartCurve()).getForward(model, fixingTime, paymentOffset);
        }
        return ((ForwardCurve)this.getBaseCurve()).getForward(model, fixingTime, paymentOffset);
    }

    public double[] getForwards(AnalyticModel model, double[] fixingTimes) {
        double[] values = new double[fixingTimes.length];
        for (int i = 0; i < fixingTimes.length; ++i) {
            values[i] = this.getForward(model, fixingTimes[i]);
        }
        return values;
    }

    @Override
    public String getDiscountCurveName() {
        return ((ForwardCurve)this.getBaseCurve()).getDiscountCurveName();
    }

    @Override
    public double getPaymentOffset(double fixingTime) {
        return ((ForwardCurve)this.getBaseCurve()).getPaymentOffset(fixingTime);
    }

    @Override
    public Curve getCloneForParameter(double[] value) throws CloneNotSupportedException {
        return new ForwardCurveWithFixings((ForwardCurve)this.getBaseCurve().getCloneForParameter(value), (ForwardCurve)this.getFixedPartCurve(), this.getFixedPartStartTime(), this.getFixedPartEndTime());
    }

    @Override
    public ForwardCurveWithFixings clone() throws CloneNotSupportedException {
        return new ForwardCurveWithFixings((ForwardCurve)this.getBaseCurve().clone(), (ForwardCurve)this.getFixedPartCurve(), this.getFixedPartStartTime(), this.getFixedPartEndTime());
    }
}

