/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.model.curves;

import java.time.LocalDate;
import net.finmath.marketdata.model.AnalyticModel;
import net.finmath.marketdata.model.curves.AbstractCurve;
import net.finmath.marketdata.model.curves.Curve;
import net.finmath.marketdata.model.curves.CurveBuilder;
import net.finmath.marketdata.model.curves.CurveInterpolation;

public class PiecewiseCurve
extends AbstractCurve
implements Curve {
    private static final long serialVersionUID = 8846923173857477343L;
    private Curve baseCurve;
    private final Curve fixedPartCurve;
    private final double fixedPartStartTime;
    private final double fixedPartEndTime;

    public PiecewiseCurve(Curve curve, Curve fixedPartCurve, double fixedPartStartTime, double fixedPartEndTime) {
        super(curve.getName(), curve.getReferenceDate());
        this.baseCurve = curve;
        this.fixedPartCurve = fixedPartCurve;
        this.fixedPartStartTime = fixedPartStartTime;
        this.fixedPartEndTime = fixedPartEndTime;
    }

    @Override
    public double[] getParameter() {
        return this.baseCurve.getParameter();
    }

    @Override
    public void setParameter(double[] parameter) {
        this.baseCurve.setParameter(parameter);
    }

    @Override
    public String getName() {
        return this.baseCurve.getName();
    }

    @Override
    public LocalDate getReferenceDate() {
        return this.baseCurve.getReferenceDate();
    }

    public Curve getBaseCurve() {
        return this.baseCurve;
    }

    public Curve getFixedPartCurve() {
        return this.fixedPartCurve;
    }

    public double getFixedPartStartTime() {
        return this.fixedPartStartTime;
    }

    public double getFixedPartEndTime() {
        return this.fixedPartEndTime;
    }

    @Override
    public double getValue(double time) {
        return this.getValue(null, time);
    }

    @Override
    public double getValue(AnalyticModel model, double time) {
        if (time > this.fixedPartStartTime && time < this.fixedPartEndTime) {
            return this.fixedPartCurve.getValue(model, time);
        }
        return this.baseCurve.getValue(model, time);
    }

    @Override
    public Curve getCloneForParameter(double[] value) throws CloneNotSupportedException {
        PiecewiseCurve newCurve = this.clone();
        newCurve.baseCurve = this.baseCurve.getCloneForParameter(value);
        return newCurve;
    }

    @Override
    public PiecewiseCurve clone() throws CloneNotSupportedException {
        return new PiecewiseCurve((Curve)this.baseCurve.clone(), this.fixedPartCurve, this.fixedPartStartTime, this.fixedPartEndTime);
    }

    @Override
    public Builder getCloneBuilder() throws CloneNotSupportedException {
        return new Builder(this);
    }

    @Override
    public String toString() {
        return "ForwardCurveWithFixings [getBaseCurve()=" + this.getBaseCurve() + ", getFixedPartCurve()=" + this.getFixedPartCurve() + ", getFixedPartStartTime()=" + this.getFixedPartStartTime() + ", getFixedPartEndTime()=" + this.getFixedPartEndTime() + ", toString()=" + super.toString() + "]";
    }

    public static class Builder
    extends CurveInterpolation.Builder
    implements CurveBuilder {
        private PiecewiseCurve curve = null;

        public Builder(PiecewiseCurve piecewiseCurve) throws CloneNotSupportedException {
            super((CurveInterpolation)piecewiseCurve.baseCurve);
            this.curve = piecewiseCurve;
        }

        @Override
        public Curve build() throws CloneNotSupportedException {
            PiecewiseCurve buildCurve = this.curve.clone();
            buildCurve.baseCurve = super.build();
            this.curve = null;
            return buildCurve;
        }
    }
}

