/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.model.curves.locallinearregression;

import java.util.Arrays;

public class Partition {
    private final double[] points;
    private final double weight;
    private final double[] referencePoints;

    public Partition(double[] points, double weight) {
        this.points = points;
        this.weight = weight;
        Arrays.sort(this.points);
        this.referencePoints = new double[points.length - 1];
        for (int i = 0; i < this.referencePoints.length; ++i) {
            this.referencePoints[i] = (1.0 - weight) * points[i] + weight * points[i + 1];
        }
    }

    public Partition(double[] points) {
        this(points, 0.5);
    }

    public int getIntervalNumber(double x) {
        if (x < this.points[0]) {
            return 0;
        }
        if (x >= this.points[this.points.length - 1]) {
            return this.points.length;
        }
        for (int i = 0; i < this.points.length - 2; ++i) {
            if (!(x < this.points[i + 1])) continue;
            return i + 1;
        }
        return this.points.length - 1;
    }

    public double d(double x) {
        int intervalNumber = this.getIntervalNumber(x);
        if (intervalNumber == 0 || intervalNumber == this.points.length) {
            return x;
        }
        return this.getIntervalReferencePoint(intervalNumber - 1);
    }

    public double[] getReferencePoints() {
        return this.referencePoints;
    }

    public double getIntervalReferencePoint(int intervalIndex) {
        return this.referencePoints[intervalIndex];
    }

    public double[] getPoints() {
        return this.points;
    }

    public double getPoint(int pointIndex) {
        return this.points[pointIndex];
    }

    public int getLength() {
        return this.points.length;
    }

    public int getNumberOfIntervals() {
        return this.points.length - 1;
    }

    public double getIntervalLength(int intervalIndex) {
        return this.points[intervalIndex + 1] - this.points[intervalIndex];
    }

    public double getWeight() {
        return this.weight;
    }
}

