/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.model.volatilities;

import java.time.LocalDate;
import net.finmath.functions.AnalyticFormulas;
import net.finmath.marketdata.model.AnalyticModel;
import net.finmath.marketdata.model.curves.DiscountCurve;
import net.finmath.marketdata.model.curves.ForwardCurve;
import net.finmath.marketdata.model.volatilities.AbstractVolatilitySurfaceParametric;
import net.finmath.marketdata.model.volatilities.VolatilitySurface;

public class CapletVolatilitiesParametricDisplacedFourParameterAnalytic
extends AbstractVolatilitySurfaceParametric {
    private final double timeScaling;
    private final double a;
    private final double b;
    private final double c;
    private final double d;
    private final double displacement;
    private final boolean isDisplacementCalibrateable;

    public CapletVolatilitiesParametricDisplacedFourParameterAnalytic(String name, LocalDate referenceDate, ForwardCurve forwardCurve, DiscountCurve discountCurve, double displacement, boolean isDisplacementCalibrateable, double a, double b, double c, double d, double timeScaling) {
        super(name, referenceDate, forwardCurve, discountCurve, VolatilitySurface.QuotingConvention.VOLATILITYLOGNORMAL, null);
        this.timeScaling = timeScaling;
        this.displacement = displacement;
        this.isDisplacementCalibrateable = isDisplacementCalibrateable;
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
    }

    @Override
    public double getValue(double maturity, double strike, VolatilitySurface.QuotingConvention quotingConvention) {
        return this.getValue(null, maturity, strike, quotingConvention);
    }

    @Override
    public double getValue(AnalyticModel model, double maturity, double strike, VolatilitySurface.QuotingConvention quotingConvention) {
        double daycountFraction;
        if (maturity == 0.0) {
            return 0.0;
        }
        double T = maturity * this.timeScaling;
        double integratedVariance = this.c != 0.0 ? this.a * this.a * T * ((1.0 - Math.exp(-2.0 * this.c * T)) / (2.0 * this.c * T)) + this.a * this.b * T * T * (((1.0 - Math.exp(-2.0 * this.c * T)) / (2.0 * this.c * T) - Math.exp(-2.0 * this.c * T)) / (this.c * T)) + 2.0 * this.a * this.d * T * ((1.0 - Math.exp(-this.c * T)) / (this.c * T)) + this.b * this.b * T * T * T * ((((1.0 - Math.exp(-2.0 * this.c * T)) / (2.0 * this.c * T) - Math.exp(-2.0 * this.c * T)) / (T * this.c) - Math.exp(-2.0 * this.c * T)) / (2.0 * this.c * T)) + 2.0 * this.b * this.d * T * T * ((1.0 - Math.exp(-this.c * T) - T * this.c * Math.exp(-this.c * T)) / (this.c * this.c * T * T)) + this.d * this.d * T : this.a * this.a * T + this.a * this.b * T * T + 2.0 * this.a * this.d * T + this.b * this.b * T * T * T / 3.0 + this.b * this.d * T * T + this.d * this.d * T;
        double value = Math.sqrt(integratedVariance / maturity);
        if (this.getDiscountCurve() == null) {
            throw new IllegalArgumentException("Missing discount curve. Conversion of QuotingConvention requires forward curve and discount curve to be set.");
        }
        if (this.getForwardCurve() == null) {
            throw new IllegalArgumentException("Missing forward curve. Conversion of QuotingConvention requires forward curve and discount curve to be set.");
        }
        double periodStart = maturity;
        double periodEnd = periodStart + this.getForwardCurve().getPaymentOffset(periodStart);
        double forward = this.getForwardCurve().getForward(model, periodStart);
        if (this.getDaycountConvention() != null) {
            LocalDate startDate = this.getReferenceDate().plusDays((int)Math.round(periodStart * 365.0));
            LocalDate endDate = this.getReferenceDate().plusDays((int)Math.round(periodEnd * 365.0));
            daycountFraction = this.getDaycountConvention().getDaycountFraction(startDate, endDate);
        } else {
            daycountFraction = this.getForwardCurve().getPaymentOffset(periodStart);
        }
        double payoffUnit = this.getDiscountCurve().getDiscountFactor(maturity + this.getForwardCurve().getPaymentOffset(maturity)) * daycountFraction;
        double valuePrice = AnalyticFormulas.blackScholesGeneralizedOptionValue(forward + this.displacement, value, maturity, strike + this.displacement, payoffUnit);
        return this.convertFromTo(model, maturity, strike, valuePrice, VolatilitySurface.QuotingConvention.PRICE, quotingConvention);
    }

    @Override
    public double[] getParameter() {
        if (this.isDisplacementCalibrateable) {
            double[] parameter = new double[]{this.displacement, this.a, this.b, this.c, this.d};
            return parameter;
        }
        double[] parameter = new double[]{this.a, this.b, this.c, this.d};
        return parameter;
    }

    @Override
    public void setParameter(double[] parameter) {
        throw new UnsupportedOperationException("This class is immutable.");
    }

    @Override
    public AbstractVolatilitySurfaceParametric getCloneForParameter(double[] value) throws CloneNotSupportedException {
        if (this.isDisplacementCalibrateable) {
            return new CapletVolatilitiesParametricDisplacedFourParameterAnalytic(this.getName(), this.getReferenceDate(), this.getForwardCurve(), this.getDiscountCurve(), value[0], this.isDisplacementCalibrateable, value[1], value[2], value[3], value[4], this.timeScaling);
        }
        return new CapletVolatilitiesParametricDisplacedFourParameterAnalytic(this.getName(), this.getReferenceDate(), this.getForwardCurve(), this.getDiscountCurve(), this.displacement, this.isDisplacementCalibrateable, value[0], value[1], value[2], value[3], this.timeScaling);
    }
}

