/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.model.volatilities;

import java.time.LocalDate;
import net.finmath.marketdata.model.volatilities.VolatilitySurface;

public class OptionData {
    private final String underlying;
    private final LocalDate referenceDate;
    private final double strike;
    private final double maturity;
    private final double value;
    private final VolatilitySurface.QuotingConvention convention;

    public OptionData(String underlying, LocalDate referenceDate, double strike, double maturity, double value, VolatilitySurface.QuotingConvention convention) {
        this.underlying = underlying;
        this.referenceDate = referenceDate;
        this.strike = strike;
        this.maturity = maturity;
        this.value = value;
        this.convention = convention;
    }

    public String getUnderlying() {
        return this.underlying;
    }

    public LocalDate getReferenceDate() {
        return this.referenceDate;
    }

    public double getStrike() {
        return this.strike;
    }

    public double getMaturity() {
        return this.maturity;
    }

    public double getValue() {
        return this.value;
    }

    public VolatilitySurface.QuotingConvention getConvention() {
        return this.convention;
    }

    public String toString() {
        return "EquityOptionQuote [underlying=" + this.underlying + ", referenceDate=" + this.referenceDate + ", strike=" + this.strike + ", maturity=" + this.maturity + ", value=" + this.value + ", convention=" + this.convention + "]";
    }
}

