/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.model.volatilities;

import net.finmath.marketdata.model.curves.DiscountCurve;
import net.finmath.marketdata.model.curves.ForwardCurve;
import net.finmath.marketdata.model.volatilities.SwaptionMarketData;
import net.finmath.time.TimeDiscretization;
import net.finmath.time.TimeDiscretizationFromArray;

public class SwaptionATMMarketDataFromArray
implements SwaptionMarketData {
    private final ForwardCurve forwardCurve;
    private final DiscountCurve discountCurve;
    private final TimeDiscretization optionMaturities;
    private final TimeDiscretization tenor;
    private final double swapPeriodLength;
    private final double[][] impliedVolatilities;

    public SwaptionATMMarketDataFromArray(double[] optionMaturities, double[] tenor, double swapPeriodLength, double[][] impliedVolatilities) {
        this.forwardCurve = null;
        this.discountCurve = null;
        this.optionMaturities = new TimeDiscretizationFromArray(optionMaturities);
        this.tenor = new TimeDiscretizationFromArray(tenor);
        this.swapPeriodLength = swapPeriodLength;
        this.impliedVolatilities = impliedVolatilities;
    }

    public SwaptionATMMarketDataFromArray(ForwardCurve forwardCurve, DiscountCurve discountCurve, double[] optionMaturities, double[] tenor, double swapPeriodLength, double[][] impliedVolatilities) {
        this.forwardCurve = forwardCurve;
        this.discountCurve = discountCurve;
        this.optionMaturities = new TimeDiscretizationFromArray(optionMaturities);
        this.tenor = new TimeDiscretizationFromArray(tenor);
        this.swapPeriodLength = swapPeriodLength;
        this.impliedVolatilities = impliedVolatilities;
    }

    public SwaptionATMMarketDataFromArray(ForwardCurve forwardCurve, DiscountCurve discountCurve, TimeDiscretization optionMatruities, TimeDiscretization tenor, double swapPeriodLength, double[][] impliedVolatilities) {
        this.forwardCurve = forwardCurve;
        this.discountCurve = discountCurve;
        this.optionMaturities = optionMatruities;
        this.tenor = tenor;
        this.swapPeriodLength = swapPeriodLength;
        this.impliedVolatilities = impliedVolatilities;
    }

    @Override
    public TimeDiscretization getOptionMaturities() {
        return this.optionMaturities;
    }

    @Override
    public TimeDiscretization getTenor() {
        return this.tenor;
    }

    @Override
    public double getSwapPeriodLength() {
        return this.swapPeriodLength;
    }

    @Override
    public double getValue(double optionMatruity, double tenorLength, double periodLength, double strike) {
        throw new RuntimeException("Method not implemented.");
    }

    public double getVolatility(double optionMatruity, double tenorLength) {
        int indexOptionMaturity = this.optionMaturities.getTimeIndex(optionMatruity);
        int indexTenorIndex = this.tenor.getTimeIndex(tenorLength);
        if (indexOptionMaturity < 0) {
            throw new IllegalArgumentException("Option maturity not part of data.");
        }
        if (indexTenorIndex < 0) {
            throw new IllegalArgumentException("TenorFromArray maturity not part of data.");
        }
        return this.impliedVolatilities[indexOptionMaturity][indexTenorIndex];
    }

    @Override
    public double getVolatility(double optionMatruity, double tenorLength, double periodLength, double strike) {
        int indexOptionMaturity = this.optionMaturities.getTimeIndex(optionMatruity);
        int indexTenorIndex = this.tenor.getTimeIndex(tenorLength);
        if (indexOptionMaturity < 0) {
            throw new IllegalArgumentException("Option maturity not part of data.");
        }
        if (indexTenorIndex < 0) {
            throw new IllegalArgumentException("TenorFromArray maturity not part of data.");
        }
        return this.impliedVolatilities[indexOptionMaturity][indexTenorIndex];
    }
}

