/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.model.volatilities;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.DoubleUnaryOperator;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import net.finmath.functions.AnalyticFormulas;
import net.finmath.marketdata.model.AnalyticModel;
import net.finmath.marketdata.products.Swap;
import net.finmath.marketdata.products.SwapAnnuity;
import net.finmath.time.Schedule;
import net.finmath.time.SchedulePrototype;
import org.apache.commons.math3.util.Pair;

public class SwaptionDataLattice
implements Serializable {
    private static final long serialVersionUID = 5041960065072626043L;
    private final LocalDate referenceDate;
    private final QuotingConvention quotingConvention;
    private final double displacement;
    private final String forwardCurveName;
    private final String discountCurveName;
    private final SchedulePrototype floatMetaSchedule;
    private final SchedulePrototype fixMetaSchedule;
    private final Map<DataKey, Double> entryMap = new HashMap<DataKey, Double>();
    private transient Map<Integer, int[][]> keyMap;
    private transient Map<Pair<Integer, Integer>, int[]> reverseKeyMap;

    public SwaptionDataLattice(LocalDate referenceDate, QuotingConvention quotingConvention, String forwardCurveName, String discountCurveName, SchedulePrototype floatMetaSchedule, SchedulePrototype fixMetaSchedule, double[] maturities, double[] tenors, double[] moneynesss, double[] values) {
        this(referenceDate, quotingConvention, 0.0, forwardCurveName, discountCurveName, floatMetaSchedule, fixMetaSchedule);
        for (int i = 0; i < maturities.length; ++i) {
            this.entryMap.put(new DataKey(maturities[i], tenors[i], moneynesss[i]), values[i]);
        }
    }

    public SwaptionDataLattice(LocalDate referenceDate, QuotingConvention quotingConvention, String forwardCurveName, String discountCurveName, SchedulePrototype floatMetaSchedule, SchedulePrototype fixMetaSchedule, int[] maturitiesInMonths, int[] tenorsInMonths, int[] moneynessBP, double[] values) {
        this(referenceDate, quotingConvention, 0.0, forwardCurveName, discountCurveName, floatMetaSchedule, fixMetaSchedule);
        for (int i = 0; i < maturitiesInMonths.length; ++i) {
            this.entryMap.put(new DataKey(maturitiesInMonths[i], tenorsInMonths[i], moneynessBP[i]), values[i]);
        }
    }

    public SwaptionDataLattice(LocalDate referenceDate, QuotingConvention quotingConvention, String forwardCurveName, String discountCurveName, SchedulePrototype floatMetaSchedule, SchedulePrototype fixMetaSchedule, String[] tenorCodes, int[] moneynessBP, double[] values) {
        this(referenceDate, quotingConvention, 0.0, forwardCurveName, discountCurveName, floatMetaSchedule, fixMetaSchedule);
        for (int i = 0; i < tenorCodes.length; ++i) {
            this.entryMap.put(new DataKey(tenorCodes[i], moneynessBP[i]), values[i]);
        }
    }

    public SwaptionDataLattice(LocalDate referenceDate, QuotingConvention quotingConvention, double displacement, String forwardCurveName, String discountCurveName, SchedulePrototype floatMetaSchedule, SchedulePrototype fixMetaSchedule, int[] maturitiesInMonths, int[] tenorsInMonths, int[] moneynessBP, double[] values) {
        this(referenceDate, quotingConvention, displacement, forwardCurveName, discountCurveName, floatMetaSchedule, fixMetaSchedule);
        for (int i = 0; i < maturitiesInMonths.length; ++i) {
            this.entryMap.put(new DataKey(maturitiesInMonths[i], tenorsInMonths[i], moneynessBP[i]), values[i]);
        }
    }

    public SwaptionDataLattice(LocalDate referenceDate, QuotingConvention quotingConvention, double displacement, String forwardCurveName, String discountCurveName, SchedulePrototype floatMetaSchedule, SchedulePrototype fixMetaSchedule, double[] maturities, double[] tenors, double[] moneynesss, double[] values) {
        this(referenceDate, quotingConvention, displacement, forwardCurveName, discountCurveName, floatMetaSchedule, fixMetaSchedule);
        for (int i = 0; i < maturities.length; ++i) {
            this.entryMap.put(new DataKey(maturities[i], tenors[i], moneynesss[i]), values[i]);
        }
    }

    public SwaptionDataLattice(LocalDate referenceDate, QuotingConvention quotingConvention, double displacement, String forwardCurveName, String discountCurveName, SchedulePrototype floatMetaSchedule, SchedulePrototype fixMetaSchedule, String[] tenorCodes, int[] moneynessBP, double[] values) {
        this(referenceDate, quotingConvention, displacement, forwardCurveName, discountCurveName, floatMetaSchedule, fixMetaSchedule);
        for (int i = 0; i < tenorCodes.length; ++i) {
            this.entryMap.put(new DataKey(tenorCodes[i], moneynessBP[i]), values[i]);
        }
    }

    private SwaptionDataLattice(LocalDate referenceDate, QuotingConvention quotingConvention, double displacement, String forwardCurveName, String discountCurveName, SchedulePrototype floatMetaSchedule, SchedulePrototype fixMetaSchedule) {
        this.referenceDate = referenceDate;
        this.quotingConvention = quotingConvention;
        this.displacement = displacement;
        this.forwardCurveName = forwardCurveName;
        this.discountCurveName = discountCurveName;
        this.floatMetaSchedule = floatMetaSchedule;
        this.fixMetaSchedule = fixMetaSchedule;
    }

    public SwaptionDataLattice convertLattice(QuotingConvention targetConvention, AnalyticModel model) {
        return this.convertLattice(targetConvention, 0.0, model);
    }

    public SwaptionDataLattice convertLattice(QuotingConvention targetConvention, double displacement, AnalyticModel model) {
        if (displacement != 0.0 && targetConvention != QuotingConvention.PAYERVOLATILITYLOGNORMAL) {
            throw new IllegalArgumentException("SwaptionDataLattice only supports displacement, when using QuotingCOnvention.PAYERVOLATILITYLOGNORMAL.");
        }
        int reverse = targetConvention == QuotingConvention.RECEIVERPRICE ^ this.quotingConvention == QuotingConvention.RECEIVERPRICE ? -1 : 1;
        ArrayList<Integer> maturities = new ArrayList<Integer>();
        ArrayList<Integer> tenors = new ArrayList<Integer>();
        ArrayList<Integer> moneynesss = new ArrayList<Integer>();
        ArrayList<Double> values = new ArrayList<Double>();
        for (DataKey key : this.entryMap.keySet()) {
            maturities.add(key.maturity);
            tenors.add(key.tenor);
            moneynesss.add(key.moneyness * reverse);
            values.add(this.getValue(key.maturity, key.tenor, key.moneyness, targetConvention, displacement, model));
        }
        return new SwaptionDataLattice(this.referenceDate, targetConvention, displacement, this.forwardCurveName, this.discountCurveName, this.floatMetaSchedule, this.fixMetaSchedule, maturities.stream().mapToInt(Integer::intValue).toArray(), tenors.stream().mapToInt(Integer::intValue).toArray(), moneynesss.stream().mapToInt(Integer::intValue).toArray(), values.stream().mapToDouble(Double::doubleValue).toArray());
    }

    public SwaptionDataLattice append(SwaptionDataLattice other, AnalyticModel model) {
        SwaptionDataLattice combined = new SwaptionDataLattice(this.referenceDate, this.quotingConvention, this.displacement, this.forwardCurveName, this.discountCurveName, this.floatMetaSchedule, this.fixMetaSchedule);
        combined.entryMap.putAll(this.entryMap);
        if (this.quotingConvention == other.quotingConvention && this.displacement == other.displacement) {
            combined.entryMap.putAll(other.entryMap);
        } else {
            SwaptionDataLattice converted = other.convertLattice(this.quotingConvention, this.displacement, model);
            combined.entryMap.putAll(converted.entryMap);
        }
        return combined;
    }

    public Map<Integer, int[][]> getGridNodesPerMoneyness() {
        if (this.keyMap != null) {
            return Collections.unmodifiableMap(this.keyMap);
        }
        HashMap newMap = new HashMap();
        for (DataKey key : this.entryMap.keySet()) {
            if (!newMap.containsKey(key.moneyness)) {
                newMap.put(key.moneyness, new ArrayList());
                ((List)newMap.get(key.moneyness)).add(new HashSet());
                ((List)newMap.get(key.moneyness)).add(new HashSet());
            }
            ((Set)((List)newMap.get(key.moneyness)).get(0)).add(key.maturity);
            ((Set)((List)newMap.get(key.moneyness)).get(1)).add(key.tenor);
        }
        TreeMap<Integer, int[][]> keyMap = new TreeMap<Integer, int[][]>();
        Iterator iterator = newMap.keySet().iterator();
        while (iterator.hasNext()) {
            int moneyness = (Integer)iterator.next();
            int[][] values = new int[][]{((Set)((List)newMap.get(moneyness)).get(0)).stream().sorted().mapToInt(Integer::intValue).toArray(), ((Set)((List)newMap.get(moneyness)).get(1)).stream().sorted().mapToInt(Integer::intValue).toArray()};
            keyMap.put(moneyness, values);
        }
        this.keyMap = keyMap;
        return Collections.unmodifiableMap(keyMap);
    }

    public Map<Pair<Integer, Integer>, int[]> getMoneynessPerGridNode() {
        if (this.reverseKeyMap != null) {
            return Collections.unmodifiableMap(this.reverseKeyMap);
        }
        HashMap newMap = new HashMap();
        for (DataKey key : this.entryMap.keySet()) {
            Pair maturityTenorPair = new Pair((Object)key.maturity, (Object)key.tenor);
            if (!newMap.containsKey(maturityTenorPair)) {
                newMap.put(maturityTenorPair, new HashSet());
            }
            ((Set)newMap.get(maturityTenorPair)).add(key.moneyness);
        }
        TreeMap<Pair<Integer, Integer>, int[]> reverseKeyMap = new TreeMap<Pair<Integer, Integer>, int[]>();
        for (Pair maturityTenorPair : newMap.keySet()) {
            int[] values = ((Set)newMap.get(maturityTenorPair)).stream().sorted().mapToInt(Integer::intValue).toArray();
            reverseKeyMap.put((Pair<Integer, Integer>)maturityTenorPair, values);
        }
        this.reverseKeyMap = reverseKeyMap;
        return Collections.unmodifiableMap(reverseKeyMap);
    }

    public int[] getMoneyness() {
        return this.getGridNodesPerMoneyness().keySet().stream().mapToInt(Integer::intValue).toArray();
    }

    public double[] getMoneynessAsOffsets() {
        DoubleStream moneyness = this.getGridNodesPerMoneyness().keySet().stream().mapToDouble(Integer::doubleValue);
        moneyness = this.quotingConvention == QuotingConvention.PAYERVOLATILITYLOGNORMAL ? moneyness.map(new DoubleUnaryOperator(){

            @Override
            public double applyAsDouble(double x) {
                return x * 0.01;
            }
        }) : (this.quotingConvention == QuotingConvention.RECEIVERPRICE ? moneyness.map(new DoubleUnaryOperator(){

            @Override
            public double applyAsDouble(double x) {
                return -x * 1.0E-4;
            }
        }) : moneyness.map(new DoubleUnaryOperator(){

            @Override
            public double applyAsDouble(double x) {
                return x * 1.0E-4;
            }
        }));
        return moneyness.toArray();
    }

    public int[] getMaturities() {
        HashSet<Integer> setMaturities = new HashSet<Integer>();
        for (int moneyness : this.getGridNodesPerMoneyness().keySet()) {
            setMaturities.addAll(Arrays.asList((Integer[])IntStream.of(this.keyMap.get(moneyness)[0]).boxed().toArray(Integer[]::new)));
        }
        return setMaturities.stream().sorted().mapToInt(Integer::intValue).toArray();
    }

    public int[] getMaturities(int moneynessBP) {
        try {
            return this.getGridNodesPerMoneyness().get(moneynessBP)[0];
        }
        catch (NullPointerException e) {
            return new int[0];
        }
    }

    public double[] getMaturities(double moneyness) {
        int[] maturitiesInMonths = this.getMaturities(this.convertMoneyness(moneyness));
        double[] maturities = new double[maturitiesInMonths.length];
        for (int index = 0; index < maturities.length; ++index) {
            maturities[index] = this.convertMaturity(maturitiesInMonths[index]);
        }
        return maturities;
    }

    public int[] getTenors() {
        HashSet<Integer> setTenors = new HashSet<Integer>();
        for (int moneyness : this.getGridNodesPerMoneyness().keySet()) {
            setTenors.addAll(Arrays.asList((Integer[])IntStream.of(this.keyMap.get(moneyness)[1]).boxed().toArray(Integer[]::new)));
        }
        return setTenors.stream().sorted().mapToInt(Integer::intValue).toArray();
    }

    public int[] getTenors(int moneynessBP, int maturityInMonths) {
        try {
            ArrayList<Integer> ret = new ArrayList<Integer>();
            for (int tenor : this.getGridNodesPerMoneyness().get(moneynessBP)[1]) {
                if (!this.containsEntryFor(maturityInMonths, tenor, moneynessBP)) continue;
                ret.add(tenor);
            }
            return ret.stream().mapToInt(Integer::intValue).toArray();
        }
        catch (NullPointerException e) {
            return new int[0];
        }
    }

    public double[] getTenors(double moneyness, double maturity) {
        int maturityInMonths = (int)Math.round(maturity * 12.0);
        int[] tenorsInMonths = this.getTenors(this.convertMoneyness(moneyness), maturityInMonths);
        double[] tenors = new double[tenorsInMonths.length];
        for (int index = 0; index < tenors.length; ++index) {
            tenors[index] = this.convertTenor(maturityInMonths, tenorsInMonths[index]);
        }
        return tenors;
    }

    private int convertMoneyness(double moneyness) {
        if (this.quotingConvention == QuotingConvention.PAYERVOLATILITYLOGNORMAL) {
            return (int)Math.round(moneyness * 100.0);
        }
        if (this.quotingConvention == QuotingConvention.RECEIVERPRICE) {
            return -((int)Math.round(moneyness * 10000.0));
        }
        return (int)Math.round(moneyness * 10000.0);
    }

    private double convertMaturity(int maturityInMonths) {
        Schedule schedule = this.fixMetaSchedule.generateSchedule(this.referenceDate, maturityInMonths, 12);
        return schedule.getFixing(0);
    }

    private double convertTenor(int maturityInMonths, int tenorInMonths) {
        Schedule schedule = this.fixMetaSchedule.generateSchedule(this.referenceDate, maturityInMonths, tenorInMonths);
        return schedule.getPayment(schedule.getNumberOfPeriods() - 1);
    }

    public boolean containsEntryFor(int maturityInMonths, int tenorInMonths, int moneynessBP) {
        return this.entryMap.containsKey(new DataKey(maturityInMonths, tenorInMonths, moneynessBP));
    }

    public double getValue(double maturity, double tenor, double moneyness) {
        return this.getValue(new DataKey(maturity, tenor, moneyness));
    }

    public double getValue(int maturityInMonths, int tenorInMonths, int moneynessBP) {
        return this.getValue(new DataKey(maturityInMonths, tenorInMonths, moneynessBP));
    }

    public double getValue(String tenorCode, int moneynessBP) {
        return this.getValue(new DataKey(tenorCode, moneynessBP));
    }

    private double getValue(DataKey key) {
        return this.entryMap.get(key);
    }

    public double getValue(double maturity, double tenor, double moneyness, QuotingConvention convention, double displacement, AnalyticModel model) {
        DataKey key = new DataKey(maturity, tenor, moneyness);
        return this.convertToConvention(this.getValue(key), key, convention, displacement, this.quotingConvention, this.displacement, model);
    }

    public double getValue(int maturityInMonths, int tenorInMonths, int moneynessBP, QuotingConvention convention, double displacement, AnalyticModel model) {
        DataKey key = new DataKey(maturityInMonths, tenorInMonths, moneynessBP);
        return this.convertToConvention(this.getValue(key), key, convention, displacement, this.quotingConvention, this.displacement, model);
    }

    public double getValue(String tenorCode, int moneynessBP, QuotingConvention convention, double displacement, AnalyticModel model) {
        DataKey key = new DataKey(tenorCode, moneynessBP);
        return this.convertToConvention(this.getValue(key), key, convention, displacement, this.quotingConvention, this.displacement, model);
    }

    private double convertToConvention(double value, DataKey key, QuotingConvention toConvention, double toDisplacement, QuotingConvention fromConvention, double fromDisplacement, AnalyticModel model) {
        if (toConvention == fromConvention) {
            if (toConvention != QuotingConvention.PAYERVOLATILITYLOGNORMAL) {
                return value;
            }
            if (toDisplacement == fromDisplacement) {
                return value;
            }
            return this.convertToConvention(this.convertToConvention(value, key, QuotingConvention.PAYERPRICE, 0.0, fromConvention, fromDisplacement, model), key, toConvention, toDisplacement, QuotingConvention.PAYERPRICE, 0.0, model);
        }
        Schedule floatSchedule = this.floatMetaSchedule.generateSchedule(this.getReferenceDate(), key.maturity, key.tenor);
        Schedule fixSchedule = this.fixMetaSchedule.generateSchedule(this.getReferenceDate(), key.maturity, key.tenor);
        double forward = Swap.getForwardSwapRate(fixSchedule, floatSchedule, model.getForwardCurve(this.forwardCurveName), model);
        double optionMaturity = floatSchedule.getFixing(0);
        double offset = (double)key.moneyness / 10000.0;
        double optionStrike = forward + (this.quotingConvention == QuotingConvention.RECEIVERPRICE ? -offset : offset);
        double payoffUnit = SwapAnnuity.getSwapAnnuity(fixSchedule.getFixing(0), fixSchedule, model.getDiscountCurve(this.discountCurveName), model);
        if (toConvention.equals((Object)QuotingConvention.PAYERPRICE) && fromConvention.equals((Object)QuotingConvention.PAYERVOLATILITYLOGNORMAL)) {
            return AnalyticFormulas.blackScholesGeneralizedOptionValue(forward + fromDisplacement, value, optionMaturity, optionStrike + fromDisplacement, payoffUnit);
        }
        if (toConvention.equals((Object)QuotingConvention.PAYERPRICE) && fromConvention.equals((Object)QuotingConvention.PAYERVOLATILITYNORMAL)) {
            return AnalyticFormulas.bachelierOptionValue(forward, value, optionMaturity, optionStrike, payoffUnit);
        }
        if (toConvention.equals((Object)QuotingConvention.PAYERPRICE) && fromConvention.equals((Object)QuotingConvention.RECEIVERPRICE)) {
            return value + (forward - optionStrike) * payoffUnit;
        }
        if (toConvention.equals((Object)QuotingConvention.PAYERVOLATILITYLOGNORMAL) && fromConvention.equals((Object)QuotingConvention.PAYERPRICE)) {
            return AnalyticFormulas.blackScholesOptionImpliedVolatility(forward + toDisplacement, optionMaturity, optionStrike + toDisplacement, payoffUnit, value);
        }
        if (toConvention.equals((Object)QuotingConvention.PAYERVOLATILITYNORMAL) && fromConvention.equals((Object)QuotingConvention.PAYERPRICE)) {
            return AnalyticFormulas.bachelierOptionImpliedVolatility(forward, optionMaturity, optionStrike, payoffUnit, value);
        }
        if (toConvention.equals((Object)QuotingConvention.RECEIVERPRICE) && fromConvention.equals((Object)QuotingConvention.PAYERPRICE)) {
            return value - (forward - optionStrike) * payoffUnit;
        }
        return this.convertToConvention(this.convertToConvention(value, key, QuotingConvention.PAYERPRICE, 0.0, fromConvention, fromDisplacement, model), key, toConvention, toDisplacement, QuotingConvention.PAYERPRICE, 0.0, model);
    }

    public int size() {
        return this.entryMap.size();
    }

    public LocalDate getReferenceDate() {
        return this.referenceDate;
    }

    public QuotingConvention getQuotingConvention() {
        return this.quotingConvention;
    }

    public double getDisplacement() {
        return this.displacement;
    }

    public String getForwardCurveName() {
        return this.forwardCurveName;
    }

    public String getDiscountCurveName() {
        return this.discountCurveName;
    }

    public SchedulePrototype getFloatMetaSchedule() {
        return this.floatMetaSchedule;
    }

    public SchedulePrototype getFixMetaSchedule() {
        return this.fixMetaSchedule;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(super.toString());
        builder.append("[referenceDate= " + this.getReferenceDate() + ", quotingConvention= " + this.getQuotingConvention() + ", displacement= " + this.getDisplacement() + ", forwardCurveName= " + this.getForwardCurveName() + ", discountCurveName= " + this.getDiscountCurveName() + ", floatMetaSchedule= " + this.getFloatMetaSchedule() + ", fixMetaSchedule= " + this.getFixMetaSchedule() + ", Entries:\n");
        builder.append("Maturity\tTenor\tMoneyness\tValue\n");
        for (DataKey key : this.entryMap.keySet()) {
            builder.append(key.maturity + "\t" + key.tenor + "\t" + key.moneyness + "\t" + this.getValue(key) + "\n");
        }
        builder.append("]");
        return builder.toString();
    }

    public static enum QuotingConvention {
        PAYERVOLATILITYLOGNORMAL,
        PAYERVOLATILITYNORMAL,
        PAYERPRICE,
        RECEIVERPRICE;

    }

    private class DataKey
    implements Serializable {
        private static final long serialVersionUID = -8284316295640713492L;
        private final int maturity;
        private final int tenor;
        private final int moneyness;

        DataKey(int maturity, int tenor, int moneyness) {
            this.maturity = maturity;
            this.tenor = tenor;
            this.moneyness = moneyness;
        }

        DataKey(double maturity, double tenor, double moneyness) {
            this.maturity = (int)Math.round(maturity * 12.0);
            this.tenor = (int)Math.round((tenor - maturity) * 12.0);
            this.moneyness = SwaptionDataLattice.this.convertMoneyness(moneyness);
        }

        DataKey(String tenorCode, int moneyness) {
            String[] inputs = tenorCode.split("(?<=\\D)(?=\\d)|(?<=\\d)(?=\\D)", 4);
            this.maturity = Integer.parseInt(inputs[0]) * (inputs[1].equalsIgnoreCase("Y") ? 12 : (inputs[1].equalsIgnoreCase("M") ? 1 : 0));
            this.tenor = Integer.parseInt(inputs[2]) * (inputs[3].equalsIgnoreCase("Y") ? 12 : (inputs[3].equalsIgnoreCase("M") ? 1 : 0));
            this.moneyness = moneyness;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || other.getClass() != this.getClass()) {
                return false;
            }
            if (this.maturity != ((DataKey)other).maturity || this.tenor != ((DataKey)other).tenor) {
                return false;
            }
            return this.moneyness == ((DataKey)other).moneyness;
        }

        public int hashCode() {
            return this.maturity + 100 * this.tenor + 10000 * this.moneyness;
        }
    }
}

