/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.model.volatility.caplet;

import net.finmath.marketdata.model.volatility.caplet.CapTenorStructure;

public class CapVolMarketData {
    private final CapTenorStructure capTenorStructure;
    private final double[] expiryVectorInYears;
    private final int[] expiryVectorInMonths;
    private final double[] strikeVector;
    private final double[][] capVolatilities;
    private final double shift;
    private final int underlyingTenorInMonths;
    private final int tenorChangeTimeInMonths;
    private final int underlyingTenorInMonthsBeforeChange;
    private final String index;
    private final String indexBeforeChange;
    private final String discountIndex;

    public CapVolMarketData(String index, String discountIndex, String indexBeforeChange, CapTenorStructure capTenorStructure, int[] expiryVectorInMonths, double[] strikeVector, double[][] capVolatilities, double shift, int underlyingTenorInMonths, int tenorChangeTimeInMonths, int underlyingTenorInMonthsBeforeChange) {
        this.capTenorStructure = capTenorStructure;
        this.expiryVectorInMonths = expiryVectorInMonths;
        this.strikeVector = strikeVector;
        this.capVolatilities = capVolatilities;
        this.shift = shift;
        this.underlyingTenorInMonths = underlyingTenorInMonths;
        this.tenorChangeTimeInMonths = tenorChangeTimeInMonths;
        this.underlyingTenorInMonthsBeforeChange = underlyingTenorInMonthsBeforeChange;
        this.index = index;
        this.indexBeforeChange = indexBeforeChange;
        this.discountIndex = discountIndex;
        if (this.expiryVectorInMonths.length != this.capVolatilities.length) {
            throw new IllegalArgumentException("number of maturities and matrix not compatible. Maturity dates: " + this.expiryVectorInMonths.length + ", Matrix rows: " + this.capVolatilities[0].length);
        }
        if (this.strikeVector.length != this.capVolatilities[0].length) {
            throw new IllegalArgumentException("number of strikes and matrix not compatible. Strikes: " + this.strikeVector.length + ", Matrix columns: " + this.capVolatilities[0].length);
        }
        this.expiryVectorInYears = new double[this.expiryVectorInMonths.length];
        for (int i = 0; i < this.expiryVectorInMonths.length; ++i) {
            this.expiryVectorInYears[i] = (double)this.expiryVectorInMonths[i] / 12.0;
        }
    }

    public CapVolMarketData(String index, String discountIndex, CapTenorStructure capTenorStructure, int[] expiryVectorInMonths, double[] strikeVector, double[][] capVolatilities, double shift, int underlyingTenorInMonths) {
        this(index, discountIndex, null, capTenorStructure, expiryVectorInMonths, strikeVector, capVolatilities, shift, underlyingTenorInMonths, 0, underlyingTenorInMonths);
    }

    public double getCapVolData(int expiry, double strike) {
        return this.capVolatilities[this.getRowIndex(expiry)][this.getColumnIndex(strike)];
    }

    public double getCapVolData(int i, int j) {
        return this.capVolatilities[i][j];
    }

    public double getShift() {
        return this.shift;
    }

    public int getNumberOfStrikes() {
        return this.strikeVector.length;
    }

    public int getNumberOfExpiryDates() {
        return this.expiryVectorInMonths.length;
    }

    public int getMaxExpiryInMonths() {
        return this.expiryVectorInMonths[this.expiryVectorInMonths.length - 1];
    }

    public double getMaxExpiryInYears() {
        return this.expiryVectorInYears[this.expiryVectorInYears.length - 1];
    }

    public int getExpiryInMonths(int i) {
        return this.expiryVectorInMonths[i];
    }

    public double getExpiryInYears(int i) {
        return this.expiryVectorInYears[i];
    }

    public double[][] getVolMatrix() {
        return this.capVolatilities;
    }

    public double[] getStrikeVector() {
        return this.strikeVector;
    }

    public int[] getExpiryVectorInMonths() {
        return this.expiryVectorInMonths;
    }

    public double[] getExpiryVectorInYears() {
        return this.expiryVectorInYears;
    }

    public int getRowIndex(int expiryInMonths) {
        for (int i = 0; i < this.expiryVectorInMonths.length; ++i) {
            if (this.expiryVectorInMonths[i] != expiryInMonths) continue;
            return i;
        }
        return -1;
    }

    public double getStrike(int j) {
        return this.strikeVector[j];
    }

    public int getColumnIndex(double strike) {
        for (int j = 0; j < this.strikeVector.length; ++j) {
            if (this.strikeVector[j] != strike) continue;
            return j;
        }
        return -1;
    }

    public CapTenorStructure getCapTenorStructure() {
        return this.capTenorStructure;
    }

    public int getUnderlyingTenorInMonths() {
        return this.underlyingTenorInMonths;
    }

    public int getUnderlyingTenorInMonthsBeforeChange() {
        return this.underlyingTenorInMonthsBeforeChange;
    }

    public int getTenorChangeTimeInMonths() {
        return this.tenorChangeTimeInMonths;
    }

    public String getIndex() {
        return this.index;
    }

    public String getIndexBeforeChange() {
        return this.indexBeforeChange;
    }

    public String getDiscountIndex() {
        return this.discountIndex;
    }

    public void setCapVolMatrixEntry(int i, int j, double newValue) {
        this.capVolatilities[i][j] = newValue;
    }

    public static String getOffsetCodeFromIndex(String index) {
        String[] split = index.split("(?<=\\D)(?=\\d)");
        return split[split.length - 1];
    }
}

