/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.products;

import net.finmath.marketdata.model.AnalyticModel;
import net.finmath.marketdata.model.curves.DiscountCurve;
import net.finmath.marketdata.products.AbstractAnalyticProduct;
import net.finmath.marketdata.products.AnalyticProduct;
import net.finmath.time.Schedule;

public class Deposit
extends AbstractAnalyticProduct
implements AnalyticProduct {
    private final Schedule schedule;
    private final double rate;
    private final String discountCurveName;

    public Deposit(Schedule schedule, double rate, String discountCurveName) {
        this.schedule = schedule;
        this.rate = rate;
        this.discountCurveName = discountCurveName;
        if (schedule.getNumberOfPeriods() > 1) {
            throw new IllegalArgumentException("Number of periods has to be 1: Change frequency to 'tenor'!");
        }
    }

    @Override
    public double getValue(double evaluationTime, AnalyticModel model) {
        if (model == null) {
            throw new IllegalArgumentException("model==null");
        }
        DiscountCurve discountCurve = model.getDiscountCurve(this.discountCurveName);
        if (discountCurve == null) {
            throw new IllegalArgumentException("No discount curve with name '" + this.discountCurveName + "' was found in the model:\n" + model.toString());
        }
        double maturity = this.schedule.getPayment(0);
        if (evaluationTime > maturity) {
            return 0.0;
        }
        double payoutDate = this.schedule.getPeriodStart(0);
        double periodLength = this.schedule.getPeriodLength(0);
        double discountFactor = discountCurve.getDiscountFactor(model, maturity);
        double discountFactorPayout = discountCurve.getDiscountFactor(model, payoutDate);
        if (evaluationTime > payoutDate) {
            return discountFactor * (1.0 + this.rate * periodLength);
        }
        return discountFactor * (1.0 + this.rate * periodLength) - discountFactorPayout;
    }

    public double getRate(AnalyticModel model) {
        if (model == null) {
            throw new IllegalArgumentException("model==null");
        }
        DiscountCurve discountCurve = model.getDiscountCurve(this.discountCurveName);
        if (discountCurve == null) {
            throw new IllegalArgumentException("No discount curve with name '" + this.discountCurveName + "' was found in the model:\n" + model.toString());
        }
        double payoutDate = this.schedule.getPeriodStart(0);
        double maturity = this.schedule.getPayment(0);
        double periodLength = this.schedule.getPeriodLength(0);
        double discountFactor = discountCurve.getDiscountFactor(model, maturity);
        double discountFactorPayout = discountCurve.getDiscountFactor(model, payoutDate);
        return (discountFactorPayout / discountFactor - 1.0) / periodLength;
    }

    public Schedule getSchedule() {
        return this.schedule;
    }

    public String getDiscountCurveName() {
        return this.discountCurveName;
    }

    public double getRate() {
        return this.rate;
    }

    public double getPeriodEndTime() {
        double tenorEnd = this.schedule.getPeriodEnd(0);
        return tenorEnd;
    }

    public double getFixingTime() {
        double fixingDate = this.schedule.getFixing(0);
        return fixingDate;
    }

    public String toString() {
        return "Deposit [schedule=" + this.schedule + ", rate=" + this.rate + ", forwardCurveName=" + this.discountCurveName + "]";
    }
}

