/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata2.interpolation;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import net.finmath.montecarlo.RandomVariableFromDoubleArray;
import net.finmath.stochastic.RandomVariable;

public class RationalFunctionInterpolation {
    private final double[] points;
    private final RandomVariable[] values;
    private InterpolationMethod interpolationMethod = InterpolationMethod.LINEAR;
    private ExtrapolationMethod extrapolationMethod = ExtrapolationMethod.DEFAULT;
    private RationalFunction[] interpolatingRationalFunctions;
    private transient Object interpolatingRationalFunctionsLazyInitLock = new Object();

    public RationalFunctionInterpolation(double[] points, RandomVariable[] values) {
        this.points = points;
        this.values = values;
    }

    public RationalFunctionInterpolation(double[] points, RandomVariable[] values, InterpolationMethod interpolationMethod, ExtrapolationMethod extrapolationMethod) {
        this.points = points;
        this.values = values;
        this.interpolationMethod = interpolationMethod;
        this.extrapolationMethod = extrapolationMethod;
    }

    public InterpolationMethod getInterpolationMethod() {
        return this.interpolationMethod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RandomVariable getValue(double x) {
        Object object = this.interpolatingRationalFunctionsLazyInitLock;
        synchronized (object) {
            if (this.interpolatingRationalFunctions == null) {
                this.doCreateRationalFunctions();
            }
        }
        int pointIndex = Arrays.binarySearch(this.points, x);
        if (pointIndex >= 0) {
            return this.values[pointIndex];
        }
        int intervalIndex = -pointIndex - 2;
        if (intervalIndex < 0) {
            if (this.extrapolationMethod == ExtrapolationMethod.CONSTANT) {
                return this.values[0];
            }
            if (this.extrapolationMethod == ExtrapolationMethod.LINEAR) {
                return this.values[0].add(this.values[1].sub(this.values[0]).div(this.points[1] - this.points[0]).mult(x - this.points[0]));
            }
            intervalIndex = 0;
        } else if (intervalIndex > this.points.length - 2) {
            if (this.extrapolationMethod == ExtrapolationMethod.CONSTANT) {
                return this.values[this.points.length - 1];
            }
            if (this.extrapolationMethod == ExtrapolationMethod.LINEAR) {
                return this.values[this.points.length - 1].add(this.values[this.points.length - 2].sub(this.values[this.points.length - 1]).div(this.points[this.points.length - 2] - this.points[this.points.length - 1]).mult(x - this.points[this.points.length - 1]));
            }
            intervalIndex = this.points.length - 2;
        }
        RationalFunction rationalFunction = this.interpolatingRationalFunctions[intervalIndex];
        return rationalFunction.getValue(x - this.points[intervalIndex]);
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.interpolatingRationalFunctionsLazyInitLock = new Object();
    }

    private void doCreateRationalFunctions() {
        switch (this.interpolationMethod) {
            case PIECEWISE_CONSTANT: 
            case PIECEWISE_CONSTANT_LEFTPOINT: 
            case PIECEWISE_CONSTANT_RIGHTPOINT: {
                this.doCreateRationalFunctionsForPiecewiseConstantInterpolation();
                break;
            }
            default: {
                this.doCreateRationalFunctionsForLinearInterpolation();
            }
        }
    }

    private void doCreateRationalFunctionsForPiecewiseConstantInterpolation() {
        this.interpolatingRationalFunctions = new RationalFunction[this.points.length - 1];
        for (int pointIndex = 0; pointIndex < this.points.length - 1; ++pointIndex) {
            RandomVariable[] numeratorPolynomCoeff = this.interpolationMethod == InterpolationMethod.PIECEWISE_CONSTANT_RIGHTPOINT ? new RandomVariable[]{this.values[pointIndex + 1]} : new RandomVariable[]{this.values[pointIndex]};
            this.interpolatingRationalFunctions[pointIndex] = new RationalFunction(numeratorPolynomCoeff);
        }
    }

    private void doCreateRationalFunctionsForLinearInterpolation() {
        this.interpolatingRationalFunctions = new RationalFunction[this.points.length - 1];
        for (int pointIndex = 0; pointIndex < this.points.length - 1; ++pointIndex) {
            RandomVariable[] numeratorPolynomCoeff = new RandomVariable[2];
            double xl = this.points[pointIndex];
            double xr = this.points[pointIndex + 1];
            RandomVariable fl = this.values[pointIndex];
            RandomVariable fr = this.values[pointIndex + 1];
            numeratorPolynomCoeff[1] = fr.sub(fl).div(xr - xl);
            numeratorPolynomCoeff[0] = fl;
            this.interpolatingRationalFunctions[pointIndex] = new RationalFunction(numeratorPolynomCoeff);
        }
    }

    public static enum InterpolationMethod {
        PIECEWISE_CONSTANT,
        PIECEWISE_CONSTANT_LEFTPOINT,
        PIECEWISE_CONSTANT_RIGHTPOINT,
        LINEAR,
        CUBIC_SPLINE,
        AKIMA,
        AKIMA_CONTINUOUS,
        HARMONIC_SPLINE,
        HARMONIC_SPLINE_WITH_MONOTONIC_FILTERING;

    }

    public static enum ExtrapolationMethod {
        DEFAULT,
        CONSTANT,
        LINEAR;

    }

    private static class RationalFunction {
        private final RandomVariable[] coefficientsNumerator;
        private final RandomVariable[] coefficientsDenominator;

        RationalFunction(RandomVariable[] coefficientsNumerator, RandomVariable[] coefficientsDenominator) {
            this.coefficientsNumerator = coefficientsNumerator;
            this.coefficientsDenominator = coefficientsDenominator;
        }

        RationalFunction(RandomVariable[] coefficients) {
            this.coefficientsNumerator = coefficients;
            this.coefficientsDenominator = null;
        }

        public RandomVariable getValue(double x) {
            RandomVariable powerOfX = new RandomVariableFromDoubleArray(1.0);
            RandomVariable valueNumerator = this.coefficientsNumerator[0];
            for (int i = 1; i < this.coefficientsNumerator.length; ++i) {
                powerOfX = powerOfX.mult(x);
                valueNumerator = valueNumerator.addProduct(this.coefficientsNumerator[i], powerOfX);
            }
            if (this.coefficientsDenominator == null) {
                return valueNumerator;
            }
            RandomVariable valueDenominator = this.coefficientsDenominator[0];
            powerOfX = new RandomVariableFromDoubleArray(1.0);
            for (int i = 1; i < this.coefficientsDenominator.length; ++i) {
                powerOfX = powerOfX.mult(x);
                valueDenominator = valueDenominator.addProduct(this.coefficientsDenominator[i], powerOfX);
            }
            return valueNumerator.div(valueDenominator);
        }
    }
}

