/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata2.model.volatilities;

import java.time.LocalDate;
import net.finmath.functions.AnalyticFormulas;
import net.finmath.marketdata.model.AnalyticModel;
import net.finmath.marketdata.model.curves.DiscountCurve;
import net.finmath.marketdata.model.curves.ForwardCurve;
import net.finmath.marketdata2.model.volatilities.VolatilitySurface;
import net.finmath.time.daycount.DayCountConvention;

public abstract class AbstractVolatilitySurface
implements VolatilitySurface,
Cloneable {
    private final LocalDate referenceDate;
    private final String name;
    private ForwardCurve forwardCurve;
    private DiscountCurve discountCurve;
    private VolatilitySurface.QuotingConvention quotingConvention;
    private DayCountConvention daycountConvention;

    public AbstractVolatilitySurface(String name, LocalDate referenceDate, ForwardCurve forwardCurve, DiscountCurve discountCurve, VolatilitySurface.QuotingConvention quotingConvention, DayCountConvention daycountConvention) {
        this.name = name;
        this.referenceDate = referenceDate;
        this.forwardCurve = forwardCurve;
        this.discountCurve = discountCurve;
        this.quotingConvention = quotingConvention;
        this.daycountConvention = daycountConvention;
    }

    public AbstractVolatilitySurface(String name, LocalDate referenceDate) {
        this.name = name;
        this.referenceDate = referenceDate;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public LocalDate getReferenceDate() {
        return this.referenceDate;
    }

    public String toString() {
        return super.toString() + "\n\"" + this.getName() + "\"";
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public VolatilitySurface.QuotingConvention getQuotingConvention() {
        return this.quotingConvention;
    }

    public double convertFromTo(AnalyticModel model, double optionMaturity, double optionStrike, double value, VolatilitySurface.QuotingConvention fromQuotingConvention, VolatilitySurface.QuotingConvention toQuotingConvention) {
        double daycountFraction;
        if (fromQuotingConvention.equals((Object)toQuotingConvention)) {
            return value;
        }
        if (this.getDiscountCurve() == null) {
            throw new IllegalArgumentException("Missing discount curve. Conversion of QuotingConvention requires forward curve and discount curve to be set.");
        }
        if (this.getForwardCurve() == null) {
            throw new IllegalArgumentException("Missing forward curve. Conversion of QuotingConvention requires forward curve and discount curve to be set.");
        }
        double periodStart = optionMaturity;
        double periodEnd = periodStart + this.getForwardCurve().getPaymentOffset(periodStart);
        double forward = this.getForwardCurve().getForward(model, periodStart);
        if (this.getDaycountConvention() != null) {
            LocalDate startDate = this.referenceDate.plusDays((int)Math.round(periodStart * 365.0));
            LocalDate endDate = this.referenceDate.plusDays((int)Math.round(periodEnd * 365.0));
            daycountFraction = this.getDaycountConvention().getDaycountFraction(startDate, endDate);
        } else {
            daycountFraction = this.getForwardCurve().getPaymentOffset(periodStart);
        }
        double payoffUnit = this.getDiscountCurve().getDiscountFactor(optionMaturity + this.getForwardCurve().getPaymentOffset(optionMaturity)) * daycountFraction;
        if (toQuotingConvention.equals((Object)VolatilitySurface.QuotingConvention.PRICE) && fromQuotingConvention.equals((Object)VolatilitySurface.QuotingConvention.VOLATILITYLOGNORMAL)) {
            return AnalyticFormulas.blackScholesGeneralizedOptionValue(forward, value, optionMaturity, optionStrike, payoffUnit);
        }
        if (toQuotingConvention.equals((Object)VolatilitySurface.QuotingConvention.PRICE) && fromQuotingConvention.equals((Object)VolatilitySurface.QuotingConvention.VOLATILITYNORMAL)) {
            return AnalyticFormulas.bachelierOptionValue(forward, value, optionMaturity, optionStrike, payoffUnit);
        }
        if (toQuotingConvention.equals((Object)VolatilitySurface.QuotingConvention.VOLATILITYLOGNORMAL) && fromQuotingConvention.equals((Object)VolatilitySurface.QuotingConvention.PRICE)) {
            return AnalyticFormulas.blackScholesOptionImpliedVolatility(forward, optionMaturity, optionStrike, payoffUnit, value);
        }
        if (toQuotingConvention.equals((Object)VolatilitySurface.QuotingConvention.VOLATILITYNORMAL) && fromQuotingConvention.equals((Object)VolatilitySurface.QuotingConvention.PRICE)) {
            return AnalyticFormulas.bachelierOptionImpliedVolatility(forward, optionMaturity, optionStrike, payoffUnit, value);
        }
        return this.convertFromTo(model, optionMaturity, optionStrike, this.convertFromTo(model, optionMaturity, optionStrike, value, fromQuotingConvention, VolatilitySurface.QuotingConvention.PRICE), VolatilitySurface.QuotingConvention.PRICE, toQuotingConvention);
    }

    public double convertFromTo(double optionMaturity, double optionStrike, double value, VolatilitySurface.QuotingConvention fromQuotingConvention, VolatilitySurface.QuotingConvention toQuotingConvention) {
        return this.convertFromTo(null, optionMaturity, optionStrike, value, fromQuotingConvention, toQuotingConvention);
    }

    public ForwardCurve getForwardCurve() {
        return this.forwardCurve;
    }

    public DiscountCurve getDiscountCurve() {
        return this.discountCurve;
    }

    public DayCountConvention getDaycountConvention() {
        return this.daycountConvention;
    }
}

