/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata2.products;

import net.finmath.marketdata2.model.AnalyticModel;
import net.finmath.marketdata2.model.curves.DiscountCurveInterface;
import net.finmath.marketdata2.products.AbstractAnalyticProduct;
import net.finmath.marketdata2.products.AnalyticProduct;
import net.finmath.stochastic.RandomVariable;
import net.finmath.time.Schedule;

public class Deposit
extends AbstractAnalyticProduct
implements AnalyticProduct {
    private final Schedule schedule;
    private final double rate;
    private final String discountCurveName;

    public Deposit(Schedule schedule, double rate, String discountCurveName) {
        this.schedule = schedule;
        this.rate = rate;
        this.discountCurveName = discountCurveName;
        if (schedule.getNumberOfPeriods() > 1) {
            throw new IllegalArgumentException("Number of periods has to be 1: Change frequency to 'tenor'!");
        }
    }

    @Override
    public RandomVariable getValue(double evaluationTime, AnalyticModel model) {
        if (model == null) {
            throw new IllegalArgumentException("model==null");
        }
        DiscountCurveInterface discountCurve = model.getDiscountCurve(this.discountCurveName);
        if (discountCurve == null) {
            throw new IllegalArgumentException("No discount curve with name '" + this.discountCurveName + "' was found in the model:\n" + model.toString());
        }
        double maturity = this.schedule.getPayment(0);
        if (evaluationTime > maturity) {
            model.getRandomVariableForConstant(0.0);
        }
        double payoutDate = this.schedule.getPeriodStart(0);
        double periodLength = this.schedule.getPeriodLength(0);
        RandomVariable discountFactor = discountCurve.getDiscountFactor(model, maturity);
        RandomVariable discountFactorPayout = discountCurve.getDiscountFactor(model, payoutDate);
        RandomVariable value = evaluationTime > payoutDate ? discountFactor.mult(1.0 + this.rate * periodLength) : discountFactor.mult(1.0 + this.rate * periodLength).sub(discountFactorPayout);
        return value.div(discountCurve.getDiscountFactor(model, evaluationTime));
    }

    public RandomVariable getRate(AnalyticModel model) {
        if (model == null) {
            throw new IllegalArgumentException("model==null");
        }
        DiscountCurveInterface discountCurve = model.getDiscountCurve(this.discountCurveName);
        if (discountCurve == null) {
            throw new IllegalArgumentException("No discount curve with name '" + this.discountCurveName + "' was found in the model:\n" + model.toString());
        }
        double payoutDate = this.schedule.getPeriodStart(0);
        double maturity = this.schedule.getPayment(0);
        double periodLength = this.schedule.getPeriodLength(0);
        RandomVariable discountFactor = discountCurve.getDiscountFactor(model, maturity);
        RandomVariable discountFactorPayout = discountCurve.getDiscountFactor(model, payoutDate);
        return discountFactorPayout.div(discountFactor).sub(1.0).div(periodLength);
    }

    public Schedule getSchedule() {
        return this.schedule;
    }

    public String getDiscountCurveName() {
        return this.discountCurveName;
    }

    public double getRate() {
        return this.rate;
    }

    public double getPeriodEndTime() {
        double tenorEnd = this.schedule.getPeriodEnd(0);
        return tenorEnd;
    }

    public double getFixingTime() {
        double fixingDate = this.schedule.getFixing(0);
        return fixingDate;
    }

    public String toString() {
        return "Deposit [schedule=" + this.schedule + ", rate=" + this.rate + ", forwardCurveName=" + this.discountCurveName + "]";
    }
}

