/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata2.products;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.finmath.marketdata2.model.AnalyticModel;
import net.finmath.marketdata2.products.AbstractAnalyticProduct;
import net.finmath.marketdata2.products.AnalyticProduct;
import net.finmath.stochastic.RandomVariable;

public class Portfolio
extends AbstractAnalyticProduct
implements AnalyticProduct {
    private final ArrayList<AnalyticProduct> products = new ArrayList();
    private final ArrayList<Double> weights = new ArrayList();

    public Portfolio(List<AnalyticProduct> products, List<Double> weights) {
        this.products.addAll(products);
        this.weights.addAll(weights);
    }

    public Portfolio(Portfolio portfolio, List<AnalyticProduct> products, List<Double> weights) {
        this.products.addAll(portfolio.getProducts());
        this.weights.addAll(portfolio.getWeights());
        this.products.addAll(products);
        this.weights.addAll(weights);
    }

    public Portfolio(AnalyticProduct product, double weight) {
        this.products.add(product);
        this.weights.add(weight);
    }

    public Portfolio(List<AnalyticProduct> products) {
        this(products, Collections.nCopies(products.size(), 1.0));
    }

    @Override
    public RandomVariable getValue(final double evaluationTime, final AnalyticModel model) {
        RandomVariable value = model.getRandomVariableForConstant(0.0);
        List<RandomVariable> productValues = this.products.parallelStream().map(new Function<AnalyticProduct, RandomVariable>(){

            @Override
            public RandomVariable apply(AnalyticProduct product) {
                return product.getValue(evaluationTime, model);
            }
        }).collect(Collectors.toList());
        List<RandomVariable> weightsRandomVariables = this.weights.parallelStream().map(new Function<Double, RandomVariable>(){

            @Override
            public RandomVariable apply(Double weight) {
                return model.getRandomVariableForConstant(weight);
            }
        }).collect(Collectors.toList());
        value = value.addSumProduct(productValues, weightsRandomVariables);
        return value;
    }

    public List<AnalyticProduct> getProducts() {
        return Collections.unmodifiableList(this.products);
    }

    public List<Double> getWeights() {
        return Collections.unmodifiableList(this.weights);
    }
}

